/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.util;

import com.mathworks.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.net.URI;

public class AbsoluteFile {
    private final File fFile;

    public AbsoluteFile(String string) {
        this(new File(string));
    }

    public AbsoluteFile(URI uRI) {
        this(new File(uRI));
    }

    public AbsoluteFile(File file) {
        if (file == null) {
            throw new IllegalArgumentException("File cannot be null.");
        }
        this.fFile = new File(FileUtils.normalizePathname(file.getAbsolutePath()));
    }

    public void deleteOnExit() {
        this.fFile.deleteOnExit();
    }

    public boolean createNewFile() throws IOException {
        return this.fFile.createNewFile();
    }

    public static AbsoluteFile createTempFile(String string, String string2) throws IOException {
        return new AbsoluteFile(File.createTempFile(string, string2));
    }

    public boolean exists() {
        return this.fFile.exists();
    }

    public boolean isDirectory() {
        return this.fFile.isDirectory();
    }

    public String getName() {
        return this.fFile.getName();
    }

    public String getPath() {
        return this.fFile.getAbsolutePath();
    }

    public URI toURI() {
        return this.fFile.toURI();
    }

    public File toFile() {
        return this.fFile;
    }
}

