/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.workflowui;

import com.mathworks.mlwidgets.explorer.util.ExplicitColorAndFontProvider;
import com.mathworks.mwswing.FontUtils;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.project.impl.SectionPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JComponent;

public final class WorkflowHeader {
    private final MJPanel fComponent;
    private final Map<String, Component> fPanes = new LinkedHashMap<String, Component>();
    private final Map<String, MJLabel> fLabels = new HashMap<String, MJLabel>();

    public WorkflowHeader() {
        this.fComponent = new Panel();
    }

    public void addPane(String string, Component component) {
        this.fPanes.put(string, component);
        MJLabel mJLabel = new MJLabel(string);
        mJLabel.setForeground(Color.WHITE);
        mJLabel.setOpaque(false);
        mJLabel.setFont(FontUtils.getSystemUIFont().deriveFont(16.0f));
        this.fComponent.add((Component)mJLabel);
        this.fLabels.put(string, mJLabel);
        this.updateLabelSizes();
        component.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                WorkflowHeader.this.updateLabelSizes();
            }
        });
    }

    private void updateLabelSizes() {
        int n = 0;
        for (Map.Entry<String, Component> entry : this.fPanes.entrySet()) {
            MJLabel mJLabel = this.fLabels.get(entry.getKey());
            Metrics metrics = new Metrics(n, entry.getValue());
            int n2 = metrics.tailRight - metrics.tailLeft;
            int n3 = metrics.arrowRight - metrics.arrowLeft;
            int n4 = mJLabel.getPreferredSize().width + n2 + n3 + 40;
            Component component = entry.getValue();
            if (component != null && component.getWidth() != 0 && component.getWidth() < n4) {
                component.setSize(new Dimension(n4, component.getHeight()));
                component.setPreferredSize(new Dimension(n4, component.getHeight()));
                component.setMinimumSize(new Dimension(n4, component.getHeight()));
                metrics = new Metrics(n, entry.getValue());
            }
            int n5 = (int)mJLabel.getPreferredSize().getHeight();
            mJLabel.setLocation(metrics.tailRight + 16, this.fComponent.getHeight() / 2 - n5 / 2 - 2);
            mJLabel.setSize(metrics.arrowLeft - metrics.tailRight - 16, n5);
            ++n;
        }
        this.fComponent.revalidate();
        this.fComponent.repaint();
    }

    public JComponent getComponent() {
        return this.fComponent;
    }

    public void remove() {
        this.fComponent.removeAll();
        this.fComponent.revalidate();
    }

    private class Panel
    extends MJPanel
    implements ExplicitColorAndFontProvider {
        Panel() {
            this.setLayout(null);
        }

        public Dimension getPreferredSize() {
            return new Dimension(0, 34);
        }

        public Dimension getMinimumSize() {
            return new Dimension(0, 34);
        }

        public void paintComponent(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setColor(SectionPanel.APP_BACKGROUND);
            graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
            int n = 0;
            for (Map.Entry entry : WorkflowHeader.this.fPanes.entrySet()) {
                Color color = new Color(39, 88, 142);
                Color color2 = new Color(13, 61, 115);
                Metrics metrics = new Metrics(n, (Component)entry.getValue());
                GeneralPath generalPath = new GeneralPath();
                generalPath.append(new Line2D.Double(metrics.tailLeft, 0.0, metrics.arrowLeft, 0.0), true);
                generalPath.append(new Line2D.Double(metrics.arrowLeft, 0.0, metrics.arrowRight, metrics.centerY), true);
                generalPath.append(new Line2D.Double(metrics.arrowRight, metrics.centerY, metrics.arrowLeft, metrics.maxY), true);
                generalPath.append(new Line2D.Double(metrics.arrowLeft, metrics.maxY, metrics.tailLeft, metrics.maxY), true);
                generalPath.append(new Line2D.Double(metrics.tailLeft, metrics.maxY, metrics.tailRight, metrics.centerY), true);
                generalPath.append(new Line2D.Double(metrics.tailRight, metrics.centerY, metrics.tailLeft, 0.0), true);
                graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, color, 0.0f, this.getHeight(), color2));
                graphics2D.fill(generalPath);
                ++n;
            }
            graphics2D.dispose();
        }
    }

    private class Metrics {
        final int arrowLeft;
        final int arrowRight;
        final int centerY;
        final int maxY;
        final int tailLeft;
        final int tailRight;

        Metrics(int n, Component component) {
            boolean bl = n == WorkflowHeader.this.fPanes.size() - 1;
            this.arrowLeft = bl ? component.getX() + component.getWidth() : component.getX() + component.getWidth() - 6;
            this.arrowRight = bl ? component.getX() + component.getWidth() : component.getX() + component.getWidth() + 10;
            this.centerY = WorkflowHeader.this.fComponent.getHeight() / 2;
            this.maxY = WorkflowHeader.this.fComponent.getHeight() - 1;
            this.tailLeft = n == 0 ? 0 : component.getX() + 3;
            this.tailRight = n == 0 ? 0 : component.getX() + 19;
        }
    }
}

