/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.textfield;

import com.mathworks.project.impl.TooltipWindow;
import com.mathworks.project.impl.textfield.FormatTipContent;
import com.mathworks.project.impl.textfield.FormattedTextField;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.tree.TreeUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public final class FormatTip {
    private TooltipWindow fToolTip;
    private Window fParentWindow;
    private FormatTipContent fContent;
    private Timer fFocusTimer;
    private boolean fAbove;
    private String fName;
    public static final Color BACKGROUND = PlatformInfo.isMacintosh() ? new Color(243, 243, 243) : new Color(221, 234, 248);
    public static final Color BORDER = PlatformInfo.isMacintosh() ? new Color(130, 130, 130) : new Color(20, 85, 148);

    public void close() {
        if (this.fToolTip != null) {
            this.fToolTip.dispose();
            this.fToolTip = null;
        }
        this.fContent = null;
        if (this.fFocusTimer != null) {
            this.fFocusTimer.stop();
            this.fFocusTimer = null;
        }
        this.fParentWindow = null;
    }

    public void setName(String string) {
        this.fName = string;
    }

    public static boolean isInstance(Window window) {
        return window instanceof TooltipWindow;
    }

    public void update(FormattedTextField formattedTextField) {
        this.fParentWindow = SwingUtilities.windowForComponent(formattedTextField.getComponent());
        FormatTipContent formatTipContent = formattedTextField.getTipProvider().getTipComponent(formattedTextField);
        if (formatTipContent == null || !this.focusedWindowIsRelevant() || !FormatTip.isShowing(formattedTextField.getComponent())) {
            this.close();
        } else {
            int n;
            Cloneable cloneable;
            if (formatTipContent.getToken() != null) {
                cloneable = formattedTextField.getTokenRect(formatTipContent.getToken());
                n = (int)(((Rectangle)cloneable).getX() + ((Rectangle)cloneable).getWidth() / 2.0);
            } else {
                n = (int)formattedTextField.getTextComponent().getPreferredSize().getWidth();
            }
            if (this.fToolTip != null && this.fContent.getComponent().equals(formatTipContent.getComponent())) {
                cloneable = this.computeScreenAnchorPoint(formattedTextField.getComponent(), n, formatTipContent.getComponent().getPreferredSize());
                if (!((Point)cloneable).equals(this.fToolTip.getScreenAnchorPoint())) {
                    this.fToolTip.setSizeAndLocation((int)((Point)cloneable).getX(), (int)((Point)cloneable).getY());
                }
                return;
            }
            cloneable = this.computeScreenAnchorPoint(formattedTextField.getComponent(), n, formatTipContent.getComponent().getPreferredSize());
            if (this.fToolTip == null || this.fToolTip.isAbove() != this.fAbove) {
                if (this.fToolTip != null) {
                    this.fToolTip.removeAll();
                    this.fToolTip.close();
                }
                this.fToolTip = new TooltipWindow(SwingUtilities.windowForComponent(formattedTextField.getComponent()), formattedTextField.getComponent(), this.fAbove, false, true, 0, BACKGROUND, BORDER);
                if (this.fName != null) {
                    this.fToolTip.setName(this.fName);
                }
            }
            this.fToolTip.update(formatTipContent.getComponent(), (int)((Point)cloneable).getX(), (int)((Point)cloneable).getY());
            this.fToolTip.setFocusableWindowState(false);
            this.fToolTip.setVisible(true);
            if (PlatformInfo.isLinux()) {
                Timer timer = new Timer(200, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        TooltipWindow tooltipWindow = FormatTip.this.fToolTip;
                        if (tooltipWindow != null) {
                            tooltipWindow.setFocusableWindowState(true);
                        }
                    }
                });
                timer.setRepeats(false);
                timer.start();
            } else {
                this.fToolTip.setFocusableWindowState(true);
            }
            this.startFocusTimer();
            this.fContent = formatTipContent;
        }
    }

    private static boolean isShowing(Component component) {
        if (!component.isShowing()) {
            return false;
        }
        JViewport jViewport = (JViewport)TreeUtils.findAncestorComponent((Component)component, JViewport.class);
        if (jViewport == null) {
            return true;
        }
        if (jViewport.getViewSize().equals(jViewport.getView().getSize()) && (jViewport = (JViewport)TreeUtils.findAncestorComponent((Component)jViewport.getParent(), JViewport.class)) == null) {
            return true;
        }
        Point point = component.getLocation();
        point = SwingUtilities.convertPoint(component.getParent(), point, jViewport.getView());
        point.y += component.getHeight();
        return jViewport.getViewRect().contains(point);
    }

    private boolean focusedWindowIsRelevant() {
        return this.fParentWindow != null && this.fParentWindow.isFocused() || this.fToolTip != null && this.fToolTip.isFocused();
    }

    private void startFocusTimer() {
        if (this.fFocusTimer == null) {
            this.fFocusTimer = new Timer(20, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (!FormatTip.this.focusedWindowIsRelevant()) {
                        FormatTip.this.close();
                    }
                }
            });
            this.fFocusTimer.setRepeats(true);
            this.fFocusTimer.start();
        }
    }

    private Point computeScreenAnchorPoint(Component component, int n, Dimension dimension) {
        Point point = new Point(n, component.getHeight());
        SwingUtilities.convertPointToScreen(point, component);
        boolean bl = this.fAbove = point.getY() + dimension.getHeight() + 5.0 >= Toolkit.getDefaultToolkit().getScreenSize().getHeight();
        if (this.fAbove) {
            point = new Point(n, 0);
            SwingUtilities.convertPointToScreen(point, component);
        }
        return point;
    }
}

