/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.settingsui.validation;

import com.mathworks.project.impl.BuiltInResources;
import com.mathworks.project.impl.settingsui.validation.ValidationRule;
import java.awt.event.KeyEvent;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.text.MessageFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NameFormatRule
extends ValidationRule {
    public static final String INVALID_CHARS = "<>\\\\/?*:|\"";
    public static final String REGEX = "[<>\\\\/?*:|\"]";
    public static final Pattern PATTERN = Pattern.compile("[<>\\\\/?*:|\"]");
    private static final CharsetEncoder asciiEncoder = Charset.forName("US-ASCII").newEncoder();

    private static boolean isPureAscii(String string) {
        return asciiEncoder.canEncode(string);
    }

    @Override
    public String getErrorMessage(KeyEvent keyEvent) {
        if (keyEvent == null) {
            return null;
        }
        char c = keyEvent.getKeyChar();
        if (INVALID_CHARS.indexOf(c) == -1) {
            if (!NameFormatRule.isPureAscii(c + "")) {
                return MessageFormat.format(BuiltInResources.getString("error.appname.nonasciichar"), Character.valueOf(c));
            }
            return null;
        }
        return MessageFormat.format(BuiltInResources.getString("error.appname.illegalcharacter"), Character.valueOf(c));
    }

    @Override
    public String getErrorMessage(String string) {
        if (string != null) {
            Matcher matcher = PATTERN.matcher(string);
            if (matcher.find()) {
                return MessageFormat.format(BuiltInResources.getString("error.appname.illegal.appname"), string, INVALID_CHARS);
            }
            if (!NameFormatRule.isPureAscii(string)) {
                return MessageFormat.format(BuiltInResources.getString("error.appname.nonasciistring"), string);
            }
        }
        return null;
    }
}

