/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.settingsui.validation;

import com.mathworks.project.api.ConfigurationValidator;
import com.mathworks.project.api.ReadableConfiguration;
import com.mathworks.project.api.Severity;
import com.mathworks.project.api.ValidationMessage;
import com.mathworks.project.impl.BuiltInResources;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class AuthoringValidator
implements ConfigurationValidator {
    private static final String APP_NAME_KEY = "param.appname";
    private static final String VERSION_KEY = "param.version";
    private static final Pattern VERSION_PATTERN = Pattern.compile("(\\d+\\.){1,3}+[\\d]+$");

    public List<ValidationMessage> validate(ReadableConfiguration readableConfiguration) {
        String string;
        ArrayList<ValidationMessage> arrayList = new ArrayList<ValidationMessage>();
        if ((readableConfiguration.getFileSetKeys().contains("fileset.rootdir") && readableConfiguration.getFileSet("fileset.rootdir").getCurrentCount() > 0 || readableConfiguration.getFileSetKeys().contains("fileset.main") && readableConfiguration.getFileSet("fileset.main").getCurrentCount() > 0) && ((string = readableConfiguration.getParamAsString(APP_NAME_KEY)) == null || string.length() == 0)) {
            arrayList.add(new ValidationMessage(Severity.ERROR, BuiltInResources.getString("error.appname.blank"), APP_NAME_KEY));
        }
        if ((string = readableConfiguration.getParamAsString(VERSION_KEY)) == null || !VERSION_PATTERN.matcher(string).matches() || string.startsWith("0")) {
            arrayList.add(new ValidationMessage(Severity.ERROR, BuiltInResources.getString("error.version.string"), VERSION_KEY));
        } else {
            String[] stringArray;
            for (String string2 : stringArray = string.split("\\.")) {
                if (string2.length() <= 5) continue;
                arrayList.add(new ValidationMessage(Severity.ERROR, BuiltInResources.getString("error.version.length"), VERSION_KEY));
            }
        }
        return arrayList;
    }
}

