/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.settingsui.table;

import com.mathworks.jmi.Matlab;
import com.mathworks.mwswing.ColorUtils;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.project.impl.BuiltInResources;
import com.mathworks.project.impl.model.Configuration;
import com.mathworks.project.impl.model.Param;
import com.mathworks.project.impl.model.ParamType;
import com.mathworks.project.impl.table.AbstractPropertyTableColumn;
import com.mathworks.project.impl.util.StringUtils;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;

public final class ValueColumn
extends AbstractPropertyTableColumn<Param> {
    private final Configuration fConfiguration;
    private final PropertyChangeListener fConfigurationListener;
    private final Map<String, JComponent> fLinks;

    public ValueColumn(Configuration configuration) {
        this(configuration, BuiltInResources.getString("settings.header.value"));
    }

    public ValueColumn(Configuration configuration, String string) {
        super(string);
        this.fConfiguration = configuration;
        this.fLinks = new HashMap<String, JComponent>();
        this.fConfigurationListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (Configuration.isMoreInfoVisibilityChange(propertyChangeEvent)) {
                    ValueColumn.this.updateLinkVisibility(ValueColumn.this.fConfiguration.getParamWithAffectedState(propertyChangeEvent));
                }
            }
        };
        this.fConfiguration.addPropertyChangeListener(this.fConfigurationListener);
    }

    @Override
    public boolean isEditable() {
        return true;
    }

    @Override
    public String getText(Param param) {
        int n;
        String string;
        if (param == null) {
            return "";
        }
        Object object = this.fConfiguration.getParamAsObject(param.getKey());
        if (param.getType() == ParamType.ENUM && !this.fConfiguration.areOptionsReallyLoaded(param.getKey())) {
            return BuiltInResources.getString("enum.loading");
        }
        if (object != null && param.getType() == ParamType.ENUM) {
            object = param.getOptionExpression() != null ? this.fConfiguration.getParamOptions(param.getKey()).getOptions().get(object) : param.getOptions().get(object);
        }
        if (object instanceof List) {
            object = StringUtils.listToDelimitedString((List)object);
        }
        if ((string = "" + object).equals("null") || string.equals("[]")) {
            return "";
        }
        if (string.equals("true")) {
            string = BuiltInResources.getString("param.boolean.true");
        }
        if (string.equals("false")) {
            string = BuiltInResources.getString("param.boolean.false");
        }
        if ((n = string.indexOf(10)) > -1) {
            string = string.substring(0, n) + " [...]";
        }
        return string;
    }

    private void updateLinkVisibility(final Param param) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                JComponent jComponent = (JComponent)ValueColumn.this.fLinks.get(param.getKey());
                if (jComponent != null) {
                    boolean bl = ValueColumn.this.fConfiguration.isMoreInfoVisible(param.getKey());
                    jComponent.setVisible(bl);
                    jComponent.setEnabled(bl);
                }
            }
        });
    }

    @Override
    public JComponent createLink(final Param param) {
        JComponent jComponent = this.fLinks.get(param.getKey());
        if (jComponent != null) {
            return jComponent;
        }
        if (param.getMoreInfoLinkText() != null) {
            LinkLabel linkLabel = new LinkLabel("<html><u>" + param.getMoreInfoLinkText() + "</u></html>", this.fConfiguration.isMoreInfoVisible(param.getKey()));
            linkLabel.setForeground(ColorUtils.getContrastingHyperlinkColor((Color)Color.WHITE));
            linkLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    new Matlab().evalConsoleOutput(param.getMoreInfoLinkCallback());
                }
            });
            this.fLinks.put(param.getKey(), (JComponent)((Object)linkLabel));
            return linkLabel;
        }
        return null;
    }

    public void dispose() {
        this.fConfiguration.removePropertyChangeListener(this.fConfigurationListener);
        this.fLinks.clear();
    }

    private class LinkLabel
    extends MJLabel {
        LinkLabel(String string, boolean bl) {
            super(string);
            this.updateLinkStatus(bl);
        }

        private void updateLinkStatus(boolean bl) {
            super.setVisible(bl);
            super.setEnabled(bl);
            super.setCursor(bl ? Cursor.getPredefinedCursor(12) : Cursor.getDefaultCursor());
        }

        public void setVisible(boolean bl) {
            this.updateLinkStatus(bl);
        }

        public void setEnabled(boolean bl) {
            this.updateLinkStatus(bl);
        }
    }
}

