/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.settingsui;

import com.mathworks.mwswing.FontUtils;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.project.impl.model.Param;
import com.mathworks.project.impl.model.Project;
import com.mathworks.project.impl.settingsui.StringWidget;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import javax.swing.text.JTextComponent;

public class WatermarkedStringWidget
extends StringWidget {
    private boolean watermarkIsDisplayed = true;
    private final String fWatermark;

    public WatermarkedStringWidget(String string, String string2, int n, int n2, boolean bl, boolean bl2, Param param, Project project) {
        super(string, string2, n, n2, bl, bl2, param, project);
        this.fWatermark = param.getName();
        final JTextComponent jTextComponent = this.getField();
        this.setWaterMarkString();
        if (!project.getConfiguration().getParamAsString(param.getKey()).isEmpty() && !project.getConfiguration().getParamAsString(param.getKey()).equals(jTextComponent.getText())) {
            this.setPlainFont();
        }
        jTextComponent.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                if (WatermarkedStringWidget.this.watermarkIsDisplayed) {
                    jTextComponent.setText("");
                    WatermarkedStringWidget.this.setPlainFont();
                }
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (!focusEvent.isTemporary()) {
                    WatermarkedStringWidget.this.setData(jTextComponent.getText().trim());
                }
            }
        });
        jTextComponent.setBorder(BorderFactory.createEmptyBorder(3, 7, 3, 3));
        if (this.getComponent() instanceof MJPanel) {
            ((MJPanel)this.getComponent()).setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY, 1));
        }
        if (this.getComponent() instanceof MJScrollPane) {
            ((MJScrollPane)this.getComponent()).setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY, 1));
        }
    }

    public boolean watermarkIsDisplayed() {
        return this.watermarkIsDisplayed;
    }

    private void setWaterMarkString() {
        this.watermarkIsDisplayed = true;
        this.getField().setFont(FontUtils.getSystemUIFont().deriveFont(2));
        this.getField().setForeground(Color.GRAY);
        this.getField().setText(this.fWatermark);
    }

    private void setPlainFont() {
        this.watermarkIsDisplayed = false;
        this.getField().setForeground(Color.BLACK);
        this.getField().setFont(FontUtils.getSystemUIFont());
    }

    @Override
    public void setData(final String string) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (WatermarkedStringWidget.this.getField() != null) {
                    if (string != null && !string.isEmpty()) {
                        if (!string.equals(WatermarkedStringWidget.this.getData())) {
                            WatermarkedStringWidget.this.getField().setText(string);
                            WatermarkedStringWidget.this.setPlainFont();
                            WatermarkedStringWidget.this.getField().scrollRectToVisible(new Rectangle(0, 0, 1, 1));
                        }
                    } else {
                        WatermarkedStringWidget.this.setWaterMarkString();
                    }
                    WatermarkedStringWidget.this.fireListeners();
                }
            }
        });
    }

    @Override
    public String getData() {
        return this.watermarkIsDisplayed ? "" : super.getData();
    }
}

