/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.settingsui;

import com.mathworks.matlab.api.editor.EditorLanguage;
import com.mathworks.project.impl.model.Param;
import com.mathworks.project.impl.settingsui.EnumWidgetStyle;
import com.mathworks.project.impl.settingsui.StringWidgetStyle;
import com.mathworks.widgets.SyntaxTextPane;
import com.mathworks.widgets.text.MWKit;
import com.mathworks.widgets.text.cplusplus.CCKit;
import com.mathworks.widgets.text.cplusplus.CKit;
import com.mathworks.widgets.text.cplusplus.CLanguage;
import com.mathworks.widgets.text.cplusplus.CPlusPlusLanguage;
import com.mathworks.widgets.text.java.JavaLanguage;
import com.mathworks.widgets.text.mcode.MKit;
import com.mathworks.widgets.text.mcode.MLanguage;
import com.mathworks.widgets.text.simscape.SimscapeLanguage;
import com.mathworks.widgets.text.tlc.TLCLanguage;
import com.mathworks.widgets.text.verilog.VerilogLanguage;
import com.mathworks.widgets.text.vhdl.VHDLLanguage;
import com.mathworks.widgets.text.xml.XMLLanguage;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.swing.text.EditorKit;

public final class ParamUtils {
    private ParamUtils() {
    }

    public static boolean getBooleanParamManagedResource(Param param) {
        return ParamUtils.readOptionalBooleanAttribute(param, "managed-resource", false);
    }

    public static int getStringParamLines(Param param) {
        return ParamUtils.readOptionalIntegerAttribute(param, "lines", 1);
    }

    public static int getStringParamColumns(Param param) {
        return ParamUtils.readOptionalIntegerAttribute(param, "columns", 0);
    }

    public static StringWidgetStyle getStringWidgetStyle(Param param) {
        String string = param.getInfrastructureAttributes().get("style");
        if (string != null && string.equals("file-selector")) {
            return StringWidgetStyle.FILE_SELECTOR;
        }
        if (string != null && string.equals("dir-selector")) {
            return StringWidgetStyle.DIR_SELECTOR;
        }
        if (string != null && string.equals("suggestion-box")) {
            return StringWidgetStyle.SUGGESTION_BOX;
        }
        if (string != null && string.equals("watermark")) {
            return StringWidgetStyle.WATERMARK;
        }
        return StringWidgetStyle.DEFAULT;
    }

    public static List<String> getSuggestions(Param param) {
        String string = param.getInfrastructureAttributes().get("suggestions");
        LinkedList<String> linkedList = new LinkedList<String>();
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
            while (stringTokenizer.hasMoreTokens()) {
                linkedList.add(stringTokenizer.nextToken().trim());
            }
        }
        return linkedList;
    }

    public static int getIntParamMin(Param param) {
        return ParamUtils.readOptionalIntegerAttribute(param, "min", 0);
    }

    public static int getIntParamMax(Param param) {
        return ParamUtils.readOptionalIntegerAttribute(param, "max", Integer.MAX_VALUE);
    }

    public static int getIntParamIncrement(Param param) {
        return ParamUtils.readOptionalIntegerAttribute(param, "increment", 1);
    }

    public static EnumWidgetStyle getEnumWidgetStyle(Param param) {
        EnumWidgetStyle enumWidgetStyle = EnumWidgetStyle.COMBO_BOX;
        String string = param.getInfrastructureAttributes().get("style");
        if (string != null && string.length() > 0) {
            enumWidgetStyle = EnumWidgetStyle.valueOf(string.toUpperCase(Locale.ENGLISH).replace('-', '_'));
        }
        return enumWidgetStyle;
    }

    public static SyntaxTextPane createSyntaxTextPane(final int n, final int n2) {
        return new SyntaxTextPane(){

            public Dimension getPreferredScrollableViewportSize() {
                return new Dimension(this.getGraphics() == null ? (int)super.getPreferredSize().getWidth() : (int)this.getFont().getStringBounds("M", ((Graphics2D)this.getGraphics()).getFontRenderContext()).getWidth() * n2, this.getLineHeight() * n);
            }
        };
    }

    public static void updateSyntax(SyntaxTextPane syntaxTextPane, String string) {
        EditorLanguage editorLanguage = ParamUtils.getSyntaxLanguage(string);
        EditorKit editorKit = ParamUtils.getEditorKit(editorLanguage);
        String string2 = syntaxTextPane.getText();
        syntaxTextPane.registerEditorKit(editorLanguage.getMimeType(), editorKit);
        syntaxTextPane.setContentType(editorLanguage.getMimeType());
        syntaxTextPane.setSyntaxHighlightingEnabled(editorLanguage, true);
        syntaxTextPane.setShowLineNumbers(false, false);
        syntaxTextPane.setContextMenuEnabled(true, false);
        syntaxTextPane.setShowRightMargin(false, false);
        syntaxTextPane.setText(string2);
    }

    public static EditorLanguage getSyntaxLanguage(String string) {
        if (string.equalsIgnoreCase("C")) {
            return CLanguage.INSTANCE;
        }
        if (string.equalsIgnoreCase("C++")) {
            return CPlusPlusLanguage.INSTANCE;
        }
        if (string.equalsIgnoreCase("MATLAB")) {
            return MLanguage.INSTANCE;
        }
        if (string.equalsIgnoreCase("XML")) {
            return XMLLanguage.INSTANCE;
        }
        if (string.equalsIgnoreCase("verilog")) {
            return VerilogLanguage.INSTANCE;
        }
        if (string.equalsIgnoreCase("Java")) {
            return JavaLanguage.INSTANCE;
        }
        if (string.equalsIgnoreCase("VHDL")) {
            return VHDLLanguage.INSTANCE;
        }
        if (string.equalsIgnoreCase("Simscape")) {
            return SimscapeLanguage.INSTANCE;
        }
        if (string.equalsIgnoreCase("TLC")) {
            return TLCLanguage.INSTANCE;
        }
        throw new IllegalArgumentException("Unrecognized syntax highlighting language: '" + string + "'");
    }

    public static EditorKit getEditorKit(final EditorLanguage editorLanguage) {
        if (editorLanguage == CLanguage.INSTANCE) {
            return new CKit(){

                public String getContentType() {
                    return CLanguage.INSTANCE.getMimeType();
                }
            };
        }
        if (editorLanguage == CPlusPlusLanguage.INSTANCE) {
            return new CCKit(){

                public String getContentType() {
                    return CPlusPlusLanguage.INSTANCE.getMimeType();
                }
            };
        }
        if (editorLanguage == MLanguage.INSTANCE) {
            return new MKit(){

                public String getContentType() {
                    return MLanguage.INSTANCE.getMimeType();
                }
            };
        }
        return new MWKit(){

            public String getContentType() {
                return editorLanguage.getMimeType();
            }
        };
    }

    private static int readOptionalIntegerAttribute(Param param, String string, int n) {
        String string2 = param.getInfrastructureAttributes().get(string);
        int n2 = n;
        if (string2 != null) {
            try {
                n2 = Integer.parseInt(string2);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Invalid value for '" + string + "' attribute on param '" + param.getKey() + "'");
            }
        }
        return n2;
    }

    private static boolean readOptionalBooleanAttribute(Param param, String string, boolean bl) {
        String string2 = param.getInfrastructureAttributes().get(string);
        boolean bl2 = bl;
        if (string2 != null) {
            try {
                bl2 = Boolean.parseBoolean(string2);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Invalid value for '" + string + "' attribute on param '" + param.getKey() + "'");
            }
        }
        return bl2;
    }
}

