/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.settingsui;

import com.mathworks.mwswing.FontUtils;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.project.impl.settingsui.DefaultNavigationBarPainter;
import com.mathworks.project.impl.settingsui.NavigationBarPainter;
import com.mathworks.project.impl.settingsui.SettingsPaintingUtils;
import com.mathworks.util.ParameterRunnable;
import com.mathworks.util.PlatformInfo;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public final class NavigationBar {
    private final MJPanel fComponent;
    private final NavigationBarPainter fPainter = new DefaultNavigationBarPainter();
    private final ParameterRunnable<Component> fSelector;
    private final List<Element> fElements;
    private final Map<Element, Rectangle2D> fElementRects;
    private final FocusDetector fFocusDetector;
    private int fRightEdge;
    private Element fSelectedElement;
    private Element fPressedElement;
    private Element fHoveredElement;
    private Icon fDarkIcon;
    private Point fMouseDownLocation;
    private Timer fHoverTimer;
    private double fChangeRatio;
    private double fChangeIncrement;
    private List<Element> fOriginalElements;
    private Map<Element, Rectangle2D> fOriginalElementRects;
    private Timer fChangeTimer;

    public NavigationBar(ParameterRunnable<Component> parameterRunnable) {
        this.fComponent = new BarComponent();
        this.fComponent.putClientProperty((Object)"NavigationBar", (Object)this);
        this.fComponent.setName("settings.navigation");
        this.fSelector = parameterRunnable;
        this.fElements = new ArrayList<Element>();
        this.fElementRects = new HashMap<Element, Rectangle2D>();
        this.fFocusDetector = new FocusDetector();
        this.fComponent.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                Element element = NavigationBar.this.getElementAtPoint(mouseEvent.getPoint());
                if (element != NavigationBar.this.fPressedElement) {
                    NavigationBar.this.fPressedElement = element;
                    NavigationBar.this.fDarkIcon = SettingsPaintingUtils.makeDarkIcon(element.getIcon());
                    NavigationBar.this.fComponent.revalidate();
                    NavigationBar.this.fComponent.repaint();
                }
                if (element == null) {
                    NavigationBar.this.fMouseDownLocation = mouseEvent.getPoint();
                    SwingUtilities.convertPointToScreen(NavigationBar.this.fMouseDownLocation, (Component)NavigationBar.this.fComponent);
                } else {
                    NavigationBar.this.fMouseDownLocation = null;
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (NavigationBar.this.fPressedElement != null && NavigationBar.this.fPressedElement == NavigationBar.this.fHoveredElement) {
                    NavigationBar.this.fSelectedElement = NavigationBar.this.fPressedElement;
                    NavigationBar.this.fSelector.run((Object)NavigationBar.this.fSelectedElement.getComponent());
                }
                NavigationBar.this.fPressedElement = null;
                NavigationBar.this.fComponent.revalidate();
                NavigationBar.this.fComponent.repaint();
            }
        });
        this.fComponent.addMouseMotionListener((MouseMotionListener)new MouseAdapter(){

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                if (PlatformInfo.isMacintosh() && NavigationBar.this.fMouseDownLocation != null) {
                    Point point = mouseEvent.getPoint();
                    SwingUtilities.convertPointToScreen(point, (Component)NavigationBar.this.fComponent);
                    Window window = SwingUtilities.windowForComponent((Component)NavigationBar.this.fComponent);
                    window.setLocation((int)((double)window.getX() + point.getX() - NavigationBar.this.fMouseDownLocation.getX()), (int)((double)window.getY() + point.getY() - NavigationBar.this.fMouseDownLocation.getY()));
                    NavigationBar.this.fMouseDownLocation = point;
                }
                NavigationBar.this.updateHover(mouseEvent.getPoint());
            }

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                NavigationBar.this.updateHover(mouseEvent.getPoint());
            }
        });
    }

    public void dispose() {
        this.fElements.clear();
        this.fElementRects.clear();
        this.fSelectedElement = null;
        this.fHoveredElement = null;
        this.fPressedElement = null;
        this.fOriginalElementRects = null;
        this.fOriginalElements = null;
        if (this.fChangeTimer != null) {
            this.fChangeTimer.stop();
            this.fChangeTimer = null;
        }
    }

    private void startHoverTimer() {
        if (this.fHoverTimer == null) {
            this.fHoverTimer = new Timer(200, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Point point;
                    PointerInfo pointerInfo = MouseInfo.getPointerInfo();
                    Point point2 = point = pointerInfo == null ? null : pointerInfo.getLocation();
                    if (point != null) {
                        SwingUtilities.convertPointFromScreen(point, (Component)NavigationBar.this.fComponent);
                    }
                    NavigationBar.this.updateHover(point);
                }
            });
            this.fHoverTimer.start();
        }
    }

    private void stopHoverTimer() {
        if (this.fHoverTimer != null) {
            this.fHoverTimer.stop();
            this.fHoverTimer = null;
        }
    }

    private void updateHover(Point point) {
        Element element;
        Element element2 = element = point == null ? null : this.getElementAtPoint(point);
        if (element != this.fHoveredElement) {
            if (this.fHoveredElement == null) {
                this.stopHoverTimer();
            } else {
                this.startHoverTimer();
            }
            this.fHoveredElement = element;
            this.fComponent.revalidate();
            this.fComponent.repaint();
        }
    }

    public void addElement(int n, String string, String string2, Icon icon, Component component) {
        Element element = new Element(string, string2, icon, component);
        if (n == -1) {
            this.fElements.add(element);
        } else {
            this.fElements.add(n, element);
        }
        if (this.fSelectedElement == null) {
            this.fSelectedElement = element;
            this.fSelector.run((Object)element.getComponent());
        }
        this.fComponent.revalidate();
        this.fComponent.repaint();
    }

    public void replaceElement(String string, Component component) {
        for (Element element : this.fElements) {
            if (!element.getKey().equals(string)) continue;
            element.setComponent(component);
            if (element == this.fSelectedElement) {
                this.fSelector.run((Object)component);
            }
            this.fComponent.revalidate();
            this.fComponent.repaint();
            break;
        }
    }

    public void removeElement(String string) {
        Iterator<Element> iterator = this.fElements.iterator();
        while (iterator.hasNext()) {
            Element element = iterator.next();
            if (!element.getKey().equals(string)) continue;
            iterator.remove();
            this.fElementRects.remove(element);
            if (element == this.fSelectedElement) {
                this.fSelectedElement = this.fElements.get(0);
                this.fSelector.run((Object)this.fSelectedElement.getComponent());
            }
            this.fComponent.revalidate();
            this.fComponent.repaint();
            break;
        }
    }

    public String getSelectedElementKey() {
        return this.fSelectedElement == null ? null : this.fSelectedElement.getKey();
    }

    public void select(String string) {
        for (Element element : this.fElements) {
            if (!element.getKey().equals(string)) continue;
            this.fSelectedElement = element;
            this.fComponent.revalidate();
            this.fComponent.repaint();
            this.fSelector.run((Object)this.fSelectedElement.getComponent());
        }
    }

    public void change(List<Runnable> list, final Runnable runnable) {
        this.fOriginalElements = new ArrayList<Element>(this.fElements);
        this.fOriginalElementRects = new HashMap<Element, Rectangle2D>(this.fElementRects);
        this.fChangeRatio = 0.0;
        this.fChangeIncrement = 0.04;
        for (Runnable runnable2 : list) {
            runnable2.run();
        }
        if (this.fChangeTimer != null) {
            this.fChangeTimer.stop();
        }
        this.fChangeTimer = new Timer(15, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NavigationBar.this.fChangeRatio += NavigationBar.this.fChangeIncrement;
                NavigationBar.this.fChangeIncrement *= 1.06;
                if (NavigationBar.this.fChangeRatio >= 1.0) {
                    NavigationBar.this.fOriginalElements = null;
                    NavigationBar.this.fOriginalElementRects = null;
                    NavigationBar.this.fChangeTimer.stop();
                    NavigationBar.this.fChangeTimer = null;
                }
                NavigationBar.this.fComponent.revalidate();
                NavigationBar.this.fComponent.repaint();
                if (NavigationBar.this.fOriginalElements == null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            runnable.run();
                        }
                    });
                }
            }
        });
        this.fChangeTimer.setRepeats(true);
        this.fChangeTimer.start();
    }

    public List<String> getElementKeys() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Element element : this.fElements) {
            arrayList.add(element.getKey());
        }
        return arrayList;
    }

    public Point getPointForElementKey(String string) {
        for (Map.Entry<Element, Rectangle2D> entry : this.fElementRects.entrySet()) {
            if (!entry.getKey().getKey().equals(string)) continue;
            return new Point((int)(entry.getValue().getX() + entry.getValue().getWidth() / 2.0), (int)(entry.getValue().getY() + entry.getValue().getHeight() / 2.0));
        }
        return null;
    }

    private Element getElementAtPoint(Point point) {
        for (Map.Entry<Element, Rectangle2D> entry : this.fElementRects.entrySet()) {
            if (!entry.getValue().contains(point)) continue;
            return entry.getKey();
        }
        return null;
    }

    public JComponent getComponent() {
        return this.fComponent;
    }

    private static class Element {
        private final String fKey;
        private final String fText;
        private final Icon fIcon;
        private Component fComponent;

        Element(String string, String string2, Icon icon, Component component) {
            this.fKey = string;
            this.fText = string2;
            this.fIcon = icon;
            this.fComponent = component;
        }

        public void setComponent(Component component) {
            this.fComponent = component;
        }

        public String getKey() {
            return this.fKey;
        }

        public String getText() {
            return this.fText;
        }

        public Icon getIcon() {
            return this.fIcon;
        }

        public Component getComponent() {
            return this.fComponent;
        }
    }

    private class FocusDetector {
        private boolean fValue = true;
        private Long fFirstQueryTime;
        private long fLastChangeTime = System.currentTimeMillis();
        private Timer fNoiseCancellationTimer;
        private final int fNoiseDelay = 500;

        private FocusDetector() {
        }

        public void notifyValue(boolean bl) {
            if (bl != this.fValue) {
                if (System.currentTimeMillis() - this.fLastChangeTime > 500L) {
                    this.setValue(bl);
                } else {
                    this.waitForNoiseToEnd();
                }
            }
        }

        private void waitForNoiseToEnd() {
            if (this.fNoiseCancellationTimer == null) {
                this.fNoiseCancellationTimer = new Timer((int)Math.max(0L, 500L - (System.currentTimeMillis() - this.fLastChangeTime)), new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        NavigationBar.this.fComponent.revalidate();
                        NavigationBar.this.fComponent.repaint();
                    }
                });
                this.fNoiseCancellationTimer.setRepeats(false);
                this.fNoiseCancellationTimer.start();
            }
        }

        private void setValue(boolean bl) {
            this.fValue = bl;
            this.fLastChangeTime = System.currentTimeMillis();
        }

        public boolean isFocused() {
            if (this.fFirstQueryTime == null) {
                this.fFirstQueryTime = System.currentTimeMillis();
            }
            return System.currentTimeMillis() - this.fFirstQueryTime < 1500L ? true : this.fValue;
        }
    }

    private class BarComponent
    extends MJPanel {
        private BarComponent() {
        }

        public Dimension getPreferredSize() {
            if (NavigationBar.this.fRightEdge == 0) {
                this.paint(this.getGraphics(), true);
            }
            return new Dimension(NavigationBar.this.fRightEdge + 8, 72);
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public void paint(Graphics graphics) {
            this.paint(graphics, false);
        }

        public void paint(Graphics graphics, boolean bl) {
            Object object;
            NavigationBar.this.fFocusDetector.notifyValue(SwingUtilities.windowForComponent((Component)NavigationBar.this.fComponent).isFocused());
            boolean bl2 = NavigationBar.this.fFocusDetector.isFocused();
            Graphics2D graphics2D = (Graphics2D)graphics;
            if (graphics2D == null) {
                object = new BufferedImage(1, 1, 2);
                graphics2D = ((BufferedImage)object).createGraphics();
            }
            object = PlatformInfo.isMacintosh() ? new Font("Lucida Grande", 0, 10) : FontUtils.getSystemUIFont().deriveFont(11);
            graphics2D.setFont((Font)object);
            if (!bl) {
                NavigationBar.this.fPainter.paintBackground(graphics2D, new Rectangle2D.Double(0.0, 0.0, this.getWidth(), this.getHeight()), bl2);
            }
            int n = 4;
            Icon icon = null;
            int n2 = 0;
            Composite composite = graphics2D.getComposite();
            for (Element element : NavigationBar.this.fElements) {
                Icon icon2 = element.getIcon();
                int n3 = (int)((Font)object).getStringBounds(element.getText(), graphics2D.getFontRenderContext()).getWidth();
                int n4 = 24;
                if (icon != null) {
                    n4 = Math.max(24, 64 - (n + icon2.getIconWidth() / 2 - (n2 + icon.getIconWidth() / 2)));
                }
                if (!PlatformInfo.isMacintosh()) {
                    n4 += 6;
                }
                n2 = n + (n3 += n4) / 2 - icon2.getIconWidth() / 2;
                icon = icon2;
                Rectangle2D.Double double_ = new Rectangle2D.Double(n, 2.0, n3, this.getHeight() - 4);
                NavigationBar.this.fElementRects.put(element, double_);
                if (!bl && (NavigationBar.this.fOriginalElements == null || NavigationBar.this.fOriginalElementRects.containsKey(element) || NavigationBar.this.fChangeRatio > 0.5)) {
                    if (NavigationBar.this.fOriginalElements != null) {
                        if (!NavigationBar.this.fOriginalElementRects.containsKey(element)) {
                            graphics2D.setComposite(AlphaComposite.getInstance(3, Math.min(1.0f, (float)((NavigationBar.this.fChangeRatio - 0.5) / 0.5))));
                        } else {
                            Rectangle2D rectangle2D = (Rectangle2D)NavigationBar.this.fOriginalElementRects.get(element);
                            double_ = new Rectangle2D.Double(rectangle2D.getX() + (((RectangularShape)double_).getX() - rectangle2D.getX()) * NavigationBar.this.fChangeRatio, ((RectangularShape)double_).getY(), ((RectangularShape)double_).getWidth(), ((RectangularShape)double_).getHeight());
                            n2 = (int)(((RectangularShape)double_).getX() + (double)(n3 / 2) - (double)(icon2.getIconWidth() / 2));
                        }
                    }
                    NavigationBar.this.fPainter.paintButton(graphics2D, element.getText(), element.getIcon(), NavigationBar.this.fDarkIcon, n2, double_, n4, bl2, element == NavigationBar.this.fSelectedElement, element == NavigationBar.this.fHoveredElement, element == NavigationBar.this.fPressedElement && element == NavigationBar.this.fHoveredElement);
                }
                n += n3;
            }
            graphics2D.setComposite(composite);
            NavigationBar.this.fRightEdge = n;
        }
    }
}

