/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.settingsui;

import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.datatransfer.MJDataFlavor;
import com.mathworks.project.impl.BuiltInResources;
import com.mathworks.project.impl.FileChooser;
import com.mathworks.project.impl.HyperlinkMJLabel;
import com.mathworks.project.impl.ProjectGUI;
import com.mathworks.project.impl.model.FileSetFilter;
import com.mathworks.project.impl.model.FileSetRule;
import com.mathworks.util.NativeJava;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ImagePicker {
    private final MJPanel fComponent;
    private final MJPanel fPrompt;
    private final Component fSelectLink;
    private final Component fRemoveLink;
    private MJLabel fPreview;
    private BufferedImage fPreviewImage;
    private File fSelectedFile;
    private int fFixedPreviewSize;
    private double fFixedAspectRatio;
    private boolean fRenderLabelBelowImage;
    private boolean suppressInvalidImageError;
    private int fPreviewHeight;
    private int fPreviewWidth;
    private Set<ChangeListener> fChangeListeners = new HashSet<ChangeListener>();
    private ChangeListener fActiveListener;

    public ImagePicker(String string, String string2, final int n, boolean bl) {
        this.fComponent = new MJPanel(){

            public void doLayout() {
                super.doLayout();
                if (ImagePicker.this.fPreview != null) {
                    ImagePicker.this.fPreview.setLocation(0, 0);
                    ImagePicker.this.fPreview.setSize(this.getWidth(), this.getHeight());
                }
                if (ImagePicker.this.fRenderLabelBelowImage) {
                    ImagePicker.this.fPrompt.setLocation((int)((double)(this.getWidth() / 2) - ImagePicker.this.fPrompt.getPreferredSize().getWidth() / 2.0), (int)((double)this.getHeight() - ImagePicker.this.fPrompt.getPreferredSize().getHeight()));
                } else {
                    ImagePicker.this.fPrompt.setLocation((int)((double)(this.getWidth() / 2) - ImagePicker.this.fPrompt.getPreferredSize().getWidth() / 2.0), (int)((double)(this.getHeight() / 2) - ImagePicker.this.fPrompt.getPreferredSize().getHeight() / 2.0));
                }
                ImagePicker.this.fPrompt.setSize((int)ImagePicker.this.fPrompt.getPreferredSize().getWidth(), (int)ImagePicker.this.fPrompt.getPreferredSize().getHeight());
            }

            public Dimension getPreferredSize() {
                int n5;
                int n2 = ImagePicker.this.fPrompt == null ? 0 : ImagePicker.this.fPrompt.getWidth() + 10;
                int n3 = ImagePicker.this.fPreviewHeight == 0 ? 80 : ImagePicker.this.fPreviewHeight;
                int n4 = n5 = ImagePicker.this.fPreviewWidth > n2 ? ImagePicker.this.fPreviewWidth : n2;
                if (ImagePicker.this.fFixedAspectRatio > 0.0 && n3 < n5) {
                    n3 = (int)((double)n5 * ImagePicker.this.fFixedAspectRatio);
                } else if (ImagePicker.this.fFixedAspectRatio > 0.0) {
                    n5 = (int)((double)n3 / ImagePicker.this.fFixedAspectRatio);
                    n5 = n5 > n2 ? n5 : n2;
                } else if (n < 0 && n5 < 200) {
                    n5 = 200;
                }
                return new Dimension(n5, n3);
            }
        };
        this.fComponent.setLayout(null);
        this.fComponent.setBorder((Border)new LineBorder(new Color(0xDDDDDD)));
        this.fComponent.setOpaque(false);
        this.fSelectLink = new HyperlinkMJLabel(string, new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                FileSetFilter fileSetFilter = new FileSetFilter(BuiltInResources.getString("details.imagefiles"));
                fileSetFilter.addRule(new FileSetRule("*.jpg", false));
                fileSetFilter.addRule(new FileSetRule("*.jpeg", false));
                fileSetFilter.addRule(new FileSetRule("*.bmp", false));
                fileSetFilter.addRule(new FileSetRule("*.png", false));
                fileSetFilter.addRule(new FileSetRule("*.gif", false));
                File file = new File(NativeJava.getCurrentDirectory());
                if (ImagePicker.this.fSelectedFile != null) {
                    file = ImagePicker.this.fSelectedFile.getParentFile();
                }
                FileChooser fileChooser = FileChooser.create(ProjectGUI.getInstance().getCurrentClient().getComponent(), BuiltInResources.getString("details.chooser"), file, false, Arrays.asList(fileSetFilter));
                fileChooser.setMultiSelectionEnabled(false);
                fileChooser.setAcceptAllFileFilterUsed(false);
                File[] fileArray = fileChooser.showOpenDialog();
                if (fileArray != null && fileArray.length == 1) {
                    ImagePicker.this.setData(fileArray[0]);
                }
                if (ImagePicker.this.fActiveListener != null) {
                    ImagePicker.this.fActiveListener.stateChanged(new ChangeEvent(this));
                }
            }
        }, "selectfile");
        if (string2 == null) {
            this.fRemoveLink = null;
        } else {
            this.fRemoveLink = new HyperlinkMJLabel(string2, new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    ImagePicker.this.removeImage();
                }
            }, "removefile");
            this.fRemoveLink.setVisible(false);
        }
        this.fPrompt = new MJPanel(new FlowLayout()){

            public void paintComponent(Graphics graphics) {
                Graphics2D graphics2D = (Graphics2D)graphics.create();
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics2D.setColor(new Color(0, 0, 0, 0));
                graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
                graphics2D.setColor(new Color(255, 255, 255, 160));
                if (ImagePicker.this.fSelectLink.isVisible()) {
                    RoundRectangle2D.Double double_ = new RoundRectangle2D.Double(ImagePicker.this.fSelectLink.getX() - 4, ImagePicker.this.fSelectLink.getY() - 4, ImagePicker.this.fSelectLink.getWidth() + 8, ImagePicker.this.fSelectLink.getHeight() + 8, 14.0, 14.0);
                    if (((RectangularShape)double_).getWidth() > (double)ImagePicker.this.fPrompt.getWidth()) {
                        ImagePicker.this.fPrompt.setSize((int)((RectangularShape)double_).getWidth(), (int)((RectangularShape)double_).getHeight());
                        ImagePicker.this.fPrompt.setLocation(ImagePicker.this.fComponent.getWidth() / 2 - ImagePicker.this.fPrompt.getWidth() / 2, ImagePicker.this.fPrompt.getHeight());
                    }
                    graphics2D.fill(double_);
                } else {
                    RoundRectangle2D.Double double_ = new RoundRectangle2D.Double(ImagePicker.this.fRemoveLink.getX() - 4, ImagePicker.this.fRemoveLink.getY() - 4, ImagePicker.this.fRemoveLink.getWidth() + 8, ImagePicker.this.fRemoveLink.getHeight() + 8, 14.0, 14.0);
                    if (((RectangularShape)double_).getWidth() > (double)ImagePicker.this.fPrompt.getWidth()) {
                        ImagePicker.this.fPrompt.setSize((int)((RectangularShape)double_).getWidth(), (int)((RectangularShape)double_).getHeight());
                        ImagePicker.this.fPrompt.setLocation(ImagePicker.this.fComponent.getWidth() / 2 - ImagePicker.this.fPrompt.getWidth() / 2, ImagePicker.this.fPrompt.getHeight());
                    }
                    graphics2D.fill(double_);
                }
                graphics2D.dispose();
            }
        };
        this.fPrompt.add(this.fSelectLink);
        if (this.fRemoveLink != null) {
            this.fPrompt.add(this.fRemoveLink);
        }
        this.fPrompt.setOpaque(false);
        this.fComponent.add((Component)this.fPrompt);
        this.fFixedPreviewSize = n;
        this.fFixedAspectRatio = -1.0;
        if (bl) {
            new DropTarget((Component)this.fComponent, new DropTargetAdapter(){

                @Override
                public void drop(DropTargetDropEvent dropTargetDropEvent) {
                    dropTargetDropEvent.acceptDrop(dropTargetDropEvent.getDropAction());
                    Transferable transferable = dropTargetDropEvent.getTransferable();
                    if (transferable != null) {
                        try {
                            File[] fileArray;
                            if (MJDataFlavor.isDecodableFileFlavor((Transferable)transferable) && (fileArray = MJDataFlavor.decodeJavaFileListFlavor((Transferable)transferable)).length == 1) {
                                ImagePicker.this.setData(fileArray[0]);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            });
        }
    }

    public void setFixedAspectRatio(double d) {
        this.fFixedAspectRatio = d;
    }

    public void dispose() {
        for (ChangeListener changeListener : this.fChangeListeners) {
            this.removeChangeListener(changeListener);
        }
    }

    public Component getComponent() {
        return this.fComponent;
    }

    private void select(File file) {
        block5: {
            try {
                FileSetFilter fileSetFilter = new FileSetFilter(BuiltInResources.getString("details.imagefiles"));
                fileSetFilter.addRule(new FileSetRule("*.jpg", false));
                fileSetFilter.addRule(new FileSetRule("*.jpeg", false));
                fileSetFilter.addRule(new FileSetRule("*.bmp", false));
                fileSetFilter.addRule(new FileSetRule("*.png", false));
                fileSetFilter.addRule(new FileSetRule("*.gif", false));
                if (file != null && file.exists() && (fileSetFilter.accept(file) || file.getName().indexOf(46) == -1)) {
                    this.fPreviewImage = ImageIO.read(file);
                    if (this.fPreviewImage == null) {
                        throw new IOException();
                    }
                    this.createPreview(file);
                    if (this.fRemoveLink != null) {
                        this.fRemoveLink.setVisible(true);
                        this.fSelectLink.setVisible(false);
                    }
                    break block5;
                }
                throw new IOException();
            }
            catch (IOException iOException) {
                if (this.suppressInvalidImageError) break block5;
                JOptionPane.showMessageDialog((Component)this.fComponent, BuiltInResources.getString("error.invalid.image"), BuiltInResources.getString("error.invalid.image.title"), 0);
            }
        }
    }

    private void createPreview(File file) {
        this.fPreview = new MJLabel(){

            public void paintComponent(Graphics graphics) {
                Graphics2D graphics2D = (Graphics2D)graphics.create();
                if (ImagePicker.this.fFixedPreviewSize > 0) {
                    graphics2D.drawImage(ImagePicker.this.fPreviewImage, (ImagePicker.this.fComponent.getWidth() - ImagePicker.this.fFixedPreviewSize) / 2, 0, ImagePicker.this.fFixedPreviewSize, ImagePicker.this.fFixedPreviewSize, null);
                } else {
                    int n = ImagePicker.this.fComponent.getWidth();
                    double d = ImagePicker.this.fFixedAspectRatio > 0.0 ? ImagePicker.this.fFixedAspectRatio : (double)ImagePicker.this.fPreviewImage.getHeight(null) / (double)ImagePicker.this.fPreviewImage.getWidth(null);
                    int n2 = (int)(d * (double)n);
                    if (n2 > ImagePicker.this.fComponent.getHeight()) {
                        n2 = ImagePicker.this.fComponent.getHeight();
                        n = (int)((double)n2 / d);
                    }
                    ImagePicker.this.fPreviewWidth = n;
                    ImagePicker.this.fPreviewHeight = n2;
                    graphics2D.drawImage(ImagePicker.this.fPreviewImage, (ImagePicker.this.fComponent.getWidth() - n) / 2, (ImagePicker.this.fComponent.getHeight() - n2) / 2, n, n2, null);
                }
                super.paintComponent((Graphics)graphics2D);
                graphics2D.dispose();
            }
        };
        this.fComponent.removeAll();
        this.fComponent.setSize(this.fComponent.getPreferredSize());
        this.fPreview.setSize(this.fComponent.getSize());
        this.fComponent.add((Component)this.fPreview);
        this.fComponent.add((Component)this.fPrompt);
        this.fComponent.setComponentZOrder((Component)this.fPreview, 1);
        this.fComponent.setComponentZOrder((Component)this.fPrompt, 0);
        this.fComponent.revalidate();
        this.fComponent.repaint();
        this.fSelectedFile = file;
    }

    public void removeImage() {
        this.fSelectedFile = null;
        this.fPreview.setVisible(false);
        if (this.fRemoveLink != null) {
            this.fRemoveLink.setVisible(false);
        }
        this.fSelectLink.setVisible(true);
        this.changeEvent();
    }

    public void setData(File file) {
        if (file != null && file.exists()) {
            this.select(file);
            this.changeEvent();
        }
    }

    public void forceNull() {
        this.fSelectedFile = null;
    }

    public void overridePreview(BufferedImage bufferedImage) {
        if (bufferedImage != null) {
            this.fPreviewImage = bufferedImage;
            this.createPreview(this.fSelectedFile);
        }
    }

    public File getData() {
        return this.fSelectedFile;
    }

    public void setRenderLabelBelowImage(boolean bl) {
        this.fRenderLabelBelowImage = bl;
    }

    public void removeBorder() {
        this.fComponent.setBorder(null);
    }

    private void changeEvent() {
        for (ChangeListener changeListener : this.fChangeListeners) {
            changeListener.stateChanged(new ChangeEvent(this));
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.fChangeListeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.fChangeListeners.remove(changeListener);
    }

    public void setActiveListener(ChangeListener changeListener) {
        this.fActiveListener = changeListener;
    }

    public void setLinkName(String string) {
        this.fSelectLink.setName(string);
    }

    public void disableInvalidImageErrors() {
        this.suppressInvalidImageError = true;
    }
}

