/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.settingsui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.jmi.MatlabPath;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJTextField;
import com.mathworks.project.api.ValidationMessage;
import com.mathworks.project.impl.BuiltInResources;
import com.mathworks.project.impl.FileChooser;
import com.mathworks.project.impl.model.FileSetFilter;
import com.mathworks.project.impl.model.Param;
import com.mathworks.project.impl.model.Project;
import com.mathworks.project.impl.settingsui.AbstractParamWidget;
import com.mathworks.project.impl.settingsui.BrowseUtils;
import com.mathworks.project.impl.settingsui.DetailedToolTip;
import com.mathworks.project.impl.settingsui.TextFieldWithValidation;
import com.mathworks.util.ParameterRunnable;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class FileOrDirWidget
extends AbstractParamWidget<File> {
    private final TextFieldWithValidation fFieldWithValidation;
    private final MJTextField fTextField;
    private final MJButton fButton;
    private final MJPanel fComponent;
    private final boolean fDirectory;
    private final List<FileSetFilter> fFilters;
    private boolean fUseAllFileFilter;

    public FileOrDirWidget(Param param, Project project, boolean bl) {
        this(param, project, bl ? null : new ArrayList(0));
    }

    public FileOrDirWidget(Param param, Project project, List<FileSetFilter> list) {
        if (list == null) {
            this.fDirectory = true;
            this.fFilters = null;
        } else {
            this.fDirectory = false;
            this.fFilters = new ArrayList<FileSetFilter>(list);
        }
        this.fUseAllFileFilter = true;
        this.fFieldWithValidation = new TextFieldWithValidation();
        this.fTextField = this.fFieldWithValidation.getTextField();
        this.fTextField.setColumns(20);
        this.fTextField.setName(param.getKey() + ".field");
        this.fTextField.getDocument().addDocumentListener(this.createDocumentListener());
        this.fComponent = new MJPanel((LayoutManager)new FormLayout("fill:d:grow, 2dlu, d", "center:p"));
        this.fComponent.setOpaque(false);
        CellConstraints cellConstraints = new CellConstraints();
        this.fComponent.add((Component)this.fTextField, (Object)cellConstraints.xy(1, 1));
        this.fButton = new MJButton(BuiltInResources.getString("button.browse"));
        this.fButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (FileOrDirWidget.this.fDirectory) {
                    BrowseUtils.browseFolder((Component)FileOrDirWidget.this.fTextField, FileOrDirWidget.this.getData(), new ParameterRunnable<File>(){

                        public void run(File file) {
                            FileOrDirWidget.this.setData(file);
                        }
                    });
                } else {
                    FileChooser fileChooser = FileChooser.create((Component)FileOrDirWidget.this.fTextField, BuiltInResources.getString("settings.filebrowse.prompt"), MatlabPath.getCurrentDirectory(), false, FileOrDirWidget.this.fFilters);
                    fileChooser.setAcceptAllFileFilterUsed(FileOrDirWidget.this.useAllFileFilter());
                    File[] fileArray = fileChooser.showOpenDialog();
                    if (fileArray != null) {
                        FileOrDirWidget.this.setData(fileArray[0]);
                    }
                }
            }
        });
        this.fButton.setName(param.getKey() + ".button");
        this.fComponent.add((Component)this.fButton, (Object)cellConstraints.xy(3, 1));
        DetailedToolTip.install((Component)this.fTextField, project.getConfiguration(), param);
    }

    public boolean useAllFileFilter() {
        return this.fUseAllFileFilter;
    }

    public void setAcceptAllFileFilterUsed(boolean bl) {
        this.fUseAllFileFilter = bl;
    }

    public void setEnabled(boolean bl) {
        this.fTextField.setEnabled(bl);
        this.fButton.setEnabled(bl);
    }

    public void setData(File file) {
        if (file == null) {
            this.fTextField.setText("");
        } else {
            this.fTextField.setText(file.toString());
        }
    }

    public File getData() {
        if (this.fTextField.getText().trim().length() == 0) {
            return null;
        }
        return new File(this.fTextField.getText().trim());
    }

    public Component getComponent() {
        return this.fComponent;
    }

    public MJTextField getField() {
        return this.fTextField;
    }

    @Override
    public void dispose() {
        super.dispose();
        DetailedToolTip.uninstall((Component)this.fTextField);
    }

    @Override
    public boolean showValidationMessage(ValidationMessage validationMessage) {
        this.fFieldWithValidation.setValidationMessage(validationMessage);
        return true;
    }

    @Override
    public void clearValidationMessage() {
        this.fFieldWithValidation.clearValidationMessage();
    }
}

