/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.settingsui;

import com.mathworks.mwswing.FontUtils;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJTextField;
import com.mathworks.project.api.ValidationMessage;
import com.mathworks.project.impl.BuiltInResources;
import com.mathworks.project.impl.FileChooser;
import com.mathworks.project.impl.HyperlinkMJLabel;
import com.mathworks.project.impl.model.FileSetFilter;
import com.mathworks.project.impl.model.Param;
import com.mathworks.project.impl.model.Project;
import com.mathworks.project.impl.settingsui.AbstractParamWidget;
import com.mathworks.project.impl.settingsui.BrowseUtils;
import com.mathworks.project.impl.settingsui.DetailedToolTip;
import com.mathworks.project.impl.settingsui.TextFieldWithValidation;
import com.mathworks.util.ParameterRunnable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;

public class DirWidget
extends AbstractParamWidget<File> {
    public static final String PARAM_OUTPUT = "param.output";
    private final TextFieldWithValidation fFieldWithValidation;
    private final MJTextField fTextField;
    private final MJLabel fDisplayTextField;
    private final HyperlinkMJLabel fOutputDirLink;
    private final MJPanel fComponent;
    private final boolean fDirectory;
    private final List<FileSetFilter> fFilters;
    private File fOutputFilePath;
    private File fOutputFileName;

    public DirWidget(Param param, Project project, boolean bl) {
        this(param, project, bl ? null : new ArrayList(0));
    }

    public DirWidget(Param param, final Project project, List<FileSetFilter> list) {
        if (list == null) {
            this.fDirectory = true;
            this.fFilters = null;
        } else {
            this.fDirectory = false;
            this.fFilters = new ArrayList<FileSetFilter>(list);
        }
        this.fOutputFilePath = project.getFile().getParentFile();
        this.fOutputFileName = new File("App Name.mlappinstall");
        this.fDisplayTextField = new MJLabel();
        this.fDisplayTextField.setFont(FontUtils.getSystemUIFont());
        this.fDisplayTextField.setBorder(BorderFactory.createLineBorder(Color.WHITE, 5));
        this.fFieldWithValidation = new TextFieldWithValidation();
        this.fTextField = this.fFieldWithValidation.getTextField();
        this.fTextField.setName(param.getKey() + ".field");
        this.fTextField.getDocument().addDocumentListener(this.createDocumentListener());
        this.fComponent = new MJPanel((LayoutManager)new GridBagLayout());
        this.fComponent.setOpaque(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        this.fComponent.add((Component)this.fDisplayTextField, (Object)gridBagConstraints);
        if (!project.getConfiguration().getParamAsFile(PARAM_OUTPUT).getAbsolutePath().isEmpty()) {
            this.fOutputFilePath = new File(project.getConfiguration().getParamAsFile(PARAM_OUTPUT).getParent());
        }
        this.fOutputDirLink = new HyperlinkMJLabel(BuiltInResources.getString("build.changeoutdir"), new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (DirWidget.this.fDirectory) {
                    BrowseUtils.browseFolder((Component)DirWidget.this.fDisplayTextField, new File(project.getConfiguration().getParamAsFile(DirWidget.PARAM_OUTPUT).getParent()), new ParameterRunnable<File>(){

                        public void run(File file) {
                            DirWidget.this.setData(file);
                        }
                    });
                } else {
                    FileChooser fileChooser = FileChooser.create((Component)DirWidget.this.fDisplayTextField, BuiltInResources.getString("settings.filebrowse.prompt"), DirWidget.this.getData(), false, DirWidget.this.fFilters);
                    File[] fileArray = fileChooser.showOpenDialog();
                    if (fileArray != null) {
                        DirWidget.this.setData(fileArray[0]);
                    }
                }
            }
        });
        this.fOutputDirLink.setName("build.changeoutdir");
        MJPanel mJPanel = new MJPanel();
        mJPanel.setBackground(Color.WHITE);
        mJPanel.setLayout((LayoutManager)new BorderLayout());
        mJPanel.add((Component)((Object)this.fOutputDirLink), (Object)"East");
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 26;
        this.fComponent.add((Component)mJPanel, (Object)gridBagConstraints);
        DetailedToolTip.install((Component)this.fDisplayTextField, project.getConfiguration(), param);
    }

    public void setEnabled(boolean bl) {
        this.fOutputDirLink.setEnabled(bl);
    }

    public void setData(File file) {
        if (file == null) {
            this.fTextField.setText("");
            this.fDisplayTextField.setText("");
            this.fDisplayTextField.setToolTipText(BuiltInResources.getString("build.outputfile.emptyappname.tooltip"));
            return;
        }
        if (file.isDirectory()) {
            this.fOutputFilePath = file;
            this.setDisplayText(file, this.fOutputFileName);
        } else {
            this.fOutputFileName = file;
            this.setDisplayText(this.fOutputFilePath, this.fOutputFileName);
        }
    }

    void setDisplayText(File file, File file2) {
        String string = file.getAbsolutePath().substring(0, file.getAbsolutePath().indexOf(File.separator) + 1);
        this.fDisplayTextField.setText(string + "..." + File.separator + file2.getName());
        this.fDisplayTextField.setToolTipText(file + File.separator + file2.getName());
        this.fTextField.setText(file + File.separator + file2.getName());
    }

    public File getData() {
        if (this.fTextField.getText().trim().length() == 0) {
            return null;
        }
        return new File(this.fTextField.getText().trim());
    }

    public Component getComponent() {
        return this.fComponent;
    }

    @Override
    public void dispose() {
        DetailedToolTip.uninstall((Component)this.fTextField);
    }

    @Override
    public boolean showValidationMessage(ValidationMessage validationMessage) {
        this.fFieldWithValidation.setValidationMessage(validationMessage);
        return true;
    }

    @Override
    public void clearValidationMessage() {
        this.fFieldWithValidation.clearValidationMessage();
    }

    public String getDisplayTextFieldText() {
        return this.fDisplayTextField.getText();
    }

    public void setDisplayTextFieldText(String string) {
        this.fDisplayTextField.setToolTipText(string);
    }
}

