/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.settingsui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.common.icons.DialogIcon;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.project.api.ProjectComponent;
import com.mathworks.project.api.Severity;
import com.mathworks.project.api.ValidationMessage;
import com.mathworks.project.impl.model.Param;
import com.mathworks.project.impl.model.ParamSet;
import com.mathworks.project.impl.model.Project;
import com.mathworks.project.impl.settingsui.BatchComponentFilter;
import com.mathworks.project.impl.settingsui.BatchingSettingsPanelBuilder;
import com.mathworks.project.impl.settingsui.SettingComponentDefinition;
import com.mathworks.project.impl.settingsui.SettingsPanelBuilder;
import com.mathworks.project.impl.settingsui.table.NameColumn;
import com.mathworks.project.impl.settingsui.table.SettingsTableUtils;
import com.mathworks.project.impl.settingsui.table.ValueColumn;
import com.mathworks.project.impl.table.PropertyTable;
import com.mathworks.util.ParameterRunnable;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.RequestFilter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;

public class DefaultBatchComponentFilter
implements BatchComponentFilter {
    private final Project fProject;

    DefaultBatchComponentFilter(Project project) {
        this.fProject = project;
    }

    @Override
    public void filter(String string, SettingsPanelBuilder settingsPanelBuilder, ParameterRunnable<ProjectComponent> parameterRunnable, List<SettingComponentDefinition> list) {
        if (list.size() <= 4 && string == null) {
            int n = DefaultBatchComponentFilter.getMaxPreferredWidth(list);
            for (SettingComponentDefinition settingComponentDefinition : list) {
                AlignmentHelper alignmentHelper = new AlignmentHelper(n, settingComponentDefinition.getComponent());
                SettingComponentDefinition settingComponentDefinition2 = new SettingComponentDefinition(settingComponentDefinition, (Component)((Object)alignmentHelper));
                settingsPanelBuilder.addComponent(settingComponentDefinition2);
            }
        } else {
            ParamSet paramSet = new ParamSet("__batch", "__batch", "", null, null, null, null, null, BatchingSettingsPanelBuilder.getParams(list), new HashMap<Param, String>(), new HashMap<Param, String>(), new HashMap<Param, Set<Param>>(), new HashSet<String>());
            NameColumn nameColumn = new NameColumn();
            ValueColumn valueColumn = new ValueColumn(this.fProject.getConfiguration());
            PropertyTable<Param> propertyTable = SettingsTableUtils.createTable(this.fProject, Arrays.asList(paramSet), Arrays.asList(nameColumn, valueColumn));
            if (!PlatformInfo.isMacintosh()) {
                propertyTable.setHeaderVisible(false);
            }
            propertyTable.setNoStretch(true);
            TableWrapper tableWrapper = new TableWrapper(paramSet, propertyTable);
            parameterRunnable.run((Object)tableWrapper);
            settingsPanelBuilder.addComponent((Component)((Object)tableWrapper), false);
        }
    }

    public static int getMaxPreferredWidth(List<SettingComponentDefinition> list) {
        int n = 0;
        for (SettingComponentDefinition settingComponentDefinition : list) {
            int n2 = (int)settingComponentDefinition.getComponent().getPreferredSize().getWidth();
            n = Math.max(n2, n);
        }
        return n;
    }

    public static class AlignmentHelper
    extends MJPanel {
        private final int fMaxPreferredWidth;

        AlignmentHelper(int n, Component component) {
            super((LayoutManager)new BorderLayout(0, 0));
            this.fMaxPreferredWidth = n;
            this.setOpaque(false);
            this.add(component, "Center");
        }

        public Dimension getPreferredSize() {
            return new Dimension(this.fMaxPreferredWidth + 1, (int)super.getPreferredSize().getHeight());
        }
    }

    private class TableWrapper
    extends MJPanel
    implements ProjectComponent {
        private final MJLabel fErrorLabel;
        private final PropertyTable<Param> fTable;
        private final PropertyChangeListener fProjectListener;
        private final Set<String> fParamKeys;
        private final RequestFilter fUpdateErrorLabel;

        TableWrapper(ParamSet paramSet, PropertyTable<Param> propertyTable) {
            this.fTable = propertyTable;
            this.fErrorLabel = new MJLabel();
            this.fErrorLabel.setForeground(new Color(170, 0, 0));
            this.fErrorLabel.setOpaque(false);
            this.fUpdateErrorLabel = new RequestFilter(new Runnable(){

                @Override
                public void run() {
                    TableWrapper.this.updateErrorLabel();
                }
            }, 200);
            this.setOpaque(false);
            if (PlatformInfo.isMacintosh()) {
                this.fErrorLabel.setFont(this.fErrorLabel.getFont().deriveFont((float)this.fErrorLabel.getFont().getSize() - 1.0f));
            }
            this.fParamKeys = new HashSet<String>();
            for (Param param : paramSet.getParams()) {
                this.fParamKeys.add(param.getKey());
            }
            this.setLayout((LayoutManager)new FormLayout("fill:d:grow", "fill:d:grow, 2dlu, fill:p"));
            CellConstraints cellConstraints = new CellConstraints();
            this.add((Component)this.fErrorLabel, cellConstraints.xy(1, 1));
            this.add(propertyTable.getComponent(), cellConstraints.xy(1, 3));
            this.fProjectListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (TableWrapper.this.fParamKeys.contains(propertyChangeEvent.getPropertyName())) {
                        TableWrapper.this.fUpdateErrorLabel.request();
                    }
                }
            };
            DefaultBatchComponentFilter.this.fProject.addPropertyChangeListener(this.fProjectListener);
            this.fUpdateErrorLabel.request();
        }

        private void updateErrorLabel() {
            MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    List<ValidationMessage> list = DefaultBatchComponentFilter.this.fProject.getConfiguration().getTarget().validate(DefaultBatchComponentFilter.this.fProject);
                    if (list != null) {
                        for (ValidationMessage validationMessage : list) {
                            if (validationMessage.getParamKey() == null || !TableWrapper.this.fParamKeys.contains(validationMessage.getParamKey())) continue;
                            TableWrapper.this.fErrorLabel.setText(validationMessage.getText());
                            TableWrapper.this.fErrorLabel.setIcon((Icon)(validationMessage.getSeverity() == Severity.ERROR ? DialogIcon.ERROR_12x12.getIcon() : DialogIcon.WARNING_12x12.getIcon()));
                            TableWrapper.this.revalidate();
                            TableWrapper.this.repaint();
                            return;
                        }
                    }
                    TableWrapper.this.fErrorLabel.setText("");
                    TableWrapper.this.fErrorLabel.setIcon(null);
                    TableWrapper.this.revalidate();
                    TableWrapper.this.repaint();
                }
            });
        }

        public Component getComponent() {
            return this;
        }

        public void dispose() {
            DefaultBatchComponentFilter.this.fProject.removePropertyChangeListener(this.fProjectListener);
            this.fTable.dispose();
        }
    }
}

