/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.plugin;

import com.mathworks.project.api.XmlApi;
import com.mathworks.project.api.XmlReader;
import com.mathworks.project.impl.model.DynamicTargetAttribute;
import com.mathworks.project.impl.model.XslInput;
import com.mathworks.project.impl.util.StringUtils;
import com.mathworks.util.Log;
import com.mathworks.xml.XMLUtils;
import java.io.IOException;
import java.util.regex.Pattern;

public final class XslBasedTargetAttribute
implements DynamicTargetAttribute {
    private final String fXsl;

    XslBasedTargetAttribute(String string) {
        this.fXsl = string;
    }

    @Override
    public XmlReader evaluate(XslInput xslInput) {
        try {
            return XmlApi.getInstance().read(XMLUtils.transform((String)xslInput.getText(), (String)this.fXsl));
        }
        catch (IOException iOException) {
            Log.logException((Exception)iOException);
            return null;
        }
    }

    @Override
    public boolean evaluateBoolean(XslInput xslInput) {
        return Boolean.parseBoolean(this.evaluateString(xslInput));
    }

    @Override
    public String evaluateString(XslInput xslInput) {
        return StringUtils.normalizeSpace(this.evaluate(xslInput).getChild(new String[0]).readText());
    }

    @Override
    public boolean hasReference(String string) {
        return Pattern.compile("[^<]\\Q" + string + "\\E[^>]").matcher(this.fXsl).find();
    }
}

