/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.model;

import com.mathworks.project.impl.model.DynamicTargetAttribute;
import com.mathworks.project.impl.model.DynamicTargetScript;
import com.mathworks.project.impl.model.Param;
import com.mathworks.project.impl.model.ParamSet;
import com.mathworks.project.impl.workflowui.OutputTabDefinition;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.tree.TreeNode;

public final class WorkflowStep
implements TreeNode {
    private final String fKey;
    private final String fName;
    private final String fDescription;
    private final String fOptionsWidgetClassName;
    private final String fWidgetClassName;
    private final List<ParamSet> fParamSets;
    private final boolean fOptional;
    private final List<WorkflowStep> fDependencies;
    private final List<WorkflowStep> fSubSteps;
    private final List<OutputTabDefinition> fOutputTabs;
    private final DynamicTargetScript fScript;
    private final boolean fSkippedByDefault;
    private final boolean fSkippable;
    private final DynamicTargetAttribute fVisible;
    private final String fControlWidgetClassName;
    private WorkflowStep fParent;
    private String fHelpKey;
    private boolean fEnabledOnParentComplete;

    public WorkflowStep(String string, String string2, String string3, String string4, String string5, List<ParamSet> list, boolean bl, boolean bl2, boolean bl3, DynamicTargetAttribute dynamicTargetAttribute, DynamicTargetScript dynamicTargetScript, List<WorkflowStep> list2, List<WorkflowStep> list3, List<OutputTabDefinition> list4, String string6, String string7) {
        this.fKey = string;
        this.fName = string2;
        this.fDescription = string3;
        this.fScript = dynamicTargetScript;
        this.fOptionsWidgetClassName = string4;
        this.fWidgetClassName = string5;
        this.fParamSets = list;
        this.fOptional = bl;
        this.fDependencies = list2 == null ? null : new ArrayList<WorkflowStep>(list2);
        this.fSubSteps = new ArrayList<WorkflowStep>(list3);
        this.fSkippable = bl2;
        this.fSkippedByDefault = bl3;
        this.fParent = null;
        this.fVisible = dynamicTargetAttribute;
        this.fOutputTabs = new ArrayList<OutputTabDefinition>(list4);
        this.fControlWidgetClassName = string6;
        this.fHelpKey = string7;
        this.fEnabledOnParentComplete = false;
    }

    public String getHelpKey() {
        return this.fHelpKey;
    }

    public void setParent(WorkflowStep workflowStep) {
        this.fParent = workflowStep;
    }

    @Override
    public TreeNode getChildAt(int n) {
        return this.getSubSteps().get(n);
    }

    @Override
    public int getChildCount() {
        return this.getSubSteps().size();
    }

    @Override
    public WorkflowStep getParent() {
        return this.fParent;
    }

    @Override
    public int getIndex(TreeNode treeNode) {
        return this.getSubSteps().indexOf(treeNode);
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public boolean isLeaf() {
        return this.getSubSteps().isEmpty();
    }

    public Enumeration children() {
        final Iterator<WorkflowStep> iterator = this.getSubSteps().iterator();
        Enumeration enumeration = new Enumeration(){

            @Override
            public boolean hasMoreElements() {
                return iterator.hasNext();
            }

            public Object nextElement() {
                return iterator.next();
            }
        };
        return enumeration;
    }

    public Param getParam(String string) {
        for (ParamSet paramSet : this.getParamSets()) {
            for (Param param : paramSet.getParams()) {
                if (!param.getKey().equals(string)) continue;
                return param;
            }
        }
        return null;
    }

    public DynamicTargetAttribute getVisibleAttribute() {
        return this.fVisible;
    }

    public List<WorkflowStep> getParentHierachy() {
        ArrayList<WorkflowStep> arrayList = new ArrayList<WorkflowStep>();
        for (WorkflowStep workflowStep = this.fParent; workflowStep != null; workflowStep = workflowStep.getParent()) {
            arrayList.add(workflowStep);
        }
        return arrayList;
    }

    public boolean isSkippable() {
        return this.fSkippable;
    }

    public boolean isSkippedByDefault() {
        return this.fSkippedByDefault;
    }

    public String getKey() {
        return this.fKey;
    }

    public String getName() {
        return this.fName;
    }

    public String getDescription() {
        return this.fDescription;
    }

    public String getOptionsWidgetClassName() {
        return this.fOptionsWidgetClassName;
    }

    public String getWidgetClassName() {
        return this.fWidgetClassName;
    }

    public List<ParamSet> getParamSets() {
        return this.fParamSets;
    }

    public boolean isOptional() {
        return this.fOptional;
    }

    public DynamicTargetScript getScript() {
        return this.fScript;
    }

    public List<WorkflowStep> getDependencies() {
        return this.fDependencies == null ? null : new ArrayList<WorkflowStep>(this.fDependencies);
    }

    public List<WorkflowStep> getSubSteps() {
        return new ArrayList<WorkflowStep>(this.fSubSteps);
    }

    public List<OutputTabDefinition> getOutputTabs() {
        return new ArrayList<OutputTabDefinition>(this.fOutputTabs);
    }

    public String getControlWidgetClassName() {
        return this.fControlWidgetClassName;
    }

    public boolean isRunnable() {
        return this.fScript != null || this.fWidgetClassName != null;
    }

    public boolean isRunnableOrGroup() {
        return this.isRunnable() || !this.fSubSteps.isEmpty();
    }

    public void setEnabledOnParentComplete() {
        this.fEnabledOnParentComplete = true;
    }

    public boolean isEnabledOnParentComplete() {
        return this.fEnabledOnParentComplete;
    }

    public String toString() {
        return this.getName();
    }
}

