/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.model;

import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.project.api.ConfigurationValidator;
import com.mathworks.project.api.ReadableConfiguration;
import com.mathworks.project.api.Severity;
import com.mathworks.project.api.ValidationMessage;
import com.mathworks.project.api.XmlReader;
import com.mathworks.project.impl.ProjectGUI;
import com.mathworks.project.impl.model.Configuration;
import com.mathworks.project.impl.model.DynamicFileSubset;
import com.mathworks.project.impl.model.DynamicTargetAttribute;
import com.mathworks.project.impl.model.DynamicTargetScript;
import com.mathworks.project.impl.model.FileSetDefinition;
import com.mathworks.project.impl.model.LicensedObject;
import com.mathworks.project.impl.model.MatlabExpression;
import com.mathworks.project.impl.model.PackageType;
import com.mathworks.project.impl.model.Param;
import com.mathworks.project.impl.model.ParamSet;
import com.mathworks.project.impl.model.Plugin;
import com.mathworks.project.impl.model.Profile;
import com.mathworks.project.impl.model.Project;
import com.mathworks.project.impl.model.ProjectTabDefinition;
import com.mathworks.project.impl.model.ResourceStringProvider;
import com.mathworks.project.impl.model.Workflow;
import com.mathworks.project.impl.model.WorkflowStep;
import com.mathworks.project.impl.model.XslInput;
import com.mathworks.util.Converter;
import com.mathworks.util.ParameterRunnable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.Icon;

public final class Target
implements LicensedObject {
    private final Plugin fPlugin;
    private final String fKey;
    private final String fName;
    private final String fDescription;
    private final String fProductName;
    private final Icon fIcon;
    private boolean fSkipFirstSave;
    private boolean fLazyDataEnabled;
    private boolean fAlwaysBuild;
    private String fClientClassName;
    private String fDetailedTooltipProviderClassName;
    private Set<String> fLicenseNames;
    private List<Profile> fProfiles;
    private String fHelpMapPath;
    private String fHelpTopicKey;
    private DynamicTargetScript fBuildScript;
    private DynamicTargetScript fPackageScript;
    private DynamicTargetAttribute fPackageEnable;
    private List<ParamSet> fParameters;
    private List<ParamSet> fNonWorkflowParameters;
    private List<FileSetDefinition> fFileSets;
    private List<ProjectTabDefinition> fProjectTabs;
    private List<PackageType> fPackageTypes;
    private Map<String, String> fExtraAttributes;
    private ConfigurationValidator fValidator;
    private ResourceStringProvider fResources;
    private String fProjectXslOut;
    private String fProjectXslIn;
    private DynamicFileSubset fBuildDeliverables;
    private MatlabExpression fProjectOpenCode;
    private MatlabExpression fProjectCloseCode;
    private MatlabExpression fWorkflowResetCode;
    private boolean fRequiresMatlabPathInProjectFile;
    private Workflow fWorkflow;
    private String fSettingsHelpKeyGeneratorClass;
    private DynamicTargetAttribute fProjectWindowTitle;
    private DynamicTargetAttribute fNewWindowTitle;
    private DynamicTargetAttribute fSettingsDialogWidth;
    private DynamicTargetAttribute fSettingsDialogHeight;
    private DynamicTargetAttribute fEnable;
    private ParameterRunnable<ProjectGUI.OpenRequest> fOpener;
    private Converter<FileSystemEntry, String> fFileDescriptorOverride;
    private boolean fFrozen;

    public Target(Plugin plugin, String string, String string2, String string3, String string4, String string5, Icon icon) {
        this(plugin, string, string2, string3, string4, string5, icon, null);
    }

    public Target(Plugin plugin, String string, String string2, String string3, String string4, String string5, Icon icon, Converter<FileSystemEntry, String> converter) {
        this.fPlugin = plugin != null ? plugin : Target.createDummyPlugin();
        this.fKey = string;
        this.fName = string2;
        this.fDescription = string3;
        this.fProductName = string4;
        this.fPackageTypes = new ArrayList<PackageType>();
        this.fLicenseNames = new HashSet<String>(Arrays.asList(string5));
        this.fIcon = icon;
        this.fExtraAttributes = new HashMap<String, String>();
        this.fFileDescriptorOverride = converter;
    }

    public Target(String string, String string2, String string3, String string4, boolean bl, boolean bl2, String string5, String string6, Set<String> set, List<Profile> list, String string7, String string8, Plugin plugin, Icon icon, DynamicTargetAttribute dynamicTargetAttribute, DynamicTargetAttribute dynamicTargetAttribute2, DynamicTargetAttribute dynamicTargetAttribute3, DynamicTargetAttribute dynamicTargetAttribute4, DynamicTargetAttribute dynamicTargetAttribute5, List<ParamSet> list2, List<FileSetDefinition> list3, List<ProjectTabDefinition> list4, Map<String, String> map, DynamicTargetScript dynamicTargetScript, List<PackageType> list5, DynamicTargetScript dynamicTargetScript2, DynamicTargetAttribute dynamicTargetAttribute6, ConfigurationValidator configurationValidator, ResourceStringProvider resourceStringProvider, String string9, String string10, DynamicFileSubset dynamicFileSubset, MatlabExpression matlabExpression, MatlabExpression matlabExpression2, MatlabExpression matlabExpression3, boolean bl3, Workflow workflow, String string11) {
        this.fKey = string;
        this.fName = string2;
        this.fDescription = string3;
        this.fIcon = icon;
        this.fWorkflow = workflow;
        this.fLicenseNames = new HashSet<String>(set);
        this.fSkipFirstSave = bl;
        this.fAlwaysBuild = bl2;
        this.fClientClassName = string5;
        this.fDetailedTooltipProviderClassName = string6;
        this.fProfiles = new ArrayList<Profile>(list);
        this.fHelpMapPath = string7;
        this.fHelpTopicKey = string8;
        this.fPlugin = plugin != null ? plugin : Target.createDummyPlugin();
        this.fEnable = dynamicTargetAttribute;
        this.fProjectWindowTitle = dynamicTargetAttribute2;
        this.fNewWindowTitle = dynamicTargetAttribute3;
        this.fSettingsDialogWidth = dynamicTargetAttribute4;
        this.fSettingsDialogHeight = dynamicTargetAttribute5;
        this.fProductName = string4;
        this.fProjectXslOut = string9;
        this.fProjectXslIn = string10;
        this.fBuildScript = dynamicTargetScript;
        this.fProjectTabs = new ArrayList<ProjectTabDefinition>(list4);
        this.fNonWorkflowParameters = new ArrayList<ParamSet>(list2);
        this.fParameters = this.getAllParamSets();
        this.fFileSets = new ArrayList<FileSetDefinition>(list3);
        this.fExtraAttributes = new TreeMap<String, String>(map);
        this.fPackageTypes = new ArrayList<PackageType>(list5);
        this.fPackageScript = dynamicTargetScript2;
        this.fPackageEnable = dynamicTargetAttribute6;
        this.fValidator = configurationValidator;
        this.fResources = resourceStringProvider;
        this.fBuildDeliverables = dynamicFileSubset;
        this.fProjectOpenCode = matlabExpression;
        this.fProjectCloseCode = matlabExpression2;
        this.fWorkflowResetCode = matlabExpression3;
        this.fRequiresMatlabPathInProjectFile = bl3;
        this.fSettingsHelpKeyGeneratorClass = string11;
    }

    public void freeze() {
        this.fFrozen = true;
        if (this.fParameters != null) {
            for (ParamSet paramSet : this.fParameters) {
                paramSet.freeze();
            }
        }
    }

    private void checkFrozen() {
        if (this.fFrozen) {
            throw new IllegalStateException();
        }
    }

    public void setClientClassName(String string) {
        this.checkFrozen();
        this.fClientClassName = string;
    }

    public String getClientClassName() {
        return this.fClientClassName;
    }

    public void setLazyDataEnabled(boolean bl) {
        this.checkFrozen();
        this.fLazyDataEnabled = bl;
    }

    public boolean isLazyDataEnabled() {
        return this.fLazyDataEnabled;
    }

    public void setOpener(ParameterRunnable<ProjectGUI.OpenRequest> parameterRunnable) {
        this.checkFrozen();
        this.fOpener = parameterRunnable;
    }

    public ParameterRunnable<ProjectGUI.OpenRequest> getOpener() {
        return this.fOpener;
    }

    public void setSkipFirstSave(boolean bl) {
        this.checkFrozen();
        this.fSkipFirstSave = bl;
    }

    public boolean skipFirstSave() {
        return this.fSkipFirstSave;
    }

    public void setDetailedToolTipProviderClassName(String string) {
        this.checkFrozen();
        this.fDetailedTooltipProviderClassName = string;
    }

    public String getDetailedToolTipProviderClassName() {
        return this.fDetailedTooltipProviderClassName;
    }

    public void setProfiles(List<Profile> list) {
        this.checkFrozen();
        this.fProfiles = new ArrayList<Profile>(list);
    }

    public List<Profile> getProfiles() {
        return new ArrayList<Profile>(this.fProfiles);
    }

    public Profile getProfile(String string) {
        for (Profile profile : this.fProfiles) {
            if (!profile.getKey().equals(string)) continue;
            return profile;
        }
        return null;
    }

    public Profile getDefaultProfile() {
        for (Profile profile : this.fProfiles) {
            if (profile.getSelectedAttribute() != null) continue;
            return profile;
        }
        return null;
    }

    public void setProjectpOpenCode(MatlabExpression matlabExpression) {
        this.checkFrozen();
        this.fProjectOpenCode = matlabExpression;
    }

    public MatlabExpression getProjectOpenCode() {
        return this.fProjectOpenCode;
    }

    public void setProjectCloseCode(MatlabExpression matlabExpression) {
        this.checkFrozen();
        this.fProjectCloseCode = matlabExpression;
    }

    public MatlabExpression getProjectCloseCode() {
        return this.fProjectCloseCode;
    }

    public void setWorkflowResetCode(MatlabExpression matlabExpression) {
        this.checkFrozen();
        this.fWorkflowResetCode = matlabExpression;
    }

    public MatlabExpression getWorflowResetCode() {
        return this.fWorkflowResetCode;
    }

    public void setRequiresMatlabPathInProjectFile(boolean bl) {
        this.checkFrozen();
        this.fRequiresMatlabPathInProjectFile = bl;
    }

    public boolean requiresMatlabPathInProjectFile() {
        return this.fRequiresMatlabPathInProjectFile;
    }

    public boolean supportsPackaging() {
        return this.fPackageScript != null;
    }

    public Plugin getPlugin() {
        return this.fPlugin;
    }

    public void setEnabled(DynamicTargetAttribute dynamicTargetAttribute) {
        if (this.fFrozen) {
            throw new IllegalStateException();
        }
        this.fEnable = dynamicTargetAttribute;
    }

    public boolean isEnabled(XmlReader xmlReader) {
        return this.fEnable == null || this.fEnable.evaluateBoolean(new XslInput(null, xmlReader));
    }

    public void setProjectWindowTitle(DynamicTargetAttribute dynamicTargetAttribute) {
        this.checkFrozen();
        this.fProjectWindowTitle = dynamicTargetAttribute;
    }

    public DynamicTargetAttribute getProjectWindowTitle() {
        return this.fProjectWindowTitle;
    }

    public void setNewWindowTitle(DynamicTargetAttribute dynamicTargetAttribute) {
        this.checkFrozen();
        this.fNewWindowTitle = dynamicTargetAttribute;
    }

    public DynamicTargetAttribute getNewWindowTitle() {
        return this.fNewWindowTitle;
    }

    public void setSettingsDialogWidth(DynamicTargetAttribute dynamicTargetAttribute) {
        this.checkFrozen();
        this.fSettingsDialogWidth = dynamicTargetAttribute;
    }

    public DynamicTargetAttribute getSettingsDialogWidth() {
        return this.fSettingsDialogWidth;
    }

    public void setSettingsDialogHeight(DynamicTargetAttribute dynamicTargetAttribute) {
        this.checkFrozen();
        this.fSettingsDialogHeight = dynamicTargetAttribute;
    }

    public DynamicTargetAttribute getSettingsDialogHeight() {
        return this.fSettingsDialogHeight;
    }

    public String getProjectXslOut() {
        return this.fProjectXslOut;
    }

    public String getProjectXslIn() {
        return this.fProjectXslIn;
    }

    public Icon getIcon() {
        return this.fIcon;
    }

    public String getKey() {
        return this.fKey;
    }

    public String getName() {
        return this.fName;
    }

    public String getDescription() {
        return this.fDescription;
    }

    public DynamicFileSubset getBuildDeliverables() {
        return this.fBuildDeliverables;
    }

    public Param getParam(String string) {
        for (ParamSet paramSet : this.getParamSets()) {
            for (Param param : paramSet.getParams()) {
                if (!param.getKey().equals(string)) continue;
                return param;
            }
        }
        return null;
    }

    public String getCategoryName(Param param) {
        for (ParamSet paramSet : this.getParamSets()) {
            String string = paramSet.getCategoryName(param);
            if (string == null) continue;
            return string;
        }
        return null;
    }

    public ParamSet getParamSet(String string) {
        for (ParamSet paramSet : this.getParamSets()) {
            if (!paramSet.getKey().equals(string)) continue;
            return paramSet;
        }
        return null;
    }

    public String getProductName() {
        return this.fProductName;
    }

    public void setLicenseNames(String ... stringArray) {
        if (this.fFrozen) {
            throw new IllegalStateException();
        }
        this.fLicenseNames = new HashSet<String>();
        this.fLicenseNames.addAll(Arrays.asList(stringArray));
    }

    @Override
    public Set<String> getLicenseNames() {
        return new HashSet<String>(this.fLicenseNames);
    }

    public String getHelpMapPath() {
        return this.fHelpMapPath;
    }

    public String getHelpTopicKey() {
        return this.fHelpTopicKey;
    }

    public void setParamSets(List<ParamSet> list) {
        this.checkFrozen();
        this.fParameters = new ArrayList<ParamSet>(list);
    }

    public List<ParamSet> getParamSets() {
        return new Vector<ParamSet>(this.fParameters);
    }

    public List<ParamSet> getNonWorkflowParamSets() {
        return new ArrayList<ParamSet>(this.fNonWorkflowParameters);
    }

    private List<ParamSet> getAllParamSets() {
        LinkedHashSet<ParamSet> linkedHashSet = new LinkedHashSet<ParamSet>();
        linkedHashSet.addAll(this.fNonWorkflowParameters);
        if (this.fWorkflow != null) {
            Target.addParamSets(linkedHashSet, this.fWorkflow.getSteps());
        }
        return new ArrayList<ParamSet>(linkedHashSet);
    }

    private static void addParamSets(Set<ParamSet> set, List<WorkflowStep> list) {
        for (WorkflowStep workflowStep : list) {
            set.addAll(workflowStep.getParamSets());
            Target.addParamSets(set, workflowStep.getSubSteps());
        }
    }

    public void setFileSets(List<FileSetDefinition> list) {
        this.checkFrozen();
        this.fFileSets = new ArrayList<FileSetDefinition>(list);
    }

    public List<FileSetDefinition> getFileSets() {
        return new ArrayList<FileSetDefinition>(this.fFileSets);
    }

    public Converter<FileSystemEntry, String> getFileDescriptorOverride() {
        return this.fFileDescriptorOverride;
    }

    public FileSetDefinition getFileSet(String string) {
        for (FileSetDefinition fileSetDefinition : this.fFileSets) {
            if (!fileSetDefinition.getKey().equals(string)) continue;
            return fileSetDefinition;
        }
        return null;
    }

    public DynamicTargetScript getBuildScript() {
        return this.fBuildScript;
    }

    public DynamicTargetScript getPackageScript() {
        return this.fPackageScript;
    }

    public DynamicTargetAttribute getPackageEnabledAttribute() {
        return this.fPackageEnable;
    }

    public Workflow getWorkflow() {
        return this.fWorkflow;
    }

    public void addPackageType(PackageType packageType) {
        this.checkFrozen();
        this.fPackageTypes.add(packageType);
    }

    public List<PackageType> getSupportedPackageTypes(Project project) {
        ArrayList<PackageType> arrayList = new ArrayList<PackageType>();
        for (PackageType packageType : this.fPackageTypes) {
            if (!packageType.isEnabled(project)) continue;
            arrayList.add(packageType);
        }
        return arrayList;
    }

    public PackageType getPackageTypeByKey(Project project, String string) {
        for (PackageType packageType : this.getSupportedPackageTypes(project)) {
            if (!packageType.getKey().equals(string)) continue;
            return packageType;
        }
        return null;
    }

    public List<ValidationMessage> validate(Project project) {
        if (this.fValidator == null) {
            return new ArrayList<ValidationMessage>(0);
        }
        return this.fValidator.validate((ReadableConfiguration)project.getConfiguration());
    }

    public boolean isValid(Project project, Configuration configuration) {
        if (this.fValidator == null) {
            return true;
        }
        List list = this.fValidator.validate((ReadableConfiguration)configuration);
        if (list == null) {
            return true;
        }
        for (ValidationMessage validationMessage : list) {
            if (validationMessage.getSeverity() != Severity.ERROR) continue;
            return false;
        }
        return true;
    }

    public Map<String, String> getExtraAttributes() {
        return new TreeMap<String, String>(this.fExtraAttributes);
    }

    public String getResourceString(String string) {
        return this.fResources == null ? null : this.fResources.getResource(string);
    }

    public List<ProjectTabDefinition> getProjectTabs() {
        return new ArrayList<ProjectTabDefinition>(this.fProjectTabs);
    }

    public String getSettingsHelpKeyGeneratorClassName() {
        return this.fSettingsHelpKeyGeneratorClass;
    }

    public String toString() {
        return this.getName();
    }

    public boolean alwaysBuild() {
        return this.fAlwaysBuild;
    }

    private static Plugin createDummyPlugin() {
        return new Plugin(null, "", "", "", "", "");
    }
}

