/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.model;

import com.mathworks.project.api.XmlReader;
import com.mathworks.project.impl.model.Target;
import com.mathworks.project.impl.plugin.PluginManager;
import com.mathworks.util.Pair;
import java.io.IOException;

public final class ProjectVersionUtils {
    private ProjectVersionUtils() {
    }

    public static boolean canLoad(XmlReader xmlReader) throws IOException {
        return ProjectVersionUtils.getStatedTargetAndVersion(xmlReader) != null;
    }

    public static Pair<String, String> getStatedTargetAndVersion(XmlReader xmlReader) {
        if (xmlReader.getCurrentElementName().equals("deployment-project")) {
            String string = xmlReader.readAttribute("plugin-version");
            String string2 = xmlReader.getChild(new String[]{"configuration"}).readAttribute("target");
            if (string2 == null) {
                return null;
            }
            if (string == null) {
                string = "1.0";
            }
            return new Pair((Object)string2, (Object)string);
        }
        return null;
    }

    public static Target getCurrentTarget(XmlReader xmlReader) {
        Pair<String, String> pair = ProjectVersionUtils.getStatedTargetAndVersion(xmlReader);
        Target target = PluginManager.getTarget((String)pair.getFirst());
        if (target != null) {
            return target;
        }
        for (Target target2 : PluginManager.getTargets()) {
            if (!target2.getPlugin().getVersionSupport().canConvert((String)pair.getFirst(), (String)pair.getSecond(), target2.getKey(), target2.getPlugin().getSaveVersion(), false)) continue;
            return target2;
        }
        return null;
    }

    public static XmlReader load(XmlReader xmlReader) throws IOException {
        Pair<String, String> pair = ProjectVersionUtils.getStatedTargetAndVersion(xmlReader);
        Target target = ProjectVersionUtils.getCurrentTarget(xmlReader);
        if (pair == null || target == null) {
            return null;
        }
        if (target.getKey().equals(pair.getFirst()) && target.getPlugin().getSaveVersion().equals(pair.getSecond())) {
            return xmlReader;
        }
        if (!target.getPlugin().getVersionSupport().canConvert((String)pair.getFirst(), (String)pair.getSecond(), target.getKey(), target.getPlugin().getSaveVersion())) {
            return xmlReader;
        }
        return target.getPlugin().getVersionSupport().convert(xmlReader, target.getKey(), target.getPlugin().getSaveVersion());
    }

    public static XmlReader export(XmlReader xmlReader) throws IOException {
        Pair<String, String> pair = ProjectVersionUtils.getStatedTargetAndVersion(xmlReader);
        Target target = PluginManager.getTarget((String)pair.getFirst());
        if (target == null || target.getPlugin() == null || target.getPlugin().getSaveVersion() == null || target.getPlugin().getSaveVersion().equals(pair.getSecond())) {
            return xmlReader;
        }
        return target.getPlugin().getVersionSupport().convert(xmlReader, target.getKey(), target.getPlugin().getSaveVersion());
    }
}

