/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.model;

import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.NativeMatlab;
import com.mathworks.project.impl.model.OptionListWithDefault;
import com.mathworks.project.impl.model.Project;
import com.mathworks.project.impl.model.ProjectManager;
import com.mathworks.project.impl.model.ReferenceSource;
import com.mathworks.project.impl.model.Target;
import com.mathworks.project.impl.plugin.DefaultXpathEvaluator;
import com.mathworks.project.impl.plugin.PluginManager;
import com.mathworks.project.impl.plugin.XpathEvaluator;
import com.mathworks.project.impl.util.StringUtils;
import com.mathworks.util.Converter;
import com.mathworks.util.ParameterRunnable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CountDownLatch;

public final class MatlabExpression
implements ReferenceSource {
    private final String fText;
    private final Map<Integer, String> fParameters;
    private final Map<Integer, String> fPassiveParameters;
    private final Set<Integer> fEnumStringParameters;
    private static final Matlab MATLAB = new Matlab();

    public MatlabExpression(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        this.fParameters = new LinkedHashMap<Integer, String>();
        this.fPassiveParameters = new LinkedHashMap<Integer, String>();
        this.fEnumStringParameters = new HashSet<Integer>();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if ((c == '#' || c == '$' || c == '@') && i < string.length() - 1 && string.charAt(i + 1) == '{') {
                int n = string.indexOf(125, i += 2);
                String string2 = string.substring(i, n);
                if (c != '@') {
                    this.fParameters.put(stringBuilder.length(), string2);
                    if (c == '#') {
                        this.fEnumStringParameters.add(stringBuilder.length());
                    }
                } else {
                    this.fPassiveParameters.put(stringBuilder.length(), string2);
                }
                stringBuilder.append('*');
                i = n;
                continue;
            }
            stringBuilder.append(c);
        }
        this.fText = stringBuilder.toString();
    }

    @Override
    public boolean hasReference(String string) {
        for (String string2 : this.fParameters.values()) {
            if (!string2.contains(string)) continue;
            return true;
        }
        return false;
    }

    public void evaluate(final Project project, boolean bl, String[] stringArray) {
        DefaultXpathEvaluator defaultXpathEvaluator = new DefaultXpathEvaluator("configuration");
        String string = this.getCode(project.getConfiguration().getTarget(), defaultXpathEvaluator.compileInput(ProjectManager.configurationToXslInput(project).getXML()), defaultXpathEvaluator, new Converter<String, String>(){

            public String convert(String string) {
                return project.getConfiguration().getParamAsString(string);
            }
        });
        String string2 = "";
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                string2 = string2 + stringArray[i];
                if (i >= stringArray.length - 1) continue;
                string2 = string2 + ", ";
            }
        }
        final String string3 = stringArray == null ? string : string + "(" + string2 + ");";
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        if (NativeMatlab.nativeIsMatlabThread()) {
            try {
                Matlab.mtEval((String)string3);
            }
            catch (Exception exception) {
                throw new IllegalStateException(exception);
            }
        }
        Matlab.whenMatlabIdle((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    Matlab.mtEval((String)MatlabExpression.workaroundStaticWorkspaceBug(string3));
                }
                catch (Exception exception) {
                    throw new IllegalStateException(exception);
                }
                countDownLatch.countDown();
            }
        });
        if (bl) {
            try {
                countDownLatch.await();
            }
            catch (InterruptedException interruptedException) {
                throw new IllegalStateException(interruptedException);
            }
        }
    }

    public void evaluate(Project project, boolean bl) {
        this.evaluate(project, bl, null);
    }

    public <CompiledInputType, CompiledXPathType> void evaluate(Target target, CompiledInputType CompiledInputType, XpathEvaluator<CompiledInputType, CompiledXPathType> xpathEvaluator, final ParameterRunnable<OptionListWithDefault> parameterRunnable, Converter<String, String> converter) {
        final String string = this.getCode(target, CompiledInputType, xpathEvaluator, converter);
        MATLAB.fevalConsoleOutput("eval", new Object[]{string}, 2, new CompletionObserver(){

            public void completed(int n, Object object) {
                LinkedHashMap<String, String> linkedHashMap;
                String string3;
                if (Matlab.getExecutionStatus((int)n) == 0) {
                    Object[] objectArray = (Object[])object;
                    String[] stringArray = (String[])objectArray[0];
                    string3 = (String)objectArray[1];
                    linkedHashMap = new LinkedHashMap<String, String>();
                    for (String string2 : stringArray) {
                        linkedHashMap.put(string2, string2);
                    }
                    if (!linkedHashMap.containsKey(string3)) {
                        throw new IllegalStateException("MATLAB code '" + string + "' returned default option '" + string3 + "' not in the list of options: " + linkedHashMap.values());
                    }
                } else {
                    throw new IllegalStateException("Unable to execute MATLAB code: '" + string + "'");
                }
                parameterRunnable.run((Object)new OptionListWithDefault(linkedHashMap, string3));
            }
        });
    }

    public <CompiledInputType, CompiledXPathType> void evaluateAsString(Target target, CompiledInputType CompiledInputType, XpathEvaluator<CompiledInputType, CompiledXPathType> xpathEvaluator, final ParameterRunnable<String> parameterRunnable, Converter<String, String> converter) {
        this.evaluateAsObject(target, CompiledInputType, xpathEvaluator, new ParameterRunnable<Object>(){

            public void run(Object object) {
                parameterRunnable.run((Object)object.toString());
            }
        }, converter);
    }

    public <CompiledInputType, CompiledXPathType> void evaluateAsObject(Target target, CompiledInputType CompiledInputType, XpathEvaluator<CompiledInputType, CompiledXPathType> xpathEvaluator, final ParameterRunnable<Object> parameterRunnable, Converter<String, String> converter) {
        final String string = this.getCode(target, CompiledInputType, xpathEvaluator, converter);
        CompletionObserver completionObserver = new CompletionObserver(){

            public void completed(int n, Object object) {
                if (Matlab.getExecutionStatus((int)n) != 0) {
                    throw new IllegalStateException("Unable to execute MATLAB code: '" + string + "'");
                }
                parameterRunnable.run(object);
            }
        };
        if (PluginManager.isMatlabThreadUseAllowed() && Matlab.isMatlabAvailable() && NativeMatlab.nativeIsMatlabThread()) {
            try {
                Object object = Matlab.mtFevalConsoleOutput((String)"eval", (Object[])new Object[]{string}, (int)1);
                parameterRunnable.run(object);
            }
            catch (Exception exception) {
                throw new IllegalStateException("Unable to execute MATLAB code: '" + string + "'", exception);
            }
        } else {
            MATLAB.fevalConsoleOutput("eval", new Object[]{string}, 1, completionObserver);
        }
    }

    <CompiledInputType, CompiledXPathType> String getCode(Target target, CompiledInputType CompiledInputType, XpathEvaluator<CompiledInputType, CompiledXPathType> xpathEvaluator, Converter<String, String> converter) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String charSequence2 : this.fParameters.values()) {
            CompiledXPathType n = xpathEvaluator.compileXPath(charSequence2);
            hashMap.put(charSequence2, xpathEvaluator.evaluate(CompiledInputType, n));
        }
        TreeMap<Integer, String> treeMap = new TreeMap<Integer, String>(this.fParameters);
        treeMap.putAll(this.fPassiveParameters);
        StringBuilder stringBuilder = new StringBuilder(this.fText);
        int n = 0;
        for (Map.Entry entry : treeMap.entrySet()) {
            String string = (String)entry.getValue();
            int n2 = (Integer)entry.getKey() + n;
            String string2 = (String)hashMap.get(string);
            if (string2 == null && this.fPassiveParameters.containsKey(entry.getKey())) {
                string2 = (String)converter.convert((Object)string);
            } else if (this.fEnumStringParameters.contains(entry.getKey())) {
                string2 = target.getParam(string).getOptions().get(string2);
            }
            stringBuilder.replace(n2, n2 + 1, string2);
            n += string2.length() - 1;
        }
        return StringUtils.normalizeSpace(stringBuilder.toString());
    }

    private static String workaroundStaticWorkspaceBug(String string) {
        if (string.contains(".instance.")) {
            CharSequence charSequence;
            int n;
            StringBuilder stringBuilder = new StringBuilder();
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '(') {
                    n = 1;
                    charSequence = new StringBuilder();
                    ++i;
                    while (n > 0) {
                        if (string.charAt(i) == ')') {
                            --n;
                        } else if (string.charAt(i) == '(') {
                            ++n;
                        } else if (n == 1 && string.charAt(i) == ',') {
                            arrayList.add(((StringBuilder)charSequence).toString().trim());
                            ((StringBuilder)charSequence).setLength(0);
                        } else {
                            ((StringBuilder)charSequence).append(string.charAt(i));
                        }
                        ++i;
                    }
                    if (((StringBuilder)charSequence).length() <= 0) break;
                    arrayList.add(((StringBuilder)charSequence).toString().trim());
                    break;
                }
                stringBuilder.append(string.charAt(i));
            }
            StringBuilder stringBuilder2 = new StringBuilder();
            stringBuilder2.append("feval(@(x");
            for (n = 0; n < arrayList.size(); ++n) {
                stringBuilder2.append(",i" + n);
            }
            stringBuilder2.append(")x.");
            n = stringBuilder.lastIndexOf(".");
            charSequence = stringBuilder.substring(0, n);
            String string2 = stringBuilder.substring(n + 1);
            stringBuilder2.append(string2);
            stringBuilder2.append('(');
            for (int i = 0; i < arrayList.size(); ++i) {
                stringBuilder2.append("i" + i);
                if (i >= arrayList.size() - 1) continue;
                stringBuilder2.append(',');
            }
            stringBuilder2.append("), " + (String)charSequence);
            for (String string3 : arrayList) {
                stringBuilder2.append(", " + string3);
            }
            stringBuilder2.append(")");
            return stringBuilder2.toString();
        }
        return string;
    }
}

