/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.filesetui;

import com.mathworks.mwswing.MJPanel;
import com.mathworks.project.impl.HyperlinkMJLabel;
import com.mathworks.widgets.desk.DTClientBase;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;

public final class LinkBar {
    private final MJPanel fComponent;
    private final List<HyperlinkMJLabel> fLinks;
    private final Map<HyperlinkMJLabel, Point> fDesiredLocations = new HashMap<HyperlinkMJLabel, Point>();
    private Component fParent;
    private ComponentListener fListener = new ComponentAdapter(){

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            LinkBar.this.updateLayout();
        }
    };
    private int fLastWidth;
    private int fPreferredHeight;
    private static final int HORIZONTAL_SPACE = 5;
    private static final int VERTICAL_SPACE = 3;

    public LinkBar() {
        this.fComponent = new MJPanel(null){

            public void doLayout() {
                super.doLayout();
                for (HyperlinkMJLabel hyperlinkMJLabel : LinkBar.this.fLinks) {
                    Point point = (Point)LinkBar.this.fDesiredLocations.get((Object)hyperlinkMJLabel);
                    if (point == null) {
                        LinkBar.this.updateLayout();
                        return;
                    }
                    Dimension dimension = hyperlinkMJLabel.getPreferredSize();
                    hyperlinkMJLabel.setBounds(point.x, point.y, dimension.width, dimension.height);
                }
            }

            public Dimension getPreferredSize() {
                return new Dimension(LinkBar.this.fLastWidth, LinkBar.this.fPreferredHeight);
            }

            public void addNotify() {
                super.addNotify();
                LinkBar.this.fParent = this.getParent();
                LinkBar.this.fParent.addComponentListener(LinkBar.this.fListener);
                LinkBar.this.updateLayout();
            }

            public void removeNotify() {
                super.removeNotify();
                LinkBar.this.fParent.removeComponentListener(LinkBar.this.fListener);
            }
        };
        this.fComponent.setOpaque(false);
        this.fLinks = new ArrayList<HyperlinkMJLabel>();
    }

    public void removeAll() {
        this.fLastWidth = 0;
        this.fLinks.clear();
        this.fComponent.removeAll();
        this.updateLayout();
    }

    public void addLink(HyperlinkMJLabel hyperlinkMJLabel) {
        this.fLinks.add(hyperlinkMJLabel);
        this.fComponent.add((Component)((Object)hyperlinkMJLabel));
        this.fLastWidth = 0;
        this.updateLayout();
    }

    /*
     * WARNING - void declaration
     */
    private void updateLayout() {
        if (this.fParent != null && this.fLastWidth != this.fParent.getWidth()) {
            void var4_9;
            this.fDesiredLocations.clear();
            this.fLastWidth = this.fParent.getWidth();
            int n = -1;
            int n2 = -1;
            for (int i = this.fLinks.size() - 1; i >= 0; --i) {
                HyperlinkMJLabel object2 = this.fLinks.get(i);
                if (n2 == -1) {
                    n2 = (int)(-object2.getPreferredSize().getHeight());
                }
                if (n == -1) {
                    n = Math.max(0, (int)((double)this.fLastWidth - object2.getPreferredSize().getWidth()));
                } else {
                    n -= 5;
                    if ((n = (int)((double)n - object2.getPreferredSize().getWidth())) < 0) {
                        n = -1;
                        n2 -= 3;
                        n2 = (int)((double)n2 - object2.getPreferredSize().getHeight());
                        ++i;
                        continue;
                    }
                }
                this.fDesiredLocations.put(object2, new Point(n, n2));
            }
            this.fPreferredHeight = -n2;
            for (Point point : this.fDesiredLocations.values()) {
                point.y = this.fPreferredHeight + point.y;
            }
            MJPanel object3 = this.fComponent;
            MJPanel mJPanel = this.fComponent;
            while (var4_9 != null && !(var4_9 instanceof DTClientBase)) {
                var4_9.invalidate();
                object3 = var4_9;
                Container container = var4_9.getParent();
            }
            object3.validate();
            object3.repaint();
        }
    }

    public JComponent getComponent() {
        return this.fComponent;
    }
}

