/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.desktop;

import com.mathworks.common.icons.DocumentIcon;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.project.api.DeploymentProcess;
import com.mathworks.project.api.DeploymentProcessMonitor;
import com.mathworks.project.api.InvalidProjectException;
import com.mathworks.project.impl.BuiltInResources;
import com.mathworks.project.impl.ProjectGUI;
import com.mathworks.project.impl.desktop.DeploymentProcessAction;
import com.mathworks.project.impl.desktop.ProjectClient;
import com.mathworks.project.impl.engine.DeploymentEngine;
import com.mathworks.project.impl.model.Project;
import com.mathworks.project.impl.model.ProjectManager;
import com.mathworks.project.impl.model.Workflow;
import com.mathworks.project.impl.workflowui.WorkflowDialog;
import java.awt.event.ActionEvent;
import javax.swing.Icon;

public final class BuildAction
extends DeploymentProcessAction {
    public static final String KEY = "BUILD";

    public BuildAction(ProjectClient projectClient) {
        super(projectClient, KEY, (Icon)DocumentIcon.BUILD.getIcon());
        if (projectClient.getClass().getName().contains("HDL")) {
            this.setName(BuiltInResources.getString("action.workflow"));
            this.setTip(this.getName());
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.startBuild(null);
    }

    public void startBuild(final DeploymentProcessMonitor deploymentProcessMonitor) {
        final Project project = ProjectGUI.getInstance().getCurrentProject();
        if (project == null) {
            return;
        }
        this.setEnabled(false);
        project.getConfiguration().afterPendingComputations(new Runnable(){

            @Override
            public void run() {
                MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ProjectManager.forceSave(project);
                        BuildAction.this.setEnabled(true);
                        Workflow workflow = project.getConfiguration().getTarget().getWorkflow();
                        if (workflow != null) {
                            WorkflowDialog.invoke(project);
                        } else {
                            BuildAction.this.startBuildWithoutWorkflow(project, deploymentProcessMonitor);
                        }
                    }
                });
            }
        });
    }

    private void startBuildWithoutWorkflow(Project project, DeploymentProcessMonitor deploymentProcessMonitor) {
        this.startBuildWithoutWorkflow(project, new DefaultProcessFactory(), deploymentProcessMonitor);
    }

    public void startBuildWithoutWorkflow(final Project project, ProcessFactory processFactory, final DeploymentProcessMonitor deploymentProcessMonitor) {
        block2: {
            try {
                final DeploymentProcess deploymentProcess = processFactory.createProcess(project);
                MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (ProjectGUI.getInstance().getCurrentProcess() != null) {
                            return;
                        }
                        ProjectManager.waitForSave(project);
                        if (deploymentProcessMonitor != null) {
                            deploymentProcess.addMonitor(deploymentProcessMonitor);
                        }
                        BuildAction.this.start(deploymentProcess);
                    }
                });
            }
            catch (InvalidProjectException invalidProjectException) {
                this.displayValidationError(invalidProjectException);
                if (deploymentProcessMonitor == null) break block2;
                deploymentProcessMonitor.failed();
            }
        }
    }

    public static class DefaultProcessFactory
    implements ProcessFactory {
        @Override
        public DeploymentProcess createProcess(Project project) throws InvalidProjectException {
            return DeploymentEngine.createBuildProcess(project);
        }
    }

    public static interface ProcessFactory {
        public DeploymentProcess createProcess(Project var1) throws InvalidProjectException;
    }
}

