/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl;

import com.mathworks.mlwidgets.util.UIFileUtils;
import com.mathworks.mwswing.validation.Validatable;
import com.mathworks.mwswing.validation.Validity;
import com.mathworks.project.impl.BuiltInResources;
import com.mathworks.util.ReturnRunnable;
import com.mathworks.widgets.ValidatableWithHelp;
import com.mathworks.widgets.ValidityWithHelp;
import java.io.File;
import java.util.Locale;

public final class ProjectNameValidator
implements ValidatableWithHelp {
    private final ReturnRunnable<File> fLocationProvider;
    private final File fCurrentFile;

    public ProjectNameValidator(ReturnRunnable<File> returnRunnable) {
        this.fCurrentFile = null;
        this.fLocationProvider = returnRunnable;
    }

    public ProjectNameValidator(File file) {
        this.fCurrentFile = file;
        this.fLocationProvider = new ReturnRunnable<File>(){

            public File run() {
                return ProjectNameValidator.this.fCurrentFile.getParentFile();
            }
        };
    }

    public ValidityWithHelp getValidity(String string) {
        File file;
        if ((string = string.trim()).length() == 0) {
            return this.getValidityWhenBlank();
        }
        String string2 = UIFileUtils.validateNameChars((String)string);
        if (string2 != null) {
            return new ValidityWithHelp(Validity.INVALID, string2);
        }
        string2 = string;
        if (!string2.toLowerCase(Locale.ENGLISH).endsWith(".prj".toLowerCase(Locale.ENGLISH))) {
            string2 = string2 + ".prj";
        }
        if ((file = new File((File)this.fLocationProvider.run(), string2)).exists() && (this.fCurrentFile == null || !file.equals(this.fCurrentFile))) {
            return new ValidityWithHelp(Validity.WARNING, BuiltInResources.getString("warningtip.name.exists"));
        }
        return new ValidityWithHelp(Validity.VALID);
    }

    public Validatable withoutHelp() {
        return new Validatable(){

            public Validity validateText(String string) {
                return ProjectNameValidator.this.getValidity(string).getValidity();
            }

            public Validity getValidityWhenBlank() {
                return ProjectNameValidator.this.getValidityWhenBlank().getValidity();
            }
        };
    }

    public ValidityWithHelp getValidityWhenBlank() {
        return new ValidityWithHelp(Validity.INVALID, BuiltInResources.getString("errortip.name.blank"));
    }
}

