/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl;

import com.mathworks.matlab.api.explorer.CoreFileDecoration;
import com.mathworks.matlab.api.explorer.FileDecoration;
import com.mathworks.matlab.api.explorer.FileDecorations;
import com.mathworks.matlab.api.explorer.FileDecorators;
import com.mathworks.matlab.api.explorer.FileInfoProvider;
import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.project.impl.BuiltInResources;
import com.mathworks.project.impl.model.ProjectManager;
import com.mathworks.project.impl.model.Target;
import com.mathworks.util.Converter;
import java.text.MessageFormat;
import javax.swing.Icon;

public class ProjectFileInfoProvider
implements FileInfoProvider {
    private static final FileDecoration<Target> sTypeDecoration = new FileDecoration("deployment-project-type");

    public boolean isApplicable(FileSystemEntry fileSystemEntry) {
        return !fileSystemEntry.isFolder() && fileSystemEntry.getName().endsWith(".prj");
    }

    public void configureDecorations(final FileSystemEntry fileSystemEntry, FileDecorators fileDecorators, FileDecorations fileDecorations) {
        fileDecorators.set(sTypeDecoration, ProjectManager.createTypeRetriever(fileSystemEntry));
        fileDecorators.set(CoreFileDecoration.ICON, sTypeDecoration, (Converter)new Converter<Target, Icon>(){

            public Icon convert(Target target) {
                return target.getIcon();
            }
        });
        fileDecorators.set(CoreFileDecoration.TYPE_NAME, sTypeDecoration, (Converter)new Converter<Target, String>(){

            public String convert(Target target) {
                String string = null;
                if (target.getFileDescriptorOverride() != null) {
                    string = (String)target.getFileDescriptorOverride().convert((Object)fileSystemEntry);
                }
                return MessageFormat.format(BuiltInResources.getString("fileinfo.description"), string != null ? string : target.getName());
            }
        });
    }
}

