/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl;

import com.mathworks.jmi.MatlabPath;
import com.mathworks.matlab.api.explorer.ActionDefinition;
import com.mathworks.matlab.api.explorer.ActionInput;
import com.mathworks.matlab.api.explorer.ActionInputSource;
import com.mathworks.matlab.api.explorer.ActionProvider;
import com.mathworks.matlab.api.explorer.ActionRegistry;
import com.mathworks.matlab.api.explorer.CoreActionID;
import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.matlab.api.explorer.Status;
import com.mathworks.mlwidgets.explorer.model.ExplorerExtensionRegistry;
import com.mathworks.mlwidgets.explorer.model.MatlabPathModel;
import com.mathworks.mlwidgets.explorer.model.actions.ActionManager;
import com.mathworks.mlwidgets.explorer.model.actions.DefaultActionInput;
import com.mathworks.mlwidgets.explorer.model.realfs.RealFileSystem;
import com.mathworks.mwswing.ExtendedAction;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.project.impl.BuiltInResources;
import com.mathworks.project.impl.ProjectGUI;
import com.mathworks.project.impl.ProjectKeyBindings;
import com.mathworks.project.impl.filesetui.FileSetEditor;
import com.mathworks.project.impl.filesetui.FileSetEditorGroup;
import com.mathworks.project.impl.model.EntityDefinition;
import com.mathworks.project.impl.model.EntityInstance;
import com.mathworks.project.impl.util.StringUtils;
import com.mathworks.util.Log;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.Predicate;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;

public enum FileAndEntityActions {
    OPEN_FILE{

        @Override
        protected void configure() {
            this.setKeyBindingId("open-selection");
            this.setApplicableToDynamicFiles(false);
            this.setCoreActionId(CoreActionID.OPEN);
        }

        @Override
        public void run(FileSetEditorGroup fileSetEditorGroup) {
            if (!FileAndEntityActions.checkForMissingBuildDeliverables(fileSetEditorGroup)) {
                List<File> list = fileSetEditorGroup.getSelectedOpenableFiles();
                List list2 = FileAndEntityActions.getEntries(list);
                Status status = sActionManager.run(CoreActionID.OPEN, list2);
                ProjectGUI.getInstance().getCurrentClient().monitor(status);
            }
        }
    }
    ,
    OPEN_OUTSIDE_MATLAB{

        @Override
        public void configure() {
            this.setIsApplicableOnUnix(false);
            this.setCoreActionId(CoreActionID.OPEN_OUTSIDE_MATLAB);
        }

        @Override
        public void run(FileSetEditorGroup fileSetEditorGroup) {
            if (!FileAndEntityActions.checkForMissingBuildDeliverables(fileSetEditorGroup)) {
                List<File> list = fileSetEditorGroup.getSelectedFiles();
                List list2 = FileAndEntityActions.getEntries(list);
                Status status = sActionManager.run(CoreActionID.OPEN_OUTSIDE_MATLAB, list2);
                ProjectGUI.getInstance().getCurrentClient().monitor(status);
            }
        }
    }
    ,
    REMOVE{

        @Override
        protected void configure() {
            this.setKeyBindingId("delete-next");
            this.setApplicableToDynamicFiles(false);
            this.setApplicableToEntities(true);
        }

        @Override
        public void run(FileSetEditorGroup fileSetEditorGroup) {
            for (FileSetEditor fileSetEditor : fileSetEditorGroup.getEditors()) {
                fileSetEditor.removePaths(fileSetEditor.getSelectedPaths());
            }
        }
    }
    ,
    RENAME{

        @Override
        public void configure() {
            this.setKeyBindingId("rename");
            this.setApplicableToExplicitFiles(false);
            this.setApplicableToDynamicFiles(false);
            this.setApplicableToEntities(true);
        }

        @Override
        public Object[] getLabelParameters(FileSetEditorGroup fileSetEditorGroup) {
            for (FileSetEditor fileSetEditor : fileSetEditorGroup.getEditors()) {
                List<EntityDefinition> list;
                List<EntityDefinition> list2 = fileSetEditor.getFileSet().getDefinition().getRootLevelEntities();
                if (list2.isEmpty() || (list = list2.get(0).getChildren()).isEmpty()) continue;
                return new Object[]{list.get(0).getName()};
            }
            return super.getLabelParameters(fileSetEditorGroup);
        }

        @Override
        public void run(FileSetEditorGroup fileSetEditorGroup) {
            for (FileSetEditor fileSetEditor : fileSetEditorGroup.getEditors()) {
                List<EntityInstance> list = fileSetEditor.getSelectedEntities();
                if (list.isEmpty()) continue;
                fileSetEditor.startRenaming(list.get(0));
                break;
            }
        }
    }
    ,
    LOCATE_ON_DISK{

        @Override
        public void configure() {
            this.setIsApplicableOnUnix(false);
            this.setCoreActionId(CoreActionID.LOCATE_ON_DISK);
        }

        @Override
        public void run(FileSetEditorGroup fileSetEditorGroup) {
            if (!FileAndEntityActions.checkForMissingBuildDeliverables(fileSetEditorGroup)) {
                List<File> list = fileSetEditorGroup.getSelectedFiles();
                List list2 = FileAndEntityActions.getEntries(list);
                Status status = sActionManager.run(CoreActionID.LOCATE_ON_DISK, list2);
                ProjectGUI.getInstance().getCurrentClient().monitor(status);
            }
        }
    }
    ,
    CD_TO_LOCATION{

        @Override
        public void configure() {
            this.setCoreActionId(CoreActionID.CD_TO_LOCATION);
        }

        @Override
        public void run(FileSetEditorGroup fileSetEditorGroup) {
            List<File> list = fileSetEditorGroup.getSelectedFiles();
            if (!list.isEmpty()) {
                MatlabPath.setCWD((String)list.get(0).getParentFile().getAbsolutePath());
            }
        }
    };

    private final String fLabelKey = "action." + StringUtils.upperCaseToCamelCase(this.toString(), false);
    private String fKeyBindingId;
    private CoreActionID fCoreActionId;
    private boolean fIsApplicableToEntities;
    private boolean fIsApplicableToExplicitFiles = true;
    private boolean fIsApplicableToDynamicFiles = true;
    private boolean fIsApplicableOnUnix = true;
    private static final InputSource sInputSource;
    private static ActionManager sActionManager;

    static void installActionManager() {
        MJUtilities.assertEventDispatchThread();
        if (sActionManager == null) {
            sActionManager = new ActionManager("Explorer", (ActionInputSource)sInputSource, FileAndEntityActions.getActionProviders(), Boolean.valueOf(false), Boolean.valueOf(false), new Object[]{CoreActionID.OPEN, CoreActionID.LOCATE_ON_DISK, CoreActionID.OPEN_OUTSIDE_MATLAB});
        }
    }

    static void uninstallActionManager() {
        MJUtilities.assertEventDispatchThread();
        if (sActionManager != null) {
            sActionManager.dispose();
            sActionManager = null;
        }
    }

    static List<ActionProvider> getActionProviders() {
        ArrayList<ActionProvider> arrayList = new ArrayList<ActionProvider>();
        arrayList.add(new ActionProvider(){

            public boolean isApplicable(FileSystemEntry fileSystemEntry) {
                return true;
            }

            public void configureActions(ActionRegistry actionRegistry) {
                actionRegistry.getAction(CoreActionID.CD_TO_LOCATION).setEnabled((Predicate)new Predicate<ActionInput>(){

                    public boolean accept(ActionInput actionInput) {
                        FileLocation fileLocation = MatlabPathModel.getInstance().getCurrentFolder();
                        return fileLocation == null || !((FileSystemEntry)actionInput.getSelection().get(0)).getLocation().getParent().equals((Object)fileLocation);
                    }
                });
            }
        });
        arrayList.addAll(ExplorerExtensionRegistry.getInstance().getActionProviders());
        return arrayList;
    }

    private FileAndEntityActions() {
        this.configure();
    }

    protected void configure() {
    }

    protected void setCoreActionId(CoreActionID coreActionID) {
        this.fCoreActionId = coreActionID;
    }

    protected void setKeyBindingId(String string) {
        this.fKeyBindingId = string;
    }

    protected void setApplicableToEntities(boolean bl) {
        this.fIsApplicableToEntities = bl;
    }

    protected void setApplicableToExplicitFiles(boolean bl) {
        this.fIsApplicableToExplicitFiles = bl;
    }

    protected void setApplicableToDynamicFiles(boolean bl) {
        this.fIsApplicableToDynamicFiles = bl;
    }

    protected void setIsApplicableOnUnix(boolean bl) {
        this.fIsApplicableOnUnix = bl;
    }

    public boolean isVisible(List<File> list) {
        return this.fCoreActionId == null || sActionManager.isVisibleOnContextMenu(this.fCoreActionId, FileAndEntityActions.getEntries(list));
    }

    public boolean isApplicableToEntities() {
        return this.fIsApplicableToEntities;
    }

    public boolean isApplicableToExplicitFiles() {
        return this.fIsApplicableToExplicitFiles;
    }

    public boolean isApplicableToDynamicFiles() {
        return this.fIsApplicableToDynamicFiles;
    }

    public boolean isApplicableOnCurrentPlatform() {
        return !PlatformInfo.isUnix() || PlatformInfo.isMacintosh() || this.fIsApplicableOnUnix;
    }

    public MJAbstractAction instantiate(final FileSetEditorGroup fileSetEditorGroup) {
        String string = MessageFormat.format(BuiltInResources.getString(this.fLabelKey), this.getLabelParameters(fileSetEditorGroup));
        MJAbstractAction mJAbstractAction = new MJAbstractAction(string){

            public void actionPerformed(ActionEvent actionEvent) {
                FileAndEntityActions.this.run(fileSetEditorGroup);
            }
        };
        mJAbstractAction.setComponentName(this.fLabelKey);
        if (this.fKeyBindingId != null) {
            ProjectKeyBindings.bind(this.fKeyBindingId, (ExtendedAction)mJAbstractAction, fileSetEditorGroup);
        }
        mJAbstractAction.setName(string);
        return mJAbstractAction;
    }

    protected Object[] getLabelParameters(FileSetEditorGroup fileSetEditorGroup) {
        return new Object[0];
    }

    public abstract void run(FileSetEditorGroup var1);

    private static List<FileSystemEntry> getEntries(List<File> list) {
        ArrayList<FileSystemEntry> arrayList = new ArrayList<FileSystemEntry>();
        for (File file : list) {
            try {
                if (!file.exists()) continue;
                arrayList.add(RealFileSystem.getInstance().getEntry(new FileLocation(file)));
            }
            catch (IOException iOException) {
                Log.logException((Exception)iOException);
            }
        }
        return arrayList;
    }

    private static boolean checkForMissingBuildDeliverables(FileSetEditorGroup fileSetEditorGroup) {
        List<File> list = fileSetEditorGroup.getSelectedExplicitFiles();
        HashSet<File> hashSet = new HashSet<File>();
        hashSet.addAll(fileSetEditorGroup.getSelectedFiles());
        hashSet.removeAll(list);
        for (File file : hashSet) {
            if (file.exists()) continue;
            MJOptionPane.showMessageDialog((Component)ProjectGUI.getInstance().getCurrentClient().getComponent(), (Object)MessageFormat.format(BuiltInResources.getString("error.action.missing.build.deliverable"), file.getName()), (String)BuiltInResources.getString("error.action.title"), (int)0);
            return true;
        }
        return false;
    }

    static {
        sInputSource = new InputSource();
    }

    private static class InputSource
    implements ActionInputSource {
        private InputSource() {
        }

        public JComponent getDefaultComponent() {
            return ProjectGUI.getInstance().getCurrentClient().getComponent();
        }

        public ActionInput getCurrentInput() {
            return new DefaultActionInput(this.getDefaultComponent(), new File[0]);
        }

        public ActionInput createInput(List<FileSystemEntry> list) {
            return new DefaultActionInput(this.getDefaultComponent(), ExplorerExtensionRegistry.getInstance(), list);
        }

        public void notifyActionPerformed(ActionDefinition actionDefinition, Status status) {
            ProjectGUI.getInstance().getCurrentClient().monitor(status);
        }

        public void addInputChangeListener(ChangeListener changeListener) {
        }

        public void removeInputChangeListener(ChangeListener changeListener) {
        }

        public boolean prepareToShowContextMenu(JComponent jComponent, MouseEvent mouseEvent) {
            return true;
        }
    }
}

