/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.webproxy;

import com.mathworks.net.transport.MWTransportClientPropertiesFactory;
import com.mathworks.webproxy.DefaultProxyConfiguration;
import com.mathworks.webproxy.NativeProxySettings;
import com.mathworks.webproxy.PropertiesProxyConfiguration;
import com.mathworks.webproxy.PropertiesProxyConfigurationImpl;
import com.mathworks.webproxy.ProxyAuthenticator;
import com.mathworks.webproxy.ProxyAuthenticatorImpl;
import com.mathworks.webproxy.ProxyConfiguration;
import com.mathworks.webproxy.SystemProxySettings;
import java.net.Proxy;
import java.net.URL;

public final class WebproxyFactory {
    private static boolean useSystemProxies;
    private static final SystemProxySettings systemProxySettings;

    private WebproxyFactory() {
    }

    public static SystemProxySettings createSystemProxySettings() {
        return new NativeProxySettings();
    }

    public static SystemProxySettings createSystemProxySettings(String string) {
        return new NativeProxySettings(string);
    }

    public static ProxyConfiguration createDefaultProxyConfiguration(SystemProxySettings systemProxySettings) {
        return WebproxyFactory.isUseSystemProxiesEnabled() ? WebproxyFactory.createProxyConfigurationUsingSystemProxies(systemProxySettings) : WebproxyFactory.createPropertiesOnlyProxyConfiguration();
    }

    private static DefaultProxyConfiguration createProxyConfigurationUsingSystemProxies(SystemProxySettings systemProxySettings) {
        return new DefaultProxyConfiguration(MWTransportClientPropertiesFactory.create((String)"http"), systemProxySettings);
    }

    public static PropertiesProxyConfiguration createPropertiesOnlyProxyConfiguration() {
        return new PropertiesProxyConfigurationImpl(MWTransportClientPropertiesFactory.create((String)"http"));
    }

    public static ProxyAuthenticator createProxyAuthenticator() {
        return new ProxyAuthenticatorImpl();
    }

    public static Proxy findProxyForURL(URL uRL) {
        Proxy proxy = WebproxyFactory.createDefaultProxyConfiguration(systemProxySettings).findProxyForURL(uRL);
        return Proxy.NO_PROXY.equals(proxy) ? null : proxy;
    }

    public static void setUseSystemProxiesEnabled(boolean bl) {
        useSystemProxies = bl;
    }

    public static boolean isUseSystemProxiesEnabled() {
        return useSystemProxies;
    }

    static {
        systemProxySettings = WebproxyFactory.createSystemProxySettings();
        useSystemProxies = Boolean.parseBoolean(System.getProperty("com.mathworks.useSystemProxies", "true"));
    }
}

