/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.axis;

import com.jidesoft.chart.axis.AbstractTimeTickCalculator;
import com.jidesoft.chart.axis.Axis;
import com.jidesoft.chart.axis.DefaultTimeTickCalculator;
import com.jidesoft.chart.axis.Tick;
import com.jidesoft.range.Range;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleTimeTickCalculator
extends AbstractTimeTickCalculator {
    private int d;
    private int e = 1;

    public SimpleTimeTickCalculator(int n) {
        this.d = n;
        this.setDateFormat(this.createDateFormat(n));
    }

    public SimpleTimeTickCalculator(int n, int n2) {
        this.d = n;
        this.e = n2;
        this.setDateFormat(this.createDateFormat(n));
    }

    protected DateFormat createDateFormat(int n) {
        switch (n) {
            case 9: {
                return new SimpleDateFormat("dd-MMM HH:mm");
            }
            case 5: {
                return new SimpleDateFormat("dd-MMM");
            }
            case 7: {
                return new SimpleDateFormat("dd-MMM");
            }
            case 8: {
                return new SimpleDateFormat("dd-MMM");
            }
            case 6: {
                return new SimpleDateFormat("dd-MMM");
            }
            case 10: {
                return new SimpleDateFormat("dd-MMM HH:mm");
            }
            case 11: {
                return new SimpleDateFormat("dd-MMM HH:mm");
            }
            case 14: {
                throw new UnsupportedOperationException("Sorry, milliseconds not supported");
            }
            case 12: {
                return new SimpleDateFormat("dd-MMM HH:mm");
            }
            case 2: {
                return new SimpleDateFormat("MMM-yy");
            }
            case 13: {
                return new SimpleDateFormat("HH:mm:ss");
            }
            case 4: {
                return new SimpleDateFormat("dd-MMM");
            }
            case 3: {
                return new SimpleDateFormat("dd-MMM");
            }
            case 1: {
                return new SimpleDateFormat("yyyy");
            }
        }
        throw new UnsupportedOperationException("Unexpected field while creating Date format");
    }

    @Override
    public Tick[] calculateTicks(Range<Date> range) {
        ArrayList<Tick> arrayList;
        ArrayList<Tick> arrayList2;
        block6: {
            DateFormat dateFormat;
            TimeZone timeZone;
            boolean bl;
            block8: {
                DateFormat dateFormat2;
                block7: {
                    bl = Axis.B;
                    timeZone = this.getTimeZone();
                    dateFormat2 = dateFormat = this.getDateFormat();
                    if (bl) break block7;
                    if (dateFormat2 == null) break block8;
                    dateFormat2 = dateFormat;
                }
                timeZone = dateFormat2.getTimeZone();
            }
            Calendar calendar = Calendar.getInstance(timeZone);
            Calendar calendar2 = Calendar.getInstance(timeZone);
            calendar.setTime(range.lower());
            calendar2.setTime(range.upper());
            Calendar calendar3 = DefaultTimeTickCalculator.min(calendar, calendar2);
            calendar2.add(this.d, 1);
            arrayList2 = new ArrayList<Tick>();
            while (calendar3.before(calendar2)) {
                long l = calendar3.getTimeInMillis();
                String string = dateFormat.format(calendar3.getTime());
                arrayList = arrayList2;
                if (!bl) {
                    arrayList.add(new Tick((double)l, string));
                    calendar3.add(this.d, this.e);
                    if (!bl) continue;
                }
                break block6;
            }
            arrayList = arrayList2;
        }
        return arrayList.toArray(new Tick[arrayList2.size()]);
    }
}

