/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlab.api.explorer;

import com.mathworks.util.Holder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import javax.swing.SwingUtilities;

public final class Status {
    private final List<Runnable> fCompletionRunnables;
    private final Object fLock;
    private final CountDownLatch fLatch;
    private final String fLabel;
    private final boolean fHeavy;
    private boolean fIsCompleted;
    private boolean fIsCanceled;
    private boolean fIsCancelRequested;
    public static final Status COMPLETED = new Status(null, false, true);

    public Status() {
        this(null, false);
    }

    public Status(String string, boolean bl) {
        this(string, bl, false);
    }

    public Status(List<Status> list) {
        this(list.size() == 1 ? list.get(0).getLabel() : null, Status.isAnyHeavy(list), false);
        if (list.isEmpty()) {
            this.markCompleted();
        } else {
            final Holder holder = new Holder();
            holder.set((Object)list.size());
            for (Status status : list) {
                status.addCompletionOrCancellationRunnable(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Holder holder2 = holder;
                        synchronized (holder2) {
                            holder.set((Object)((Integer)holder.get() - 1));
                            if ((Integer)holder.get() == 0) {
                                Status.this.markCompleted();
                            }
                        }
                    }
                });
            }
        }
    }

    private Status(String string, boolean bl, boolean bl2) {
        this.fLabel = string;
        this.fHeavy = bl;
        this.fCompletionRunnables = new ArrayList<Runnable>();
        this.fIsCompleted = bl2;
        this.fLatch = new CountDownLatch(1);
        this.fLock = new Object();
    }

    private static boolean isAnyHeavy(List<Status> list) {
        for (Status status : list) {
            if (!status.isHeavy()) continue;
            return true;
        }
        return false;
    }

    public boolean isHeavy() {
        return this.fHeavy;
    }

    public String getLabel() {
        return this.fLabel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCompleted() {
        Object object = this.fLock;
        synchronized (object) {
            return this.fIsCompleted;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSuccessfullyCanceled() {
        Object object = this.fLock;
        synchronized (object) {
            return this.fIsCanceled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestCancellation() {
        Object object = this.fLock;
        synchronized (object) {
            if (!this.fIsCanceled && !this.fIsCompleted) {
                this.fIsCancelRequested = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCancellationRequested() {
        Object object = this.fLock;
        synchronized (object) {
            return this.fIsCancelRequested;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCompletionOrCancellationRunnable(Runnable runnable) {
        Object object = this.fLock;
        synchronized (object) {
            this.fCompletionRunnables.add(runnable);
            if (this.fIsCompleted) {
                runnable.run();
                this.fCompletionRunnables.remove(runnable);
            }
        }
    }

    public void waitUntilCompletedOrCanceled() throws InterruptedException {
        if (SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("Do not wait for completion on the EDT");
        }
        this.fLatch.await();
    }

    public void markCompleted() {
        this.markFinished(false);
    }

    public void markSuccessfullyCanceled() {
        this.markFinished(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markFinished(boolean bl) {
        ArrayList<Runnable> arrayList = new ArrayList<Runnable>();
        Iterator iterator = this.fLock;
        synchronized (iterator) {
            if (!this.fIsCompleted && !this.fIsCanceled) {
                if (bl) {
                    this.fIsCanceled = true;
                } else {
                    this.fIsCompleted = true;
                }
                arrayList.addAll(this.fCompletionRunnables);
                this.fLatch.countDown();
                this.fCompletionRunnables.clear();
            }
        }
        for (Runnable runnable : arrayList) {
            SwingUtilities.invokeLater(runnable);
        }
    }
}

