/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlab.api.explorer;

import com.mathworks.matlab.api.explorer.ActionProvider;
import com.mathworks.matlab.api.explorer.AutoMounter;
import com.mathworks.matlab.api.explorer.FileInfoProvider;
import com.mathworks.matlab.api.explorer.NewFileTemplate;
import com.mathworks.util.Log;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public final class ExtensionRegistry {
    private final List<FileInfoProvider> fInfoProviders = new ArrayList<FileInfoProvider>();
    private final List<ActionProvider> fActionProviders = new ArrayList<ActionProvider>();
    private final List<NewFileTemplate> fNewFileTemplates = new ArrayList<NewFileTemplate>();
    private final List<AutoMounter> fAutoMounters = new ArrayList<AutoMounter>();

    public synchronized void clear() {
        this.fInfoProviders.clear();
        this.fActionProviders.clear();
        this.fNewFileTemplates.clear();
        this.fAutoMounters.clear();
    }

    public synchronized void addExtension(String string) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (clazz != null) {
            try {
                Object obj = clazz.newInstance();
                if (obj instanceof FileInfoProvider) {
                    this.addInfoProvider((FileInfoProvider)obj);
                }
                if (obj instanceof ActionProvider) {
                    this.addActionProvider((ActionProvider)obj);
                }
                if (obj instanceof AutoMounter) {
                    this.addAutoMounter((AutoMounter)obj);
                }
                if (obj instanceof NewFileTemplate) {
                    this.addNewFileTemplate((NewFileTemplate)obj);
                }
            }
            catch (Exception exception) {
                Log.logException((Exception)exception);
            }
        }
    }

    public synchronized void addAutoMounter(AutoMounter autoMounter) {
        this.fAutoMounters.add(autoMounter);
    }

    public synchronized List<AutoMounter> getAutoMounters() {
        return new ArrayList<AutoMounter>(this.fAutoMounters);
    }

    public synchronized List<ActionProvider> getActionProviders() {
        if (this.fActionProviders.isEmpty()) {
            throw new IllegalStateException("No action providers are registered");
        }
        return new Vector<ActionProvider>(this.fActionProviders);
    }

    public synchronized void addInfoProvider(FileInfoProvider fileInfoProvider) {
        this.fInfoProviders.add(fileInfoProvider);
    }

    public synchronized void addActionProvider(ActionProvider actionProvider) {
        this.fActionProviders.add(actionProvider);
    }

    public synchronized List<FileInfoProvider> getInfoProviders() {
        if (this.fInfoProviders.isEmpty()) {
            throw new IllegalStateException("No info providers are registered");
        }
        return new Vector<FileInfoProvider>(this.fInfoProviders);
    }

    public synchronized void addNewFileTemplate(NewFileTemplate newFileTemplate) {
        this.fNewFileTemplates.add(newFileTemplate);
    }

    public synchronized List<NewFileTemplate> getNewFileTemplates() {
        return new Vector<NewFileTemplate>(this.fNewFileTemplates);
    }
}

