/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.workunit;

import com.mathworks.resource_core.BaseMsgID;
import com.mathworks.resources.parallel.cluster.mjs;
import com.mathworks.resources.parallel.job;
import com.mathworks.toolbox.distcomp.auth.CryptoModule;
import com.mathworks.toolbox.distcomp.auth.credentials.NontransferableCredentials;
import com.mathworks.toolbox.distcomp.auth.credentials.TransferableCredentials;
import com.mathworks.toolbox.distcomp.auth.credentials.store.NoCredentialsException;
import com.mathworks.toolbox.distcomp.jobmanager.JobCounter;
import com.mathworks.toolbox.distcomp.jobmanager.JobRunner;
import com.mathworks.toolbox.distcomp.jobmanager.TaskDispatcher;
import com.mathworks.toolbox.distcomp.jobmanager.TaskDispatcherForJobs;
import com.mathworks.toolbox.distcomp.jobmanager.WorkUnitTimeoutChecker;
import com.mathworks.toolbox.distcomp.jobmanager.WorkerPool;
import com.mathworks.toolbox.distcomp.mjs.MJSException;
import com.mathworks.toolbox.distcomp.mjs.datastore.TransferableData;
import com.mathworks.toolbox.distcomp.storage.DataStorage;
import com.mathworks.toolbox.distcomp.storage.DataStorageException;
import com.mathworks.toolbox.distcomp.storage.JobStorage;
import com.mathworks.toolbox.distcomp.storage.LargeStorageItem;
import com.mathworks.toolbox.distcomp.storage.StorageException;
import com.mathworks.toolbox.distcomp.storage.WorkUnitNotFoundException;
import com.mathworks.toolbox.distcomp.storage.WorkUnitStorageException;
import com.mathworks.toolbox.distcomp.util.Pair;
import com.mathworks.toolbox.distcomp.util.TimeProvider;
import com.mathworks.toolbox.distcomp.worker.Worker;
import com.mathworks.toolbox.distcomp.worker.WorkerProxy;
import com.mathworks.toolbox.distcomp.workunit.AlreadyRerunningException;
import com.mathworks.toolbox.distcomp.workunit.Job;
import com.mathworks.toolbox.distcomp.workunit.JobInfo;
import com.mathworks.toolbox.distcomp.workunit.JobLargeDataAccessor;
import com.mathworks.toolbox.distcomp.workunit.JobStateException;
import com.mathworks.toolbox.distcomp.workunit.LargeDataAccessor;
import com.mathworks.toolbox.distcomp.workunit.NoRerunsLeftException;
import com.mathworks.toolbox.distcomp.workunit.PackageInfo;
import com.mathworks.toolbox.distcomp.workunit.TaskImpl;
import com.mathworks.toolbox.distcomp.workunit.TaskInfo;
import com.mathworks.toolbox.distcomp.workunit.TaskStateException;
import com.mathworks.toolbox.distcomp.workunit.WorkUnitImpl;
import com.mathworks.toolbox.distcomp.workunit.WorkUnitInfo;
import com.mathworks.toolbox.distcomp.workunit.WorkUnitStateException;
import com.mathworks.toolbox.distcomp.workunit.WorkerSortStrategy;
import com.mathworks.toolbox.distcomp.workunit.WorkerTaskInfo;
import com.mathworks.toolbox.distcomp.workunit.messages.CancelMessage;
import com.mathworks.toolbox.distcomp.workunit.messages.DelayedLocalizedCancelMessage;
import com.mathworks.toolbox.distcomp.workunit.messages.SimpleCancelMessage;
import com.mathworks.toolbox.parallel.pctutil.logging.DistcompLevel;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.logging.Level;
import net.jini.id.Uuid;

public class JobImpl
extends WorkUnitImpl
implements Job {
    private static final long serialVersionUID = -5893001293100798067L;
    public static final int INTERACTIVE_JOB = 1;
    public static final int BATCH_JOB = 0;
    private static final WorkerSortStrategy DEFAULT_DISTRIBUTED_STRATEGY = WorkerSortStrategy.NO_SORT;
    private WorkerSortStrategy fWorkerSortStrategy;
    private String fTag;
    private String fApiTag;
    protected int fMaxWorkers = Integer.MAX_VALUE;
    protected int fMinWorkers = 1;
    private boolean fRestartWorker;
    private boolean fAutoAttachFiles = true;
    private String[] fFileDepPathList;
    private String[] fAutoAttachedFileList;
    private String[] fPathList;
    private byte[] fProductList;
    private LargeStorageItem fFileDepDataItem = new LargeStorageItem(0);
    private LargeStorageItem fJobScopeDataItem = new LargeStorageItem(0);
    private LargeStorageItem fAttachedFilePathsItem = new LargeStorageItem(0);
    private long fSubmitTime = -1L;
    private Uuid[] fWorkersToUse;
    private transient int fJobMLType;
    protected int fMATLABExecutionMode;
    private long fCurrentTaskSequence = 0L;
    private TransferableCredentials fCredentials;
    private final LargeDataAccessor fLargeDataAccessor;
    private transient CryptoModule fTransferCryptoModule;
    private transient CryptoModule fStorageCryptoModule;
    private static final byte[] SALT = new byte[0];
    private transient DataStorage fLargeDataStorage;
    private transient JobStorage fStorage;
    private transient DataStorage fAppendableDataStorage;
    private transient JobCounter fJobCounter;
    private transient JobRunner fJobRunner;

    public JobImpl(int n, String string) {
        super(string);
        this.fName = this.getDefaultName();
        this.fJobMLType = n;
        this.setWorkerSortStrategy(DEFAULT_DISTRIBUTED_STRATEGY);
        this.fLargeDataAccessor = new JobLargeDataAccessor(this.getID());
    }

    public JobImpl(int n, String string, TimeProvider timeProvider) {
        super(string, timeProvider);
        this.fName = this.getDefaultName();
        this.fJobMLType = n;
        this.setWorkerSortStrategy(DEFAULT_DISTRIBUTED_STRATEGY);
        this.fLargeDataAccessor = new JobLargeDataAccessor(this.getID());
    }

    void setJobStorage(JobStorage jobStorage) {
        this.setWorkUnitStorage(jobStorage);
        this.fStorage = jobStorage;
    }

    protected JobStorage getJobStorage() {
        return this.fStorage;
    }

    void setLargeDataStorage(DataStorage dataStorage) {
        this.fLargeDataStorage = dataStorage;
    }

    void setAppendableDataStorage(DataStorage dataStorage) {
        this.fAppendableDataStorage = dataStorage;
    }

    void setTransferCryptoModule(CryptoModule cryptoModule) {
        this.fTransferCryptoModule = cryptoModule;
    }

    void setStorageCryptoModule(CryptoModule cryptoModule) {
        this.fStorageCryptoModule = cryptoModule;
    }

    void setJobCounter(JobCounter jobCounter) {
        this.fJobCounter = jobCounter;
    }

    void setJobRunner(JobRunner jobRunner) {
        this.fJobRunner = jobRunner;
    }

    public static JobImpl create(ObjectInputStream objectInputStream, long l, int n, int n2) throws IOException, ClassNotFoundException {
        JobImpl jobImpl = (JobImpl)objectInputStream.readObject();
        jobImpl.fNum = l;
        jobImpl.fState = n;
        jobImpl.fJobMLType = n2;
        return jobImpl;
    }

    @Override
    public String getTag() {
        return this.invokeWithReadLock(new WorkUnitImpl.LockedInvocationNoException<String>(){

            @Override
            public String invoke() {
                return JobImpl.this.fTag;
            }
        });
    }

    @Override
    public String getApiTag() {
        return this.invokeWithReadLock(new WorkUnitImpl.LockedInvocationNoException<String>(){

            @Override
            public String invoke() {
                return JobImpl.this.fApiTag;
            }
        });
    }

    @Override
    public Uuid[] getTasks() throws MJSException {
        return this.invokeWithReadLock(new WorkUnitImpl.LockedInvocation<Uuid[]>(){

            @Override
            public Uuid[] invoke() throws MJSException {
                return JobImpl.this.fStorage.readTasksByJobID(JobImpl.this.getID());
            }
        });
    }

    @Override
    public Uuid[][] getTasks(final int[] nArray) throws MJSException {
        return this.invokeWithReadLock(new WorkUnitImpl.LockedInvocation<Uuid[][]>(){

            @Override
            public Uuid[][] invoke() throws StorageException {
                return JobImpl.this.fStorage.readTasksByJobIDAndState(JobImpl.this.getID(), nArray);
            }
        });
    }

    @Override
    public boolean isRestartWorker() {
        return this.invokeWithReadLock(new WorkUnitImpl.LockedInvocationNoException<Boolean>(){

            @Override
            public Boolean invoke() {
                return JobImpl.this.fRestartWorker;
            }
        });
    }

    @Override
    public int getMaxWorkers() {
        return this.invokeWithReadLock(new WorkUnitImpl.LockedInvocationNoException<Integer>(){

            @Override
            public Integer invoke() {
                return JobImpl.this.fMaxWorkers;
            }
        });
    }

    @Override
    public int getMinWorkers() {
        return this.invokeWithReadLock(new WorkUnitImpl.LockedInvocationNoException<Integer>(){

            @Override
            public Integer invoke() {
                return JobImpl.this.fMinWorkers;
            }
        });
    }

    @Override
    public byte[] getProductList() {
        return this.invokeWithReadLock(new WorkUnitImpl.LockedInvocationNoException<byte[]>(){

            @Override
            public byte[] invoke() {
                return JobImpl.this.fProductList;
            }
        });
    }

    byte[] getFileDepData() throws MJSException {
        return this.invokeWithReadLock(new WorkUnitImpl.LockedInvocation<byte[]>(){

            @Override
            public byte[] invoke() throws MJSException {
                return JobImpl.this.fLargeDataAccessor.readLargeData(JobImpl.this.fFileDepDataItem, JobImpl.this.fLargeDataStorage);
            }
        });
    }

    public void getFileDepData(final OutputStream outputStream, final int n) throws MJSException {
        this.invokeWithReadLock(new WorkUnitImpl.LockedInvocation<Void>(){

            @Override
            public Void invoke() throws MJSException {
                JobImpl.this.fLargeDataAccessor.readLargeData(JobImpl.this.fFileDepDataItem, outputStream, JobImpl.this.fLargeDataStorage, n);
                return null;
            }
        });
    }

    public void getJobScopeData(final OutputStream outputStream, final int n) throws MJSException {
        this.invokeWithReadLock(new WorkUnitImpl.LockedInvocation<Void>(){

            @Override
            public Void invoke() throws MJSException {
                JobImpl.this.fLargeDataAccessor.readLargeData(JobImpl.this.fJobScopeDataItem, outputStream, JobImpl.this.fLargeDataStorage, n);
                return null;
            }
        });
    }

    public byte[] getJobScopeData() throws MJSException {
        return this.invokeWithReadLock(new WorkUnitImpl.LockedInvocation<byte[]>(){

            @Override
            public byte[] invoke() throws MJSException {
                return JobImpl.this.fLargeDataAccessor.readLargeData(JobImpl.this.fJobScopeDataItem, JobImpl.this.fLargeDataStorage);
            }
        });
    }

    public void getAttachedFilePaths(final OutputStream outputStream, final int n) throws MJSException {
        this.invokeWithReadLock(new WorkUnitImpl.LockedInvocation<Void>(){

            @Override
            public Void invoke() throws MJSException {
                JobImpl.this.fLargeDataAccessor.readLargeData(JobImpl.this.fAttachedFilePathsItem, outputStream, JobImpl.this.fLargeDataStorage, n);
                return null;
            }
        });
    }

    public byte[] getAttachedFilePaths() throws MJSException {
        return this.invokeWithReadLock(new WorkUnitImpl.LockedInvocation<byte[]>(){

            @Override
            public byte[] invoke() throws MJSException {
                return JobImpl.this.fLargeDataAccessor.readLargeData(JobImpl.this.fAttachedFilePathsItem, JobImpl.this.fLargeDataStorage);
            }
        });
    }

    public int getFileDepDataSize() {
        return this.invokeWithReadLock(new WorkUnitImpl.LockedInvocationNoException<Integer>(){

            @Override
            public Integer invoke() {
                return JobImpl.this.fFileDepDataItem.getNumBytes();
            }
        });
    }

    public int getJobScopeDataSize() {
        return this.invokeWithReadLock(new WorkUnitImpl.LockedInvocationNoException<Integer>(){

            @Override
            public Integer invoke() {
                return JobImpl.this.fJobScopeDataItem.getNumBytes();
            }
        });
    }

    public int getAttachedFilePathsSize() {
        return this.invokeWithReadLock(new WorkUnitImpl.LockedInvocationNoException<Integer>(){

            @Override
            public Integer invoke() {
                return JobImpl.this.fAttachedFilePathsItem.getNumBytes();
            }
        });
    }

    @Override
    public boolean getAutoAttachFiles() {
        return this.invokeWithReadLock(new WorkUnitImpl.LockedInvocationNoException<Boolean>(){

            @Override
            public Boolean invoke() {
                return JobImpl.this.fAutoAttachFiles;
            }
        });
    }

    @Override
    public String[] getFileDepPathList() {
        return this.invokeWithReadLock(new WorkUnitImpl.LockedInvocationNoException<String[]>(){

            @Override
            public String[] invoke() {
                return JobImpl.this.fFileDepPathList;
            }
        });
    }

    @Override
    public String[] getAutoAttachedFileList() {
        return this.invokeWithReadLock(new WorkUnitImpl.LockedInvocationNoException<String[]>(){

            @Override
            public String[] invoke() {
                return JobImpl.this.fAutoAttachedFileList;
            }
        });
    }

    @Override
    public String[] getPathList() {
        return this.invokeWithReadLock(new WorkUnitImpl.LockedInvocationNoException<String[]>(){

            @Override
            public String[] invoke() {
                return JobImpl.this.fPathList;
            }
        });
    }

    @Override
    public Date getSubmitTime() {
        return this.invokeWithReadLock(new WorkUnitImpl.LockedInvocationNoException<Date>(){

            @Override
            public Date invoke() {
                return JobImpl.this.fSubmitTime == -1L ? null : new Date(JobImpl.this.fSubmitTime);
            }
        });
    }

    @Override
    public JobInfo getWorkUnitInfo() throws MJSException {
        return this.invokeWithReadLock(new WorkUnitImpl.LockedInvocation<JobInfo>(){

            @Override
            public JobInfo invoke() throws MJSException {
                Uuid[] uuidArray = JobImpl.this.fStorage.readTasksByJobID(JobImpl.this.getID());
                return new JobInfo(JobImpl.this.fName, JobImpl.this.fTimeout, JobImpl.this.fTag, JobImpl.this.fNum, JobImpl.this.fState, JobImpl.this.fCreateTime, JobImpl.this.fSubmitTime, JobImpl.this.fStartTime, JobImpl.this.fFinishTime, JobImpl.this.getRunningDuration(), JobImpl.this.fMaxWorkers, JobImpl.this.fMinWorkers, JobImpl.this.fRestartWorker, JobImpl.this.fAutoAttachFiles, JobImpl.this.fAutoAttachedFileList, JobImpl.this.fFileDepPathList, JobImpl.this.fPathList, JobImpl.this.getWorkUnitUserName(), JobImpl.this.fProductList, uuidArray, JobImpl.this.fJobMLType, JobImpl.this.fMATLABExecutionMode, JobImpl.getListenerInfosFromMap(JobImpl.this.fListenerInfoToNumEvents));
            }
        });
    }

    @Override
    public int getMATLABExecutionMode() {
        return this.invokeWithReadLock(new WorkUnitImpl.LockedInvocationNoException<Integer>(){

            @Override
            public Integer invoke() {
                return JobImpl.this.fMATLABExecutionMode;
            }
        });
    }

    @Override
    public void setAuthorisedUsers(final String[] stringArray) throws MJSException {
        this.invokeWithWriteLock(new WorkUnitImpl.LockedInvocation<Void>(){

            @Override
            public Void invoke() throws MJSException {
                JobImpl.this.setWorkUnitAuthorisedUsers(stringArray);
                JobImpl.this.setAuthorisedUsersOfAllTasks(stringArray);
                return null;
            }
        });
    }

    private void setAuthorisedUsersOfAllTasks(String[] stringArray) throws MJSException {
        Uuid[] uuidArray;
        for (Uuid uuid : uuidArray = this.fStorage.readTasksByJobID(this.getID())) {
            try {
                TaskImpl taskImpl = (TaskImpl)this.fStorage.readWorkUnit(uuid);
                taskImpl.setAuthorisedUsers(stringArray);
            }
            catch (WorkUnitNotFoundException workUnitNotFoundException) {
                PackageInfo.LOGGER.log(DistcompLevel.ONE, "Unexpected problem while changing a job's authorized users: one of its tasks could not be retrieved from the database.");
            }
        }
    }

    @Override
    public void setUserName(final String string) throws MJSException {
        this.invokeWithWriteLock(new WorkUnitImpl.LockedInvocation<Void>(){

            @Override
            public Void invoke() throws MJSException {
                if (string != null) {
                    JobImpl.this.setWorkUnitUserName(string);
                    JobImpl.this.setUserNameOfAllTasks(string);
                }
                return null;
            }
        });
    }

    private void setUserNameOfAllTasks(String string) throws MJSException {
        Uuid[] uuidArray;
        for (Uuid uuid : uuidArray = this.fStorage.readTasksByJobID(this.getID())) {
            try {
                TaskImpl taskImpl = (TaskImpl)this.fStorage.readWorkUnit(uuid);
                taskImpl.setUserName(string);
            }
            catch (WorkUnitNotFoundException workUnitNotFoundException) {
                PackageInfo.LOGGER.log(DistcompLevel.ONE, "Unexpected problem while changing a job's user name: one of its tasks could not be retrieved from the database.");
            }
        }
    }

    @Override
    public void setTag(final String string) {
        this.invokeWithWriteLock(new WorkUnitImpl.LockedInvocationNoException<Void>(){

            @Override
            public Void invoke() {
                JobImpl.this.fTag = string;
                return null;
            }
        });
    }

    @Override
    public void setApiTag(final String string) {
        this.invokeWithWriteLock(new WorkUnitImpl.LockedInvocationNoException<Void>(){

            @Override
            public Void invoke() {
                JobImpl.this.fApiTag = string;
                return null;
            }
        });
    }

    @Override
    public void setRestartWorker(final boolean bl) throws MJSException {
        this.invokeWithWriteLock(new WorkUnitImpl.LockedInvocation<Void>(){

            @Override
            public Void invoke() throws MJSException {
                JobImpl.this.checkStateBeforeSet("RestartWorker");
                JobImpl.this.fRestartWorker = bl;
                return null;
            }
        });
    }

    @Override
    public void setMaxWorkers(final int n) throws MJSException {
        this.invokeWithWriteLock(new WorkUnitImpl.LockedInvocation<Void>(){

            @Override
            public Void invoke() throws MJSException {
                JobImpl.this.checkStateBeforeSet("MaximumNumberOfWorkers");
                JobImpl.this.fMaxWorkers = n;
                return null;
            }
        });
    }

    @Override
    public void setMinWorkers(final int n) throws MJSException {
        this.invokeWithWriteLock(new WorkUnitImpl.LockedInvocation<Void>(){

            @Override
            public Void invoke() throws MJSException {
                JobImpl.this.checkStateBeforeSet("MinimumNumberOfWorkers");
                JobImpl.this.fMinWorkers = n;
                return null;
            }
        });
    }

    @Override
    public void setProductList(final byte[] byArray) throws MJSException {
        this.invokeWithWriteLock(new WorkUnitImpl.LockedInvocation<Void>(){

            @Override
            public Void invoke() throws MJSException {
                JobImpl.this.checkStateBeforeSet("ProductList");
                JobImpl.access$402(JobImpl.this, byArray == null ? null : Arrays.copyOf(byArray, byArray.length));
                return null;
            }
        });
    }

    void setFileDepDataItem(final TransferableData transferableData) throws MJSException {
        this.invokeWithWriteLock(new WorkUnitImpl.LockedInvocation<Void>(){

            @Override
            public Void invoke() throws MJSException {
                JobImpl.this.checkStateBeforeSet("FileDependencies");
                JobImpl.this.fFileDepDataItem = JobImpl.this.fLargeDataAccessor.writeLargeData(JobImpl.this.fFileDepDataItem, transferableData, JobImpl.this.fLargeDataStorage);
                return null;
            }
        });
    }

    void setJobScopeDataItem(final TransferableData transferableData) throws MJSException {
        this.invokeWithWriteLock(new WorkUnitImpl.LockedInvocation<Void>(){

            @Override
            public Void invoke() throws MJSException {
                JobImpl.this.checkStateBeforeSet("JobData");
                JobImpl.this.fJobScopeDataItem = JobImpl.this.fLargeDataAccessor.writeLargeData(JobImpl.this.fJobScopeDataItem, transferableData, JobImpl.this.fLargeDataStorage);
                return null;
            }
        });
    }

    void setAttachedFilePathsItem(final TransferableData transferableData) throws MJSException {
        this.invokeWithWriteLock(new WorkUnitImpl.LockedInvocation<Void>(){

            @Override
            public Void invoke() throws MJSException {
                JobImpl.this.fAttachedFilePathsItem = JobImpl.this.fLargeDataAccessor.writeLargeData(JobImpl.this.fAttachedFilePathsItem, transferableData, JobImpl.this.fLargeDataStorage);
                return null;
            }
        });
    }

    @Override
    public void setAutoAttachFiles(final boolean bl) throws MJSException {
        this.invokeWithWriteLock(new WorkUnitImpl.LockedInvocation<Void>(){

            @Override
            public Void invoke() throws MJSException {
                JobImpl.this.checkStateBeforeSet("AutoAttachFiles");
                JobImpl.this.fAutoAttachFiles = bl;
                return null;
            }
        });
    }

    @Override
    public void setFileDepPathList(final String[] stringArray) throws MJSException {
        this.invokeWithWriteLock(new WorkUnitImpl.LockedInvocation<Void>(){

            @Override
            public Void invoke() throws MJSException {
                JobImpl.this.checkStateBeforeSet("FileDependenciesPathList");
                JobImpl.access$1102(JobImpl.this, stringArray == null ? null : Arrays.copyOf(stringArray, stringArray.length));
                return null;
            }
        });
    }

    @Override
    public void setAutoAttachedFileList(final String[] stringArray) throws MJSException {
        this.invokeWithWriteLock(new WorkUnitImpl.LockedInvocation<Void>(){

            @Override
            public Void invoke() throws MJSException {
                JobImpl.this.checkStateBeforeSet("AutoAttachedFileList");
                JobImpl.access$1202(JobImpl.this, stringArray == null ? null : Arrays.copyOf(stringArray, stringArray.length));
                return null;
            }
        });
    }

    @Override
    public void setPathList(final String[] stringArray) throws MJSException {
        this.invokeWithWriteLock(new WorkUnitImpl.LockedInvocation<Void>(){

            @Override
            public Void invoke() throws MJSException {
                JobImpl.this.checkStateBeforeSet("PathList");
                JobImpl.access$1302(JobImpl.this, stringArray == null ? null : Arrays.copyOf(stringArray, stringArray.length));
                return null;
            }
        });
    }

    @Override
    public void setWorkUnitInfoSmallItems(WorkUnitInfo workUnitInfo) throws MJSException {
        final JobInfo jobInfo = (JobInfo)workUnitInfo;
        this.invokeWithWriteLock(new WorkUnitImpl.LockedInvocation<Void>(){

            @Override
            public Void invoke() throws MJSException {
                JobImpl.this.fTag = jobInfo.getTag();
                JobImpl.this.checkStateBeforeSet("JobInfo");
                JobImpl.this.doSetName(jobInfo.getName());
                JobImpl.this.fTimeout = jobInfo.getTimeout();
                JobImpl.this.setWorkUnitUserName(jobInfo.getUserName());
                JobImpl.this.fMaxWorkers = jobInfo.getMaxWorkers();
                JobImpl.this.fMinWorkers = jobInfo.getMinWorkers();
                JobImpl.this.fRestartWorker = jobInfo.isRestartWorker();
                JobImpl.this.fMATLABExecutionMode = jobInfo.getMATLABExecutionMode();
                JobImpl.access$1102(JobImpl.this, jobInfo.getFileDepPathList());
                JobImpl.access$1202(JobImpl.this, jobInfo.getAutoAttachedFileList());
                JobImpl.access$402(JobImpl.this, jobInfo.getProductList());
                JobImpl.access$1302(JobImpl.this, jobInfo.getPathList());
                JobImpl.this.fListenerInfoToNumEvents = JobImpl.createListenerInfosMap(jobInfo.getListenerInfo());
                return null;
            }
        });
    }

    @Override
    public void setWorkUnitInfo(WorkUnitInfo workUnitInfo) throws MJSException {
        final JobInfo jobInfo = (JobInfo)workUnitInfo;
        this.invokeWithWriteLock(new WorkUnitImpl.LockedInvocation<Void>(){

            @Override
            public Void invoke() throws MJSException {
                JobImpl.this.fTag = jobInfo.getTag();
                JobImpl.this.checkStateBeforeSet("JobInfo");
                JobImpl.this.doSetName(jobInfo.getName());
                JobImpl.this.fTimeout = jobInfo.getTimeout();
                JobImpl.this.setWorkUnitUserName(jobInfo.getUserName());
                JobImpl.this.fMaxWorkers = jobInfo.getMaxWorkers();
                JobImpl.this.fMinWorkers = jobInfo.getMinWorkers();
                JobImpl.this.fRestartWorker = jobInfo.isRestartWorker();
                JobImpl.this.fMATLABExecutionMode = jobInfo.getMATLABExecutionMode();
                JobImpl.access$1102(JobImpl.this, jobInfo.getFileDepPathList());
                JobImpl.access$1202(JobImpl.this, jobInfo.getAutoAttachedFileList());
                JobImpl.access$402(JobImpl.this, jobInfo.getProductList());
                JobImpl.access$1302(JobImpl.this, jobInfo.getPathList());
                JobImpl.this.fFileDepDataItem = JobImpl.this.fLargeDataAccessor.writeLargeData(JobImpl.this.fFileDepDataItem, (TransferableData)jobInfo.getFileDepData(), JobImpl.this.fLargeDataStorage);
                JobImpl.this.fJobScopeDataItem = JobImpl.this.fLargeDataAccessor.writeLargeData(JobImpl.this.fJobScopeDataItem, (TransferableData)jobInfo.getJobScopeData(), JobImpl.this.fLargeDataStorage);
                JobImpl.this.fAttachedFilePathsItem = JobImpl.this.fLargeDataAccessor.writeLargeData(JobImpl.this.fAttachedFilePathsItem, (TransferableData)jobInfo.getAttachedFilePaths(), JobImpl.this.fLargeDataStorage);
                JobImpl.this.fListenerInfoToNumEvents = JobImpl.createListenerInfosMap(jobInfo.getListenerInfo());
                try {
                    NontransferableCredentials nontransferableCredentials = jobInfo.getCredentials(JobImpl.this.fTransferCryptoModule);
                    PackageInfo.LOGGER.log(Level.FINE, "About to encrypt credentials for storage in database: " + nontransferableCredentials.toString());
                    JobImpl.this.fCredentials = nontransferableCredentials.prepare(true, SALT, JobImpl.this.fStorageCryptoModule.getEncryptor());
                }
                catch (NoCredentialsException noCredentialsException) {
                    // empty catch block
                }
                return null;
            }
        });
    }

    @Override
    public Uuid createTask(TaskInfo taskInfo) throws MJSException {
        Uuid uuid = this.createTaskAndSetInfo(taskInfo).getFirst();
        this.notifyJobRunnerOfNewTask();
        return uuid;
    }

    @Override
    public void submit(final Uuid[] uuidArray) throws MJSException {
        this.invokeWithWriteLock(new WorkUnitImpl.LockedInvocationNoNotification<Void>(){

            @Override
            public Void invoke() throws MJSException {
                if (JobImpl.this.fState != 0) {
                    throw new IncorrectJobStateForSubmitException();
                }
                JobImpl.access$2902(JobImpl.this, uuidArray == null ? null : Arrays.copyOf(uuidArray, uuidArray.length));
                JobImpl.this.addToJobQueue();
                return null;
            }
        });
        this.fJobRunner.runAvailableTasks();
    }

    @Override
    public void setMATLABExecutionMode(final int n) throws MJSException {
        this.invokeWithWriteLock(new WorkUnitImpl.LockedInvocation<Void>(){

            @Override
            public Void invoke() throws MJSException {
                JobImpl.this.checkStateBeforeSet("Interactive");
                JobImpl.this.fMATLABExecutionMode = n;
                return null;
            }
        });
    }

    @Override
    public void cancel(final CancelMessage cancelMessage) throws MJSException {
        this.invokeWithWriteLock(new WorkUnitImpl.LockedInvocationNoNotification<Void>(){

            @Override
            public Void invoke() throws MJSException {
                if (JobImpl.this.fState != 3) {
                    Uuid[] uuidArray;
                    PackageInfo.LOGGER.log(DistcompLevel.ONE, JobImpl.this.workUnitTypeForPrinting() + " " + JobImpl.this.fNum + " cancellation has begun");
                    try {
                        uuidArray = JobImpl.this.fStorage.readTasksByJobIDAndBeforeState(JobImpl.this.getID(), 3);
                    }
                    catch (WorkUnitStorageException workUnitStorageException) {
                        PackageInfo.LOGGER.log(Level.SEVERE, "Job cancellation failed due to a storage error.", workUnitStorageException);
                        JobImpl.this.finishJob();
                        throw workUnitStorageException;
                    }
                    for (Uuid uuid : uuidArray) {
                        try {
                            TaskImpl taskImpl = (TaskImpl)JobImpl.this.fStorage.readWorkUnit(uuid);
                            boolean bl = true;
                            taskImpl.cancelWithoutNotifyingJob(cancelMessage, bl);
                        }
                        catch (WorkUnitNotFoundException workUnitNotFoundException) {
                            // empty catch block
                        }
                    }
                    JobImpl.this.finishJob();
                }
                return null;
            }
        });
    }

    @Override
    public void destroy() throws MJSException {
        this.invokeWithWriteLock(new WorkUnitImpl.LockedInvocationNoStorageUpdate<Void>(){

            @Override
            public Void invoke() throws MJSException {
                JobImpl.this.cancel(new JobDestroyedMessage(JobImpl.this.fNum));
                try {
                    JobImpl.this.fLargeDataStorage.removeDataForJobAndTasks(JobImpl.this.getID());
                }
                catch (DataStorageException dataStorageException) {
                    PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Failed to delete large data for job: " + JobImpl.this.fNum, dataStorageException);
                }
                try {
                    JobImpl.this.fAppendableDataStorage.removeDataForJobAndTasks(JobImpl.this.getID());
                }
                catch (DataStorageException dataStorageException) {
                    PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Failed to delete appendable data for job: " + JobImpl.this.fNum, dataStorageException);
                }
                JobImpl.this.fStorage.removeJob(JobImpl.this.getID());
                PackageInfo.LOGGER.log(DistcompLevel.ONE, JobImpl.this.workUnitTypeForPrinting() + " " + JobImpl.this.fNum + " has been destroyed");
                return null;
            }
        });
    }

    public Worker[] checkConstraintsAndRunJob(final Worker[][] workerArray) throws MJSException {
        return this.invokeWithWriteLock(new WorkUnitImpl.LockedInvocation<Worker[]>(){

            @Override
            public Worker[] invoke() throws MJSException {
                if (JobImpl.this.fState != 1 && JobImpl.this.fState != 2) {
                    throw new IncorrectStateToRunJobException();
                }
                if (JobImpl.this.fMinWorkers > JobImpl.this.fMaxWorkers) {
                    JobImpl.this.cancelJobBeforeRunning(new MaxLessThanMinMessage(JobImpl.this.fMinWorkers, JobImpl.this.fMaxWorkers));
                }
                if (JobImpl.this.fMaxWorkers == 0) {
                    JobImpl.this.cancelJobBeforeRunning(new MaxWorkersNilMessage());
                }
                JobImpl.this.checkNumTasksBeforeRunning();
                Worker[][] workerArray3 = JobImpl.this.selectFromWorkersToUse(workerArray);
                JobImpl.this.checkTotalNumberOfWorkers(workerArray3);
                Worker[] workerArray2 = JobImpl.this.chooseIdleWorkersForQueuedJob(workerArray3);
                if (JobImpl.this.fState == 1 && workerArray2 != null) {
                    JobImpl.this.removeFromJobQueue();
                    JobImpl.this.startJobRunning();
                }
                return workerArray2;
            }
        });
    }

    public Worker[] checkConstraintsOnRunningJob(final Worker[][] workerArray) {
        return this.invokeWithWriteLock(new WorkUnitImpl.LockedInvocationNoException<Worker[]>(){

            @Override
            public Worker[] invoke() {
                Worker[][] workerArray2 = JobImpl.this.selectFromWorkersToUse(workerArray);
                return JobImpl.this.chooseIdleWorkersForRunningJob(workerArray2);
            }
        });
    }

    public int getJobMLType() {
        return this.invokeWithReadLock(new WorkUnitImpl.LockedInvocationNoException<Integer>(){

            @Override
            public Integer invoke() {
                return JobImpl.this.fJobMLType;
            }
        });
    }

    @Override
    public String workUnitTypeForPrinting() {
        return "job";
    }

    public TaskDispatcher getTaskDispatcherToUse() {
        return TaskDispatcherForJobs.instance();
    }

    protected void taskCompleted(TaskImpl taskImpl) throws MJSException {
        this.invokeWithWriteLock(new WorkUnitImpl.LockedInvocationNoStorageUpdate<Void>(){

            @Override
            public Void invoke() throws MJSException {
                int n;
                if (JobImpl.this.fState == 2 && (n = JobImpl.this.fStorage.countTasksByJobIDAndBeforeState(JobImpl.this.getID(), 3)) == 0) {
                    JobImpl.this.finishJobAndUpdateStorage();
                }
                return null;
            }
        });
    }

    protected Pair<Uuid, Long> createTaskAndSetInfo(final TaskInfo taskInfo) throws MJSException {
        return this.invokeWithWriteLock(new WorkUnitImpl.LockedInvocation<Pair<Uuid, Long>>(){

            @Override
            public Pair<Uuid, Long> invoke() throws MJSException {
                if (JobImpl.this.fState == 3) {
                    throw new IncorrectStateToCreateTaskException();
                }
                Uuid uuid = JobImpl.this.createTaskInStorage();
                JobImpl.this.setInfoOfCreatedTask(uuid, taskInfo);
                JobImpl.this.setUsersOfCreatedTask(uuid);
                WorkUnitImpl workUnitImpl = JobImpl.this.fStorage.readWorkUnit(uuid);
                PackageInfo.LOGGER.log(DistcompLevel.TWO, "task " + workUnitImpl.getNum() + " of " + JobImpl.this.workUnitTypeForPrinting() + " " + JobImpl.this.fNum + " has been created");
                Pair<Uuid, Long> pair = new Pair<Uuid, Long>(uuid, workUnitImpl.getNum());
                return pair;
            }
        });
    }

    protected void checkNumTasksBeforeRunning() throws MJSException {
        int n = this.fStorage.countTasksByJobIDAndState(this.getID(), 0);
        if (n < 1) {
            PackageInfo.LOGGER.log(Level.SEVERE, "Job " + this.getNum() + " has no pending tasks, jobid: " + this.getID());
            this.cancelJobBeforeRunning(new NoTasksMessage());
        }
    }

    public int getMinimumTasksToDispatch() throws MJSException {
        int n = this.fStorage.countTasksByJobID(this.getID());
        return Math.min(this.getMinWorkers(), n);
    }

    protected void cancelJobBeforeRunning(CancelMessage cancelMessage) throws MJSException {
        this.cancel(cancelMessage);
        throw new CancelledBeforeRunningException(cancelMessage);
    }

    protected void checkTotalNumberOfWorkers(Worker[][] workerArray) throws MJSException {
        int n = workerArray[0].length;
        int n2 = workerArray[1].length;
        int n3 = n + n2;
        if (this.fMinWorkers > n3) {
            this.cancelJobBeforeRunning(new NotEnoughWorkersMessage(this.fMinWorkers, this.fMaxWorkers));
        }
    }

    protected Worker[] chooseIdleWorkersForQueuedJob(Worker[][] workerArray) {
        Worker[] workerArray2 = workerArray[0];
        if (workerArray2.length < this.fMinWorkers) {
            return null;
        }
        return workerArray2;
    }

    protected Worker[] chooseIdleWorkersForRunningJob(Worker[][] workerArray) {
        Worker[] workerArray2 = workerArray[0];
        if (workerArray2.length == 0) {
            return null;
        }
        return workerArray2;
    }

    protected void setWorkerSortStrategy(WorkerSortStrategy workerSortStrategy) {
        this.fWorkerSortStrategy = workerSortStrategy;
    }

    public void sortWorkers(Worker[] workerArray) {
        this.fWorkerSortStrategy.sort(workerArray);
    }

    @Override
    protected String getDefaultName() {
        return "Job" + this.fNum;
    }

    private void setInfoOfCreatedTask(Uuid uuid, TaskInfo taskInfo) throws MJSException {
        try {
            TaskImpl taskImpl = (TaskImpl)this.fStorage.readWorkUnit(uuid);
            taskImpl.setWorkUnitInfo(taskInfo);
        }
        catch (WorkUnitNotFoundException workUnitNotFoundException) {
            throw new TaskDestroyedException(workUnitNotFoundException);
        }
    }

    private void setUsersOfCreatedTask(Uuid uuid) throws MJSException {
        TaskImpl taskImpl = (TaskImpl)this.fStorage.readWorkUnit(uuid);
        taskImpl.setAuthorisedUsers(this.getAuthorisedUsers());
    }

    private Worker[][] selectFromWorkersToUse(Worker[][] workerArray) {
        Worker[][] workerArray2;
        if (this.fWorkersToUse != null && this.fWorkersToUse.length > 0) {
            workerArray2 = new Worker[2][];
            Worker[] workerArray3 = workerArray[0];
            Worker[] workerArray4 = workerArray[1];
            workerArray2[0] = this.selectFromWorkersToUse(workerArray3);
            workerArray2[1] = this.selectFromWorkersToUse(workerArray4);
        } else {
            workerArray2 = workerArray;
        }
        return workerArray2;
    }

    private Worker[] selectFromWorkersToUse(Worker[] workerArray) {
        ArrayList<Uuid> arrayList = new ArrayList<Uuid>();
        arrayList.addAll(Arrays.asList(this.fWorkersToUse));
        ArrayList<WorkerProxy> arrayList2 = new ArrayList<WorkerProxy>();
        for (Worker worker : workerArray) {
            WorkerProxy workerProxy = (WorkerProxy)worker;
            if (!arrayList.contains(workerProxy.getID())) continue;
            arrayList2.add(workerProxy);
        }
        return arrayList2.toArray(new Worker[arrayList2.size()]);
    }

    private void addToJobQueue() throws StorageException {
        this.switchToQueuedState();
        this.fStorage.addToQueue(this.getID());
        this.fJobCounter.incQueuedJobs();
    }

    private void removeFromJobQueue() throws StorageException {
        this.fStorage.removeFromQueue(this.getID());
        this.fJobCounter.decQueuedJobs();
    }

    private void startJobRunning() {
        this.switchToRunningState();
        WorkUnitTimeoutChecker.instance().addWorkUnit(this.getID(), this.fTimeout);
        this.fJobCounter.incRunningJobs();
        PackageInfo.LOGGER.log(DistcompLevel.ONE, this.workUnitTypeForPrinting() + " " + this.fNum + " has started running");
    }

    private void stopJobRunning() {
        WorkUnitTimeoutChecker.instance().removeWorkUnit(this.getID());
        this.fJobCounter.decRunningJobs();
    }

    private void finishJobAndUpdateStorage() throws MJSException {
        this.invokeWithWriteLock(new WorkUnitImpl.LockedInvocation<Void>(){

            @Override
            public Void invoke() throws StorageException {
                JobImpl.this.finishJob();
                return null;
            }
        });
    }

    private void finishJob() throws StorageException {
        if (this.fState == 1) {
            this.removeFromJobQueue();
        }
        if (this.fState == 2) {
            this.stopJobRunning();
        }
        this.switchToFinishedState();
        PackageInfo.LOGGER.log(DistcompLevel.ONE, this.workUnitTypeForPrinting() + " " + this.fNum + " has finished");
    }

    private void switchToQueuedState() {
        this.fState = 1;
        this.fSubmitTime = System.currentTimeMillis();
        this.recordEvent(1L);
        PackageInfo.LOGGER.log(DistcompLevel.ONE, this.workUnitTypeForPrinting() + " " + this.fNum + " has been queued");
    }

    protected void notifyJobRunnerOfNewTask() {
        int n = this.getState();
        if (n == 2) {
            this.fJobRunner.runAvailableTasks();
        }
    }

    private Uuid createTaskInStorage() throws StorageException {
        return this.fStorage.putTask(new TaskImpl(this.getID(), this.nextTaskSequenceNumber(), this.getWorkUnitUserName()));
    }

    @Override
    public void rerunOrCancel(CancelMessage cancelMessage) throws MJSException {
        PackageInfo.LOGGER.log(DistcompLevel.FOUR, "rerun: " + this.workUnitTypeForPrinting() + " " + this.fNum + " is being rerun or cancelled");
        try {
            Collection<WorkerTaskInfo> collection = this.rerunJob(cancelMessage);
            for (WorkerTaskInfo workerTaskInfo : collection) {
                WorkerPool.instance().removeTaskFromWorker(workerTaskInfo);
            }
        }
        catch (AlreadyRerunningException alreadyRerunningException) {
        }
        catch (NoRerunsLeftException noRerunsLeftException) {
            this.cancel(new NoRerunsLeftMessage(noRerunsLeftException, cancelMessage));
        }
        catch (WorkUnitStateException workUnitStateException) {
            this.cancel(new IncorrectStateMessage(workUnitStateException, cancelMessage));
        }
        catch (MJSException mJSException) {
            this.cancel(new CancelFailedMessage(mJSException, cancelMessage));
        }
    }

    protected Collection<WorkerTaskInfo> rerunTask(TaskImpl taskImpl, CancelMessage cancelMessage) throws MJSException {
        return this.rerunTask(taskImpl, cancelMessage, true);
    }

    private Collection<WorkerTaskInfo> rerunTask(final TaskImpl taskImpl, final CancelMessage cancelMessage, final boolean bl) throws MJSException {
        return this.invokeWithWriteLock(new WorkUnitImpl.LockedInvocation<Collection<WorkerTaskInfo>>(){

            @Override
            public Collection<WorkerTaskInfo> invoke() throws MJSException {
                taskImpl.checkTaskCanRerun();
                if (bl && JobImpl.this.fState != 2) {
                    throw new WorkUnitNotRunningException(JobImpl.this.workUnitTypeForPrinting());
                }
                ArrayList<WorkerTaskInfo> arrayList = new ArrayList<WorkerTaskInfo>();
                arrayList.add(taskImpl.getWorkerTaskInfo());
                if (taskImpl.getState() == 2) {
                    taskImpl.setErrorIdentifier("distcomp:task:Cancelled");
                    taskImpl.setErrorMessage(cancelMessage.getLocalizedMessage());
                }
                taskImpl.prepareToRerun();
                return arrayList;
            }
        });
    }

    protected final Collection<WorkerTaskInfo> rerunJob(final CancelMessage cancelMessage) throws MJSException {
        return this.invokeWithWriteLock(new WorkUnitImpl.LockedInvocation<Collection<WorkerTaskInfo>>(){

            @Override
            public Collection<WorkerTaskInfo> invoke() throws MJSException {
                Collection collection;
                JobImpl.this.checkJobCanRerun();
                JobImpl.this.switchJobFromRunningToPending();
                try {
                    collection = JobImpl.this.prepareAllTasksToRerun(cancelMessage);
                }
                catch (WorkUnitStateException workUnitStateException) {
                    JobImpl.this.cancel(new JobRerunFailedMessage(workUnitStateException));
                    return new ArrayList<WorkerTaskInfo>();
                }
                JobImpl.this.prepareToRerun();
                return collection;
            }
        });
    }

    protected void checkJobCanRerun() throws WorkUnitStateException, StorageException {
        if (this.fState <= 1) {
            throw new AlreadyRerunningException((BaseMsgID)new job.JobAlreadyRerunning());
        }
        if (this.fState != 2) {
            throw new WorkUnitNotRunningException(this.workUnitTypeForPrinting());
        }
    }

    private void switchJobFromRunningToPending() {
        this.invokeWithWriteLock(new WorkUnitImpl.LockedInvocationNoException<Void>(){

            @Override
            public Void invoke() {
                JobImpl.this.stopJobRunning();
                JobImpl.this.setWorkUnitToPending();
                return null;
            }
        });
    }

    private Collection<WorkerTaskInfo> prepareAllTasksToRerun(CancelMessage cancelMessage) throws MJSException {
        ArrayList<WorkerTaskInfo> arrayList = new ArrayList<WorkerTaskInfo>();
        for (Uuid uuid : this.getTasks()) {
            TaskImpl taskImpl;
            try {
                taskImpl = (TaskImpl)this.fStorage.readWorkUnit(uuid);
            }
            catch (WorkUnitNotFoundException workUnitNotFoundException) {
                PackageInfo.LOGGER.log(DistcompLevel.FOUR, "rerun: a task of the rerunning " + this.workUnitTypeForPrinting() + " has been " + "destroyed (thus, it will not rerun)");
                continue;
            }
            arrayList.addAll(this.prepareTaskToRerun(taskImpl, cancelMessage));
        }
        return arrayList;
    }

    protected Collection<WorkerTaskInfo> prepareTaskToRerun(TaskImpl taskImpl, CancelMessage cancelMessage) throws MJSException {
        try {
            return this.rerunTask(taskImpl, cancelMessage, false);
        }
        catch (AlreadyRerunningException alreadyRerunningException) {
            PackageInfo.LOGGER.log(DistcompLevel.FOUR, "rerun: task " + taskImpl.getNum() + " is already being rerun");
            return new ArrayList<WorkerTaskInfo>();
        }
    }

    protected void prepareToRerun() throws MJSException {
        this.addToJobQueueForRerun();
        PackageInfo.LOGGER.log(DistcompLevel.FOUR, "rerun: " + this.workUnitTypeForPrinting() + " " + this.fNum + " has been successfully prepared to rerun");
    }

    private void addToJobQueueForRerun() throws MJSException {
        this.switchToQueuedStateForRerun();
        this.fStorage.addToQueue(this.getID());
        this.fJobCounter.incQueuedJobs();
    }

    private void switchToQueuedStateForRerun() {
        this.fState = 1;
        this.fSubmitTime = System.currentTimeMillis();
        PackageInfo.LOGGER.log(DistcompLevel.ONE, this.workUnitTypeForPrinting() + " " + this.fNum + " has been re-queued");
    }

    protected void resetTaskSequenceNum() throws MJSException {
        this.invokeWithWriteLock(new WorkUnitImpl.LockedInvocation<Void>(){

            @Override
            public Void invoke() throws StorageException {
                JobImpl.this.fCurrentTaskSequence = 1L;
                return null;
            }
        });
    }

    protected long nextTaskSequenceNumber() {
        return this.invokeWithWriteLock(new WorkUnitImpl.LockedInvocationNoException<Long>(){

            @Override
            public Long invoke() {
                return ++JobImpl.this.fCurrentTaskSequence;
            }
        });
    }

    public NontransferableCredentials getCredentials() throws MJSException {
        return this.invokeWithReadLock(new WorkUnitImpl.LockedInvocation<NontransferableCredentials>(){

            @Override
            public NontransferableCredentials invoke() throws MJSException {
                if (JobImpl.this.fCredentials != null) {
                    return JobImpl.this.fCredentials.unpack(SALT, JobImpl.this.fStorageCryptoModule.getDecryptor());
                }
                return null;
            }
        });
    }

    @Override
    public String toString() {
        return this.fName + " (" + this.getDefaultName() + "): " + this.getID();
    }

    static /* synthetic */ byte[] access$402(JobImpl jobImpl, byte[] byArray) {
        jobImpl.fProductList = byArray;
        return byArray;
    }

    static /* synthetic */ String[] access$1102(JobImpl jobImpl, String[] stringArray) {
        jobImpl.fFileDepPathList = stringArray;
        return stringArray;
    }

    static /* synthetic */ String[] access$1202(JobImpl jobImpl, String[] stringArray) {
        jobImpl.fAutoAttachedFileList = stringArray;
        return stringArray;
    }

    static /* synthetic */ String[] access$1302(JobImpl jobImpl, String[] stringArray) {
        jobImpl.fPathList = stringArray;
        return stringArray;
    }

    static /* synthetic */ Uuid[] access$2902(JobImpl jobImpl, Uuid[] uuidArray) {
        jobImpl.fWorkersToUse = uuidArray;
        return uuidArray;
    }

    private static class JobRerunFailedMessage
    extends DelayedLocalizedCancelMessage {
        JobRerunFailedMessage(WorkUnitStateException workUnitStateException) {
            super((BaseMsgID)new mjs.JobRerunFailed(workUnitStateException.getMessage()), (BaseMsgID)new mjs.JobRerunFailed(workUnitStateException.getLocalizedMessage()));
        }
    }

    private static class WorkUnitNotRunningException
    extends WorkUnitStateException {
        private final BaseMsgID fMessageID;

        WorkUnitNotRunningException(String string) {
            this.fMessageID = new mjs.WorkUnitNotRunning(string);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fMessageID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fMessageID;
        }
    }

    private static class CancelFailedMessage
    extends DelayedLocalizedCancelMessage {
        CancelFailedMessage(MJSException mJSException, CancelMessage cancelMessage) {
            super((BaseMsgID)new mjs.JobCancelFailed(mJSException.getMessage(), cancelMessage.getMessage()), (BaseMsgID)new mjs.JobCancelFailed(mJSException.getLocalizedMessage(), cancelMessage.getLocalizedMessage()));
        }
    }

    private static class IncorrectStateMessage
    extends DelayedLocalizedCancelMessage {
        IncorrectStateMessage(WorkUnitStateException workUnitStateException, CancelMessage cancelMessage) {
            super((BaseMsgID)new mjs.JobIncorrectStateToRerun(workUnitStateException.getMessage(), cancelMessage.getMessage()), (BaseMsgID)new mjs.JobIncorrectStateToRerun(workUnitStateException.getLocalizedMessage(), cancelMessage.getLocalizedMessage()));
        }
    }

    private static class NoRerunsLeftMessage
    extends DelayedLocalizedCancelMessage {
        NoRerunsLeftMessage(NoRerunsLeftException noRerunsLeftException, CancelMessage cancelMessage) {
            super((BaseMsgID)new mjs.JobNoRerunsLeft(noRerunsLeftException.getMessage(), cancelMessage.getMessage()), (BaseMsgID)new mjs.JobNoRerunsLeft(noRerunsLeftException.getLocalizedMessage(), cancelMessage.getLocalizedMessage()));
        }
    }

    private static class TaskDestroyedException
    extends TaskStateException {
        TaskDestroyedException(WorkUnitNotFoundException workUnitNotFoundException) {
            super(workUnitNotFoundException);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return new mjs.TaskDestroyed();
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return new mjs.TaskDestroyed();
        }
    }

    private static class NotEnoughWorkersMessage
    extends SimpleCancelMessage {
        NotEnoughWorkersMessage(int n, int n2) {
            super((BaseMsgID)new mjs.NotEnoughWorkers(Integer.toString(n), Integer.toString(n2)));
        }
    }

    private static class CancelledBeforeRunningException
    extends JobStateException {
        private final CancelMessage fCancelMessage;

        CancelledBeforeRunningException(CancelMessage cancelMessage) {
            this.fCancelMessage = cancelMessage;
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return new job.CancelledBeforeRunning(this.fCancelMessage.getMessage());
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return new job.CancelledBeforeRunning(this.fCancelMessage.getLocalizedMessage());
        }
    }

    private static class NoTasksMessage
    extends SimpleCancelMessage {
        NoTasksMessage() {
            super((BaseMsgID)new mjs.NoTasks());
        }
    }

    private static class IncorrectStateToCreateTaskException
    extends JobStateException {
        private IncorrectStateToCreateTaskException() {
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return new mjs.IncorrectStateToCreateTask();
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return new mjs.IncorrectStateToCreateTask();
        }
    }

    private static class MaxWorkersNilMessage
    extends SimpleCancelMessage {
        MaxWorkersNilMessage() {
            super((BaseMsgID)new mjs.MaxWorkersNil());
        }
    }

    private static class MaxLessThanMinMessage
    extends SimpleCancelMessage {
        MaxLessThanMinMessage(int n, int n2) {
            super((BaseMsgID)new mjs.MaxLessThanMin(Integer.toString(n), Integer.toString(n2)));
        }
    }

    private static class IncorrectStateToRunJobException
    extends JobStateException {
        private IncorrectStateToRunJobException() {
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return new job.IncorrectStateToRunJob();
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return new job.IncorrectStateToRunJob();
        }
    }

    private static class JobDestroyedMessage
    extends SimpleCancelMessage {
        JobDestroyedMessage(long l) {
            super((BaseMsgID)new mjs.JobDestroyed(Long.toString(l)));
        }
    }

    private static class IncorrectJobStateForSubmitException
    extends JobStateException {
        private IncorrectJobStateForSubmitException() {
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return new job.IncorrectJobStateForSubmit();
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return new job.IncorrectJobStateForSubmit();
        }
    }
}

