/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.worker.sessiontracking;

import com.mathworks.toolbox.distcomp.worker.sessiontracking.LifecycleEventType;
import com.mathworks.toolbox.distcomp.worker.sessiontracking.LifecycleReporter;
import com.mathworks.toolbox.distcomp.worker.sessiontracking.Log;
import com.mathworks.toolbox.distcomp.worker.sessiontracking.Trackable;
import com.mathworks.toolbox.distcomp.worker.sessiontracking.WorkerLifecycleEventTypes;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class LoggingLifecycleReporter
implements LifecycleReporter {
    private final Logger fLogger;
    private final Level fStartStopLevel;
    private final Level fHeartbeatLevel;

    public LoggingLifecycleReporter(Logger logger, Level level, Level level2) {
        this.fLogger = logger;
        this.fStartStopLevel = level;
        this.fHeartbeatLevel = level2;
    }

    public LoggingLifecycleReporter(Logger logger) {
        this.fLogger = logger;
        this.fStartStopLevel = Level.FINE;
        this.fHeartbeatLevel = Level.FINEST;
    }

    public LoggingLifecycleReporter() {
        this.fLogger = Log.LOGGER;
        this.fStartStopLevel = Level.FINE;
        this.fHeartbeatLevel = Level.FINEST;
    }

    @Override
    public void reportLifecycleEvent(Trackable trackable, LifecycleEventType lifecycleEventType) {
        if (lifecycleEventType instanceof WorkerLifecycleEventTypes) {
            String string = String.format("%s_%s\n\tAbout %s", trackable.getType(), lifecycleEventType, trackable);
            this.reportEvent((WorkerLifecycleEventTypes)lifecycleEventType, string);
        }
    }

    @Override
    public void reportLifecycleEvent(Trackable trackable, Trackable trackable2, LifecycleEventType lifecycleEventType) {
        if (lifecycleEventType instanceof WorkerLifecycleEventTypes) {
            String string = String.format("%s_%s\n\tReported by %s\n\tAbout %s", trackable2.getType(), lifecycleEventType, trackable, trackable2);
            this.reportEvent((WorkerLifecycleEventTypes)lifecycleEventType, string);
        }
    }

    private void reportEvent(WorkerLifecycleEventTypes workerLifecycleEventTypes, String string) {
        switch (workerLifecycleEventTypes) {
            case STARTED: {
                this.fLogger.log(this.fStartStopLevel, string);
                break;
            }
            case RUNNING: {
                this.fLogger.log(this.fHeartbeatLevel, string);
                break;
            }
            case STOPPED: {
                this.fLogger.log(this.fStartStopLevel, string);
                break;
            }
        }
    }
}

