/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.worker.sessiontracking;

import com.mathworks.toolbox.distcomp.worker.sessiontracking.Trackable;
import com.mathworks.toolbox.distcomp.worker.sessiontracking.TrackableType;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public abstract class AbstractTrackable
implements Trackable {
    private final TrackableType fType;
    private final UUID fUUID;
    private final Map<String, String> fProperties = new HashMap<String, String>();

    protected AbstractTrackable(TrackableType trackableType, UUID uUID) {
        this.fType = trackableType;
        this.fUUID = uUID;
    }

    @Override
    public UUID getUUID() {
        return this.fUUID;
    }

    @Override
    public Map<String, String> getProperties() {
        return this.fProperties;
    }

    @Override
    public TrackableType getType() {
        return this.fType;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        AbstractTrackable abstractTrackable = (AbstractTrackable)object;
        if (this.fType != abstractTrackable.fType) {
            return false;
        }
        if (!this.fUUID.equals(abstractTrackable.fUUID)) {
            return false;
        }
        return this.fProperties.equals(abstractTrackable.fProperties);
    }

    public int hashCode() {
        int n = this.fType.hashCode();
        n = 31 * n + this.fUUID.hashCode();
        n = 31 * n + this.fProperties.hashCode();
        return n;
    }

    public String toString() {
        return String.format("%s %s : %s", this.getType(), this.getUUID(), this.getProperties());
    }
}

