/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.worker.matlab;

import com.mathworks.toolbox.distcomp.worker.matlab.MatlabShutdownInitiator;
import com.mathworks.toolbox.distcomp.worker.matlab.PackageInfo;
import com.mathworks.toolbox.distcomp.worker.matlab.ProcessShepherd;
import com.mathworks.toolbox.parallel.pctutil.logging.DistcompLevel;
import java.util.concurrent.atomic.AtomicBoolean;

public class ImmediateShutdownInitiator
implements MatlabShutdownInitiator {
    private final ProcessShepherd fMatlabShepherd;
    private AtomicBoolean fMatlabShutdownInProgress = new AtomicBoolean(false);

    public ImmediateShutdownInitiator(ProcessShepherd processShepherd) {
        this.fMatlabShepherd = processShepherd;
    }

    @Override
    public boolean isShutdownInProgress() {
        return this.fMatlabShutdownInProgress.get();
    }

    @Override
    public synchronized void shutdownMatlabNow() {
        this.cancelScheduledShutdown();
        if (this.isMatlabRunning()) {
            PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Starting MATLAB shutdown.");
            this.shutdownMatlab();
            PackageInfo.LOGGER.log(DistcompLevel.FOUR, "MATLAB shutdown complete.");
        }
    }

    protected void shutdownMatlab() {
        this.setMatlabShutdownInProgress(true);
        try {
            this.fMatlabShepherd.shutdown();
            this.fMatlabShepherd.waitForProcessToShutdown();
        }
        catch (InterruptedException interruptedException) {
            PackageInfo.LOGGER.log(DistcompLevel.ONE, "MATLAB shutdown was interrupted.");
            throw new RuntimeException(interruptedException);
        }
        finally {
            this.setMatlabShutdownInProgress(false);
        }
    }

    private void setMatlabShutdownInProgress(boolean bl) {
        this.fMatlabShutdownInProgress.set(bl);
    }

    private boolean isMatlabRunning() {
        return this.fMatlabShepherd.getState() == ProcessShepherd.State.RUNNING;
    }

    @Override
    public void scheduleMatlabShutdown(long l) {
    }

    @Override
    public boolean cancelScheduledShutdown() {
        return true;
    }
}

