/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.util.securesocket;

import com.mathworks.toolbox.distcomp.util.securesocket.Log;
import java.io.IOException;
import java.net.SocketException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;

final class SSLByteChannel
implements ScatteringByteChannel,
GatheringByteChannel {
    private static final int EOF = -1;
    private final SSLEngine fSSLEngine;
    private final ByteBuffer fNetSendBuffer;
    private final ByteBuffer fNetRecvBuffer;
    private final ByteBuffer fAppRecvBuffer;
    private SSLEngineResult fEngineResult = null;
    private final SocketChannel fSocketChannel;
    private final String fLogPrefix;
    private boolean fLoggingTerminalHandshakingStatus = true;

    SSLByteChannel(SocketChannel socketChannel, SSLEngine sSLEngine) {
        assert (socketChannel.isConnected()) : "SocketChannel should be connected";
        this.fSocketChannel = socketChannel;
        this.fSSLEngine = sSLEngine;
        String string = this.fSocketChannel.socket().getRemoteSocketAddress().toString();
        String string2 = this.fSSLEngine.getUseClientMode() ? "SSL-CLIENT " : "SSL-SERVER ";
        this.fLogPrefix = string2 + string;
        SSLSession sSLSession = this.fSSLEngine.getSession();
        int n = sSLSession.getPacketBufferSize();
        this.fNetSendBuffer = ByteBuffer.allocate(n);
        this.fNetRecvBuffer = ByteBuffer.allocate(n);
        int n2 = sSLSession.getApplicationBufferSize();
        this.fAppRecvBuffer = ByteBuffer.allocate(n2);
        Log.LOGGER.finest(this.fLogPrefix + "Allocated SSL buffers: " + "appBufferSize=" + n2 + ", netBufferSize=" + n);
    }

    @Override
    public synchronized int read(ByteBuffer byteBuffer) throws IOException {
        int n;
        int n2 = byteBuffer.remaining();
        Log.LOGGER.finest(this.fLogPrefix + "Started read of " + n2 + " bytes.");
        for (n = 0; n < n2; n += this.moveBytes(this.fAppRecvBuffer, byteBuffer)) {
            this.fAppRecvBuffer.flip();
            Log.LOGGER.finest(this.fLogPrefix + "Want " + byteBuffer.remaining() + " bytes, have " + this.fAppRecvBuffer.remaining() + " bytes.");
            if (byteBuffer.remaining() <= this.fAppRecvBuffer.remaining()) continue;
            n += this.moveBytes(this.fAppRecvBuffer, byteBuffer);
            this.fAppRecvBuffer.clear();
            int n3 = this.readIntoRecvBuffer();
            this.fAppRecvBuffer.flip();
            if (n3 > 0) continue;
            n = n > 0 ? n : n3;
            break;
        }
        Log.LOGGER.finest(this.fLogPrefix + "Finished read of " + n + " bytes.");
        return n;
    }

    @Override
    public synchronized long read(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        long l = 0L;
        for (int i = n; i < n + n2; ++i) {
            ByteBuffer byteBuffer = byteBufferArray[i];
            int n3 = byteBuffer.remaining();
            int n4 = this.read(byteBuffer);
            if (n4 != -1) {
                l += (long)n4;
            }
            if (n4 < n3) break;
            if (n4 == n3) continue;
            throw new IllegalStateException("bytesRead (" + n4 + ") is larger than remaining (" + n3 + "). " + "This should never happen.");
        }
        return l;
    }

    @Override
    public synchronized long read(ByteBuffer[] byteBufferArray) throws IOException {
        return this.read(byteBufferArray, 0, byteBufferArray.length);
    }

    @Override
    public synchronized long write(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        Log.LOGGER.finest(this.fLogPrefix + "Started write of " + (n2 - n) + " bytes");
        this.fNetSendBuffer.clear();
        this.fEngineResult = this.fSSLEngine.wrap(byteBufferArray, n, n2, this.fNetSendBuffer);
        int n3 = this.fEngineResult.bytesConsumed();
        switch (this.fEngineResult.getStatus()) {
            case BUFFER_UNDERFLOW: {
                Log.LOGGER.severe(this.fLogPrefix + "Unexpected BUFFER_UNDERFLOW from call to wrap().");
                throw new BufferUnderflowException();
            }
            case BUFFER_OVERFLOW: {
                throw new BufferOverflowException();
            }
            case CLOSED: {
                throw new SSLException("SSLEngineManagerImpl is CLOSED");
            }
        }
        this.flush();
        this.doHandshakeLoop();
        Log.LOGGER.finest(this.fLogPrefix + "Finished write of " + n3 + " bytes");
        return n3;
    }

    @Override
    public synchronized int write(ByteBuffer byteBuffer) throws IOException {
        return (int)this.write(new ByteBuffer[]{byteBuffer}, 0, 1);
    }

    @Override
    public synchronized long write(ByteBuffer[] byteBufferArray) throws IOException {
        return this.write(byteBufferArray, 0, byteBufferArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws IOException {
        Log.LOGGER.finest(this.fLogPrefix + "closing");
        try {
            try {
                this.flush();
            }
            catch (ClosedChannelException closedChannelException) {
                Log.LOGGER.log(Level.FINEST, this.fLogPrefix + "ClosedChannelException caught while flushing during close");
            }
            if (!this.fSSLEngine.isOutboundDone()) {
                this.fSSLEngine.closeOutbound();
                this.doHandshakeLoop();
            } else if (!this.fSSLEngine.isInboundDone()) {
                this.fSSLEngine.closeInbound();
                this.processHandshake();
            }
        }
        finally {
            this.fSocketChannel.close();
        }
    }

    @Override
    public synchronized boolean isOpen() {
        return this.fSocketChannel.isOpen();
    }

    private int readIntoRecvBuffer() throws IOException {
        if (this.fSSLEngine.isInboundDone()) {
            return -1;
        }
        int n = this.fAppRecvBuffer.position();
        int n2 = this.readAndUnwrap();
        switch (this.fEngineResult.getStatus()) {
            case BUFFER_OVERFLOW: {
                throw new BufferOverflowException();
            }
            case BUFFER_UNDERFLOW: {
                if (n2 == -1) break;
                return 0;
            }
            case CLOSED: {
                if (this.fSocketChannel.socket().isInputShutdown()) break;
                this.fSocketChannel.socket().shutdownInput();
                break;
            }
        }
        this.doHandshakeLoop();
        if (n2 == -1) {
            this.fSSLEngine.closeInbound();
        }
        if (this.fSSLEngine.isInboundDone()) {
            n2 = -1;
        }
        if (n2 != -1) {
            n2 = this.fAppRecvBuffer.position() - n;
        }
        return n2;
    }

    private void doHandshakeLoop() throws IOException {
        boolean bl = true;
        while (bl) {
            bl = this.processHandshake();
        }
    }

    private void logHandShakeStatus(Level level, SSLEngineResult.HandshakeStatus handshakeStatus) {
        switch (handshakeStatus) {
            case FINISHED: 
            case NOT_HANDSHAKING: {
                if (!this.fLoggingTerminalHandshakingStatus) break;
                Log.LOGGER.log(level, this.fLogPrefix + "Handshake status is " + handshakeStatus.toString());
                this.fLoggingTerminalHandshakingStatus = false;
                break;
            }
            default: {
                this.fLoggingTerminalHandshakingStatus = true;
                Log.LOGGER.log(level, this.fLogPrefix + "Handshake status is " + handshakeStatus.toString());
            }
        }
    }

    private boolean processHandshake() throws IOException {
        SSLEngineResult.HandshakeStatus handshakeStatus = this.fSSLEngine.getHandshakeStatus();
        this.logHandShakeStatus(Level.FINEST, handshakeStatus);
        switch (handshakeStatus) {
            case NEED_TASK: {
                this.runDelegatedTasks();
                return true;
            }
            case NEED_UNWRAP: {
                this.handshakeNeedUnwrap();
                break;
            }
            case NEED_WRAP: {
                this.handshakeNeedWrap();
                break;
            }
            case FINISHED: 
            case NOT_HANDSHAKING: {
                return false;
            }
        }
        switch (this.fEngineResult.getStatus()) {
            case BUFFER_UNDERFLOW: 
            case BUFFER_OVERFLOW: {
                Log.LOGGER.finest(this.fLogPrefix + "Processing of handshake stopping because of status " + (Object)((Object)this.fEngineResult.getStatus()));
                return false;
            }
            case CLOSED: {
                if (!this.fSSLEngine.isOutboundDone() || !this.fSocketChannel.socket().isOutputShutdown()) {
                    // empty if block
                }
                Log.LOGGER.finest(this.fLogPrefix + "Processing of handshake stopping because of status " + (Object)((Object)this.fEngineResult.getStatus()));
                return false;
            }
        }
        return true;
    }

    private void handshakeNeedWrap() throws IOException {
        this.fNetSendBuffer.clear();
        this.fEngineResult = this.fSSLEngine.wrap(ByteBuffer.allocate(0), this.fNetSendBuffer);
        if (this.fEngineResult.getStatus() == SSLEngineResult.Status.CLOSED) {
            Log.LOGGER.finest(this.fLogPrefix + "SSLEngine is now CLOSED");
            try {
                this.flush();
            }
            catch (SocketException socketException) {}
        } else {
            this.flush();
        }
    }

    private void handshakeNeedUnwrap() throws IOException {
        this.readAndUnwrap();
    }

    private int readAndUnwrap() throws IOException {
        int n = this.unwrap();
        if (this.fEngineResult.getStatus() == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
            Log.LOGGER.finest(this.fLogPrefix + "Unwrap failed because not enough bytes in buffer - reading from socket channel.");
            int n2 = this.fSSLEngine.isInboundDone() ? -1 : this.fSocketChannel.read(this.fNetRecvBuffer);
            Log.LOGGER.finest(this.fLogPrefix + "Read " + n2 + " bytes from socket channel.");
            if (n2 == -1) {
                n = n == 0 ? -1 : n;
            } else if (n2 != 0) {
                n += this.unwrap();
            }
        }
        return n;
    }

    private int unwrap() throws SSLException {
        if (this.fAppRecvBuffer.remaining() != this.fAppRecvBuffer.capacity()) {
            throw new IllegalStateException("Not enough room in fAppRecvBuffer to unwrap " + this.fAppRecvBuffer.remaining() + ", " + this.fAppRecvBuffer.capacity());
        }
        int n = this.fAppRecvBuffer.position();
        this.fNetRecvBuffer.flip();
        int n2 = this.fNetRecvBuffer.remaining();
        this.fEngineResult = this.fSSLEngine.unwrap(this.fNetRecvBuffer, this.fAppRecvBuffer);
        Log.LOGGER.finest(this.fLogPrefix + "Unwrap consumed " + this.fEngineResult.bytesConsumed() + " bytes " + "(of the " + n2 + " bytes available) and produced " + this.fEngineResult.bytesProduced() + " bytes.");
        this.fNetRecvBuffer.compact();
        return this.fAppRecvBuffer.position() - n;
    }

    private void runDelegatedTasks() {
        Runnable runnable;
        while ((runnable = this.fSSLEngine.getDelegatedTask()) != null) {
            Log.LOGGER.finest(this.fLogPrefix + "Running delegated task.");
            runnable.run();
        }
    }

    private int flush() throws IOException {
        this.fNetSendBuffer.flip();
        int n = 0;
        int n2 = this.fNetSendBuffer.remaining();
        while (this.fNetSendBuffer.hasRemaining()) {
            Log.LOGGER.finest(this.fLogPrefix + "Flushed " + (n += this.fSocketChannel.write(this.fNetSendBuffer)) + " bytes (of " + n2 + " bytes) to socket channel.");
        }
        this.fNetSendBuffer.compact();
        return n;
    }

    private int moveBytes(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        int n = this.copyBytes(byteBuffer, byteBuffer2);
        byteBuffer.position(byteBuffer.position() + n);
        byteBuffer.compact();
        return n;
    }

    private int copyBytes(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        int n = byteBuffer2.position();
        ByteBuffer byteBuffer3 = byteBuffer.slice();
        if (byteBuffer.remaining() > byteBuffer2.remaining()) {
            byteBuffer3.limit(byteBuffer2.remaining());
        }
        byteBuffer2.put(byteBuffer3);
        return byteBuffer2.position() - n;
    }

    public String toString() {
        return "SSLByteChannel{fSocketChannel=" + this.fSocketChannel + ", SSLUseClientMode=" + this.fSSLEngine.getUseClientMode() + '}';
    }
}

