/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.util;

import com.mathworks.util.PlatformInfo;

public enum SystemArchitecture {
    WIN32("win32", true),
    WIN64("win64", true),
    GLNX64("glnxa64", false),
    GLNX86("glnx86", false),
    MACI("maci", false),
    MACI64("maci64", false);

    private final boolean fWindows;
    private final String fArch;

    private SystemArchitecture(String string2, boolean bl) {
        this.fArch = string2;
        this.fWindows = bl;
    }

    public boolean isWindows() {
        return this.fWindows;
    }

    public String toString() {
        return this.fArch;
    }

    public static SystemArchitecture fromString(String string) {
        for (SystemArchitecture systemArchitecture : SystemArchitecture.values()) {
            if (!systemArchitecture.toString().equals(string)) continue;
            return systemArchitecture;
        }
        throw new UnknownSystemArchitectureException("Unknown architecture " + string);
    }

    public static SystemArchitecture forLocalHost() {
        if (PlatformInfo.isWindows()) {
            return PlatformInfo.isWindows64() ? WIN64 : WIN32;
        }
        if (PlatformInfo.isLinux()) {
            return PlatformInfo.isLinux64() ? GLNX64 : GLNX86;
        }
        if (PlatformInfo.isIntelMac()) {
            return PlatformInfo.isIntelMac64() ? MACI64 : MACI;
        }
        throw new UnknownSystemArchitectureException("Unknown architecture");
    }

    public static class UnknownSystemArchitectureException
    extends RuntimeException {
        UnknownSystemArchitectureException(String string) {
            super(string);
        }
    }
}

