/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.util;

import com.mathworks.toolbox.distcomp.util.SystemPropertyConfigPair;
import java.io.Serializable;

public class RemoteConfigurationFileOverride
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final SystemPropertyConfigPair fPropertyConfigPair;
    private final ConfigType fConfigType;
    private String fValue;
    private String fDefaultValue;

    public RemoteConfigurationFileOverride(SystemPropertyConfigPair systemPropertyConfigPair) {
        this.fPropertyConfigPair = systemPropertyConfigPair;
        this.fConfigType = ConfigType.String;
    }

    public RemoteConfigurationFileOverride(SystemPropertyConfigPair systemPropertyConfigPair, String string) {
        this(systemPropertyConfigPair);
        this.fValue = string;
    }

    public RemoteConfigurationFileOverride(SystemPropertyConfigPair systemPropertyConfigPair, String string, ConfigType configType) {
        this.fPropertyConfigPair = systemPropertyConfigPair;
        this.fValue = string;
        this.fConfigType = configType;
    }

    public String getConfigEntryOverride() {
        switch (this.fConfigType) {
            case String: {
                return this.fPropertyConfigPair.getConfigName() + "=\"" + this.getValue() + "\"";
            }
            case Integer: {
                return this.fPropertyConfigPair.getConfigName() + "=" + this.getValue();
            }
        }
        assert (false) : "Forgot to define a case";
        return "";
    }

    public void setValue(String string) {
        this.fValue = string;
    }

    public void setDefaultValue(String string) {
        this.fDefaultValue = string;
    }

    public String getValue() {
        if (this.fValue != null && this.fValue.length() != 0) {
            return this.fValue;
        }
        if (this.fDefaultValue != null && this.fDefaultValue.length() != 0) {
            return this.fDefaultValue;
        }
        return System.getProperty(this.fPropertyConfigPair.getPropertyName(), "");
    }

    public String toString() {
        return "SystemPropertyName: " + this.fPropertyConfigPair.getPropertyName() + "ConfigurationFileName: " + this.fPropertyConfigPair.getConfigName() + "with value: " + this.fValue;
    }

    public static enum ConfigType {
        String,
        Integer;

    }
}

