/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.util;

import com.mathworks.toolbox.distcomp.util.FreeFctor;
import java.lang.ref.WeakReference;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

class ReferenceCounter<RealObj_T, Handle_T> {
    private List<WeakReference<Handle_T>> fWeakRefsToHandles = new LinkedList<WeakReference<Handle_T>>();
    private RealObj_T fRealObj;
    private FreeFctor<RealObj_T> fFreeFctor;

    ReferenceCounter(RealObj_T RealObj_T, FreeFctor<RealObj_T> freeFctor) {
        this.fRealObj = RealObj_T;
        this.fFreeFctor = freeFctor;
    }

    synchronized void addHandle(Handle_T Handle_T) {
        this.fWeakRefsToHandles.add(new WeakReference<Handle_T>(Handle_T));
    }

    synchronized void freeHandle(Handle_T Handle_T) {
        ListIterator<WeakReference<Handle_T>> listIterator = this.fWeakRefsToHandles.listIterator(0);
        while (listIterator.hasNext()) {
            WeakReference weakReference = (WeakReference)listIterator.next();
            if (weakReference.get() == null) {
                listIterator.remove();
            }
            if (weakReference.get() != Handle_T) continue;
            listIterator.remove();
        }
        if (this.fWeakRefsToHandles.size() == 0) {
            this.fFreeFctor.free(this.fRealObj);
            this.fRealObj = null;
        }
    }
}

