/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.util;

import com.mathworks.resource_core.BaseMsgID;
import com.mathworks.resources.parallel.cluster.mjs;
import com.mathworks.toolbox.distcomp.util.NetworkConfigException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.HashSet;

public class LocalNetworkInfo {
    private LocalNetworkInfo() {
    }

    public static String findHostName() throws NetworkConfigException {
        String string = System.getProperty("java.rmi.server.hostname");
        if (string == null || string.isEmpty()) {
            throw new NetworkConfigException((BaseMsgID)new mjs.UnobtainableHostname());
        }
        try {
            new URL("http://" + string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new NetworkConfigException((BaseMsgID)new mjs.ComputerHostnameMalformed(string), (Throwable)malformedURLException);
        }
        return string;
    }

    public static String findComputerHostName() throws NetworkConfigException {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            throw new NetworkConfigException((BaseMsgID)new mjs.UnobtainableHostname(), (Throwable)unknownHostException);
        }
    }

    public static String[] findAllHostAddresses() {
        String[] stringArray;
        try {
            HashSet<String> hashSet = new HashSet<String>();
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration.nextElement();
                Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
                while (enumeration2.hasMoreElements()) {
                    InetAddress inetAddress = enumeration2.nextElement();
                    hashSet.add(inetAddress.getHostAddress());
                }
            }
            stringArray = hashSet.toArray(new String[hashSet.size()]);
        }
        catch (SocketException socketException) {
            stringArray = new String[]{""};
        }
        return stringArray;
    }

    public static boolean isLocalAddressOnNIC() throws NetworkConfigException {
        String[] stringArray;
        String string;
        try {
            string = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            throw new NetworkConfigException((BaseMsgID)new mjs.UnobtainableHostname(), (Throwable)unknownHostException);
        }
        for (String string2 : stringArray = LocalNetworkInfo.findAllHostAddresses()) {
            if (!string.equals(string2)) continue;
            return true;
        }
        return false;
    }
}

