/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.util;

import com.mathworks.resource_core.BaseMsgID;
import com.mathworks.resources.parallel.cluster.mjs;
import com.mathworks.toolbox.distcomp.util.i18n.I18nMatlabIdentifiedException;
import com.mathworks.toolbox.parallel.util.i18n.I18nMessageCreator;
import com.mathworks.toolbox.parallel.util.i18n.XMLMessageCreator;
import java.io.Reader;
import java.util.Arrays;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.config.ConfigurationFile;
import net.jini.config.ConfigurationNotFoundException;
import net.jini.config.NoSuchEntryException;

public class ConfigFileWrapper {
    private final Configuration fConfig;
    private final String fComponent;
    private final String[] fArgs;
    public static final String DEFAULT_COMPONENT = "com.sun.jini.start";

    public ConfigFileWrapper(String[] stringArray) throws ConfigurationException {
        this(stringArray, DEFAULT_COMPONENT);
    }

    public ConfigFileWrapper(Reader reader, String[] stringArray) throws ConfigurationException {
        this.fComponent = DEFAULT_COMPONENT;
        this.fArgs = Arrays.copyOf(stringArray, stringArray.length);
        this.fConfig = new ConfigurationFile(reader, stringArray);
    }

    public ConfigFileWrapper(String[] stringArray, String string) throws ConfigurationException {
        this.fComponent = string;
        this.fArgs = Arrays.copyOf(stringArray, stringArray.length);
        this.fConfig = new ConfigurationFile(stringArray);
    }

    public String[] getConfigurationStringArray() {
        return Arrays.copyOf(this.fArgs, this.fArgs.length);
    }

    public String getStringEntry(String string) throws ConfigurationException {
        return (String)this.getEntry(string, String.class);
    }

    public String getNonEmptyStringEntry(String string) throws ConfigurationException {
        String string2 = (String)this.getEntry(string, String.class);
        if (string2.isEmpty()) {
            throw new ConfigFileException((BaseMsgID)new mjs.EmptyEntry(string));
        }
        return string2;
    }

    public int getIntEntry(String string) throws ConfigurationException {
        return (Integer)this.getEntry(string, Integer.TYPE);
    }

    public int getIntEntry(String string, int n) {
        try {
            return this.getIntEntry(string);
        }
        catch (Exception exception) {
            try {
                return Integer.parseInt(this.getStringEntry(string));
            }
            catch (Exception exception2) {
                return n;
            }
        }
    }

    public boolean getBooleanEntry(String string) throws ConfigurationException {
        return (Boolean)this.getEntry(string, Boolean.class);
    }

    public boolean getBooleanEntry(String string, boolean bl) {
        try {
            return this.getBooleanEntry(string);
        }
        catch (Exception exception) {
            try {
                return Boolean.valueOf(this.getStringEntry(string));
            }
            catch (Exception exception2) {
                return bl;
            }
        }
    }

    public Object getEntry(String string, Class clazz) throws ConfigurationException {
        try {
            return this.fConfig.getEntry(this.fComponent, string, clazz);
        }
        catch (NoSuchEntryException noSuchEntryException) {
            throw new ConfigFileException((BaseMsgID)new mjs.NoEntryFound(string), (Exception)((Object)noSuchEntryException));
        }
        catch (ConfigurationNotFoundException configurationNotFoundException) {
            throw configurationNotFoundException;
        }
        catch (ConfigurationException configurationException) {
            throw new ConfigFileException((BaseMsgID)new mjs.ProblemReadingConfigFile(), (Exception)((Object)configurationException));
        }
    }

    public Configuration getConfiguration() {
        return this.fConfig;
    }

    private static final class ConfigFileException
    extends ConfigurationException
    implements I18nMatlabIdentifiedException {
        private final I18nMessageCreator fErrorMessageCreator = new XMLMessageCreator();
        private final BaseMsgID fMessageID;

        private ConfigFileException(BaseMsgID baseMsgID) {
            super("");
            this.fMessageID = baseMsgID;
        }

        private ConfigFileException(BaseMsgID baseMsgID, Exception exception) {
            super("", (Throwable)exception);
            this.fMessageID = baseMsgID;
        }

        @Override
        public String getMessage() {
            return this.fErrorMessageCreator.createMessage(this.fMessageID);
        }

        @Override
        public String getLocalizedMessage() {
            return this.fErrorMessageCreator.createLocalizedMessage(this.fMessageID);
        }

        public String getMessageID() {
            return this.fMessageID.getCatalogId() + ":" + this.fMessageID.getMessageId();
        }
    }
}

