/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.util;

import com.mathworks.toolbox.distcomp.nativedmatlab.ByteBuffAndKey;
import com.mathworks.toolbox.distcomp.nativedmatlab.FreeableDirectByteBuffer;
import com.mathworks.toolbox.distcomp.util.FreeFreeableBufferFctor;
import com.mathworks.toolbox.distcomp.util.ReferenceCounter;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;

public final class ByteBufferHandle {
    private AtomicBoolean fHandleFreed;
    private ReferenceCounter<ByteBuffAndKey, ByteBufferHandle> fRefCounter;
    private ByteBuffer fMyDupe;

    public static ByteBufferHandle allocateDirect(int n) {
        ByteBuffAndKey byteBuffAndKey = FreeableDirectByteBuffer.allocateFreeableDirect(n);
        FreeFreeableBufferFctor freeFreeableBufferFctor = new FreeFreeableBufferFctor();
        ReferenceCounter<ByteBuffAndKey, ByteBufferHandle> referenceCounter = new ReferenceCounter<ByteBuffAndKey, ByteBufferHandle>(byteBuffAndKey, freeFreeableBufferFctor);
        return new ByteBufferHandle(referenceCounter, byteBuffAndKey.getBuffer());
    }

    public static ByteBufferHandle allocate(int n) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(n);
        return new ByteBufferHandle(null, byteBuffer);
    }

    public static ByteBufferHandle wrap(byte[] byArray) {
        return new ByteBufferHandle(null, ByteBuffer.wrap(byArray));
    }

    public static ByteBufferHandle wrap(ByteBuffer byteBuffer) {
        return new ByteBufferHandle(null, byteBuffer);
    }

    public static void freeBuffers(ByteBufferHandle[] byteBufferHandleArray) {
        for (ByteBufferHandle byteBufferHandle : byteBufferHandleArray) {
            byteBufferHandle.free();
        }
    }

    private ByteBufferHandle(ReferenceCounter<ByteBuffAndKey, ByteBufferHandle> referenceCounter, ByteBuffer byteBuffer) {
        this.fRefCounter = referenceCounter;
        this.fHandleFreed = new AtomicBoolean(false);
        this.fMyDupe = byteBuffer.duplicate();
        if (this.fRefCounter != null) {
            this.fRefCounter.addHandle(this);
        }
    }

    public ByteBuffer get() {
        assert (!this.fHandleFreed.get()) : "Attempt to get buffer of a freed ByteBufferHandle";
        return this.fHandleFreed.get() ? null : this.fMyDupe;
    }

    public void free() {
        if (this.fHandleFreed.getAndSet(true)) {
            assert (false) : "ByteBufferHandle already freed!";
        } else if (this.fRefCounter != null) {
            this.fRefCounter.freeHandle(this);
        }
    }

    public ByteBufferHandle duplicate() {
        assert (!this.fHandleFreed.get()) : "Attempt to duplicate a freed handle";
        return this.fHandleFreed.get() ? null : new ByteBufferHandle(this.fRefCounter, this.fMyDupe);
    }
}

