/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.ui.profile.model;

import com.mathworks.services.settings.Setting;
import com.mathworks.services.settings.SettingAccessException;
import com.mathworks.services.settings.SettingAdapter;
import com.mathworks.services.settings.SettingChangeEvent;
import com.mathworks.services.settings.SettingListener;
import com.mathworks.services.settings.SettingNotFoundException;
import com.mathworks.services.settings.SettingPath;
import com.mathworks.services.settings.SettingTypeException;
import com.mathworks.services.settings.SettingValidationException;
import com.mathworks.toolbox.distcomp.ui.PackageInfo;
import com.mathworks.toolbox.distcomp.ui.model.PropertyChangeSupportAdaptor;
import com.mathworks.toolbox.distcomp.ui.profile.model.DefaultProfileName;
import com.mathworks.toolbox.parallel.pctutil.logging.DistcompLevel;

public class SettingsDefaultProfileName
extends PropertyChangeSupportAdaptor
implements DefaultProfileName {
    private Setting<String> fDefaultProfile;
    private static final SettingPath PARALLEL_CLIENT = new SettingPath(new String[]{"parallel", "client"});
    private static final String DEFAULT_PROFILE = "DefaultProfile";

    public SettingsDefaultProfileName() {
        try {
            this.fDefaultProfile = new Setting(PARALLEL_CLIENT, DEFAULT_PROFILE);
        }
        catch (SettingNotFoundException settingNotFoundException) {
            PackageInfo.LOGGER.log(DistcompLevel.ONE, "Unable to create default profile settings node.", settingNotFoundException);
        }
        try {
            this.fDefaultProfile.addListener((SettingListener)new SettingAdapter(){

                public void settingChanged(SettingChangeEvent settingChangeEvent) {
                    SettingsDefaultProfileName.this.firePropertyChange("DefaultProfileNameChanged", "", SettingsDefaultProfileName.this.getDefaultProfileName());
                }
            });
        }
        catch (SettingNotFoundException settingNotFoundException) {
            PackageInfo.LOGGER.log(DistcompLevel.ONE, "Unable to add listener to the default profile settings node.", settingNotFoundException);
        }
    }

    @Override
    public String getDefaultProfileName() {
        try {
            return (String)this.fDefaultProfile.get();
        }
        catch (SettingTypeException settingTypeException) {
            return null;
        }
        catch (SettingNotFoundException settingNotFoundException) {
            return null;
        }
    }

    @Override
    public void setDefaultProfileName(String string) {
        try {
            this.fDefaultProfile.set((Object)string);
        }
        catch (SettingNotFoundException settingNotFoundException) {
        }
        catch (SettingTypeException settingTypeException) {
        }
        catch (SettingAccessException settingAccessException) {
        }
        catch (SettingValidationException settingValidationException) {
            // empty catch block
        }
    }
}

