/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.ui.profile;

import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJTextArea;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.toolbox.distcomp.ui.model.Constraint;
import com.mathworks.toolbox.distcomp.ui.model.Property;
import com.mathworks.toolbox.distcomp.ui.model.PropertyInfo;
import com.mathworks.toolbox.distcomp.ui.panel.StyleGuideRelatedPanel;
import com.mathworks.toolbox.distcomp.ui.widget.BooleanView;
import com.mathworks.toolbox.distcomp.ui.widget.CallbackView;
import com.mathworks.toolbox.distcomp.ui.widget.ConfigurablePropertyView;
import com.mathworks.toolbox.distcomp.ui.widget.EnumView;
import com.mathworks.toolbox.distcomp.ui.widget.IntegerVectorView;
import com.mathworks.toolbox.distcomp.ui.widget.IntegerView;
import com.mathworks.toolbox.distcomp.ui.widget.StringVectorView;
import com.mathworks.toolbox.distcomp.ui.widget.StringView;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;

class ViewProvider {
    private static final Dimension MIN_SCROLL_PANE_SIZE = new Dimension(250, 100);
    private static final Dimension MAX_SCROLL_PANE_SIZE = new Dimension(Integer.MAX_VALUE, 100);

    private ViewProvider() {
    }

    static Map<Property, JComponent> getReadView(List<? extends Property> list) {
        return ViewProvider.createPropertyViewMap(list, true);
    }

    static Map<Property, JComponent> getEditView(List<? extends Property> list) {
        return ViewProvider.createPropertyViewMap(list, false);
    }

    private static Map<Property, JComponent> createPropertyViewMap(List<? extends Property> list, boolean bl) {
        LinkedHashMap<Property, JComponent> linkedHashMap = new LinkedHashMap<Property, JComponent>();
        for (Property property : list) {
            PropertyInfo propertyInfo = property.getPropertyInfo();
            if (propertyInfo.isHidden()) continue;
            Object object = property.getPropertyInfo().isConfigurable() && !bl ? ViewProvider.createEditComponent(property) : ViewProvider.createReadOnlyComponent(property);
            linkedHashMap.put(property, (JComponent)object);
        }
        return linkedHashMap;
    }

    private static JComponent createReadOnlyComponent(final Property property) {
        MJLabel mJLabel;
        StyleGuideRelatedPanel styleGuideRelatedPanel = new StyleGuideRelatedPanel();
        String string = property.getPropertyInfo().getName() + "ValueLabel";
        String string2 = property.getDisplayString();
        if (property.getPropertyInfo().getConstraint().getConstraintType().equals((Object)Constraint.PCTConstraint.CELLSTR)) {
            MJTextArea mJTextArea = new MJTextArea(string2);
            mJTextArea.setBackground(new JPanel().getBackground());
            mJTextArea.setEditable(false);
            mJTextArea.setName(string);
            MJScrollPane mJScrollPane = new MJScrollPane((Component)mJTextArea);
            mJScrollPane.setMaximumSize(MAX_SCROLL_PANE_SIZE);
            mJScrollPane.setMinimumSize(MIN_SCROLL_PANE_SIZE);
            mJScrollPane.setPreferredSize(MIN_SCROLL_PANE_SIZE);
            property.addPropertyChangeListener(new PropertyChangeListener((JTextArea)mJTextArea){
                final /* synthetic */ JTextArea val$textArea;
                {
                    this.val$textArea = jTextArea;
                }

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    final String string = property.getDisplayString();
                    MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            val$textArea.setText(string);
                        }
                    });
                }
            });
            mJLabel = mJScrollPane;
        } else {
            MJLabel mJLabel2 = new MJLabel(string2);
            mJLabel2.setName(string);
            mJLabel2.setMinimumSize(new Dimension(250, (int)mJLabel2.getPreferredSize().getHeight()));
            mJLabel2.setPreferredSize(new Dimension(250, (int)mJLabel2.getPreferredSize().getHeight()));
            property.addPropertyChangeListener(new PropertyChangeListener((JLabel)mJLabel2){
                final /* synthetic */ JLabel val$jLabel;
                {
                    this.val$jLabel = jLabel;
                }

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    final String string = property.getDisplayString();
                    MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            val$jLabel.setText(string);
                        }
                    });
                }
            });
            mJLabel = mJLabel2;
        }
        styleGuideRelatedPanel.addLine((JComponent)mJLabel);
        return styleGuideRelatedPanel;
    }

    private static ConfigurablePropertyView createEditComponent(Property property) {
        ConfigurablePropertyView configurablePropertyView = null;
        String string = property.getPropertyInfo().getName();
        switch (property.getPropertyInfo().getConstraint().getConstraintType()) {
            case STRING: {
                string = string + "Textfield";
                configurablePropertyView = new StringView(property, string);
                break;
            }
            case CELLSTR: {
                string = string + "TextArea";
                configurablePropertyView = new StringVectorView(property, string);
                break;
            }
            case LOGICALSCALAR: {
                string = string + "Combobox";
                configurablePropertyView = new BooleanView(property, string);
                break;
            }
            case POSITIVEINTSCALAR: {
                string = string + "Textfield";
                configurablePropertyView = new IntegerView(property, string);
                break;
            }
            case DATALOCATION: {
                string = string + "Textfield";
                configurablePropertyView = new StringView(property, string);
                break;
            }
            case CALLBACK: {
                string = string + "Textfield";
                configurablePropertyView = new CallbackView(property, string);
                break;
            }
            case NONEMPTYSTRING: {
                string = string + "Textfield";
                configurablePropertyView = new StringView(property, string);
                break;
            }
            case WORKERLIMITS: {
                string = string + "Textfield";
                configurablePropertyView = new IntegerVectorView(property, string);
                break;
            }
            case ENUM: {
                string = string + "Combobox";
                configurablePropertyView = new EnumView(property, string);
            }
        }
        return configurablePropertyView;
    }
}

