/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.ui.profile;

import com.mathworks.mwswing.MJTextField;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.toolbox.distcomp.ui.ClickAwayFocusListener;
import com.mathworks.toolbox.distcomp.ui.model.Selection;
import com.mathworks.toolbox.distcomp.ui.model.SelectionEvent;
import com.mathworks.toolbox.distcomp.ui.model.SelectionListener;
import com.mathworks.toolbox.distcomp.ui.profile.model.Profile;
import com.mathworks.toolbox.distcomp.ui.profile.model.ProfileManager;
import com.mathworks.toolbox.distcomp.ui.widget.TablePanel;
import java.awt.Color;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.border.CompoundBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.text.JTextComponent;

final class ProfileTablePanel
extends TablePanel {
    private static final ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.toolbox.distcomp.ui.resources.RES_profile");
    private static final String PROFILE_TABLE_QE_NAME = "ProfileTable";

    ProfileTablePanel(ProfileManager profileManager, final Selection<Profile> selection) {
        super(new ProfileTableModel(profileManager), PROFILE_TABLE_QE_NAME);
        profileManager.addPropertyChangeListener(this);
        this.updateTableSelection(selection.getSelection());
        this.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                if (listSelectionModel.isSelectionEmpty()) {
                    return;
                }
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    selection.setSelection((Profile)ProfileTablePanel.this.getTableSelection());
                }
            }
        });
        selection.addSelectionListener(new SelectionListener<Profile>(){

            @Override
            public void selectionChanged(SelectionEvent<Profile> selectionEvent) {
                Profile profile = selectionEvent.getNewSelection();
                ProfileTablePanel.this.updateTableSelection(profile);
            }
        });
        this.setCustomRenderer(0, new ProfileTableCellRenderer(profileManager));
        this.setCustomEditor(0, new ProfileTableCellEditor());
    }

    private void updateTableSelection(final Object object) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (object instanceof Profile) {
                    ProfileTablePanel.this.setTableSelection(object);
                } else {
                    ProfileTablePanel.this.clearSelectedRow();
                }
            }
        });
    }

    @Override
    public void propertyChange(final PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("ProfileRemoved") || propertyChangeEvent.getPropertyName().equals("ProfileRenamed") || propertyChangeEvent.getPropertyName().equals("Initialized") || propertyChangeEvent.getPropertyName().equals("DefaultProfileChanged")) {
            MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    ProfileTablePanel.this.updateTable();
                }
            });
        } else if (propertyChangeEvent.getPropertyName().equals("ProfileAdded")) {
            MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    ProfileTablePanel.this.updateTable();
                    ProfileTablePanel.this.updateTableSelection(propertyChangeEvent.getNewValue());
                }
            });
        }
    }

    public Object getTableSelection() {
        int n = this.getSelectedRow();
        if (n == -1) {
            n = this.getRowCount() - 1;
        }
        return n == -1 ? null : this.getValueAt(n, 0);
    }

    public void setTableSelection(Object object) {
        for (int i = 0; i < this.getRowCount(); ++i) {
            Object object2 = this.getValueAt(i, 0);
            if (!object.equals(object2)) continue;
            this.setSelectedRow(i);
            return;
        }
    }

    private static final class ProfileTableModel
    extends AbstractTableModel {
        private ProfileManager fProfileManager;
        private static final int NUM_COLUMN = 1;
        static final int NAME_COLUMN = 0;

        private ProfileTableModel(ProfileManager profileManager) {
            this.fProfileManager = profileManager;
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return sRes.getString("ProfileManager.ProfileTable.ColumnName");
            }
            assert (false) : "Unknown column";
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return !this.fProfileManager.getProfiles().get(n).getName().equals("local");
        }

        @Override
        public int getRowCount() {
            return this.getNames().size();
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return this.fProfileManager.getProfiles().get(n);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            String string = this.getNames().get(n);
            String string2 = (String)object;
            this.fProfileManager.renameProfile(string, string2);
        }

        private List<String> getNames() {
            return Arrays.asList(this.fProfileManager.getProfileNames());
        }
    }

    private static final class ProfileTableCellEditor
    extends DefaultCellEditor {
        private ProfileTableCellEditor() {
            super((JTextField)new MJTextField());
            JTextField jTextField = (JTextField)this.getComponent();
            jTextField.addFocusListener(new ClickAwayFocusListener(jTextField, new Runnable(){

                @Override
                public void run() {
                    ProfileTableCellEditor.this.stopCellEditing();
                }
            }));
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            Component component = super.getTableCellEditorComponent(jTable, object, bl, n, n2);
            ((JTextComponent)component).setText(((Profile)object).getName());
            CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.BLACK), BorderFactory.createEmptyBorder(0, 1, 0, 2));
            ((JComponent)component).setBorder(compoundBorder);
            ((JTextComponent)component).selectAll();
            return component;
        }
    }

    private static final class ProfileTableCellRenderer
    extends DefaultTableCellRenderer {
        private ProfileManager fProfileManager;

        private ProfileTableCellRenderer(ProfileManager profileManager) {
            this.fProfileManager = profileManager;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (object instanceof Profile) {
                String string = ((Profile)object).getName();
                if (object.equals(this.fProfileManager.getDefaultProfile())) {
                    jLabel.setText(MessageFormat.format(sRes.getString("ProfileManager.DefaultProfile"), string));
                } else {
                    jLabel.setText(string);
                }
            }
            return jLabel;
        }
    }
}

