/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.ui.profile;

import com.jidesoft.swing.PartialEtchedBorder;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.toolbox.distcomp.ui.panel.AbstractStyleGuidePanel;
import com.mathworks.toolbox.distcomp.ui.panel.StyleGuideEmptyPanel;
import com.mathworks.toolbox.distcomp.ui.panel.StyleGuidePanel;
import com.mathworks.toolbox.distcomp.ui.widget.LightBoxGlassPane;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public abstract class EditPanel
extends StyleGuideEmptyPanel {
    private AbstractStyleGuidePanel fMainSection;
    private AbstractStyleGuidePanel fModeControlSection;
    private boolean fIsEditing = false;
    private JButton fEditButton;
    private JButton fCancelButton;
    private JButton fDoneButton;
    private static final ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.toolbox.distcomp.ui.resources.RES_profile");
    private JScrollPane fScrollPane;
    private final LightBoxGlassPane fGlassPane;

    public EditPanel(JComponent jComponent) {
        this.createMainSection(jComponent);
        this.createModeControlSection();
        this.fGlassPane = new LightBoxGlassPane((JComponent)((Object)this));
        this.fScrollPane = new MJScrollPane((Component)((Object)this.fMainSection));
        this.fScrollPane.setBorder(null);
        this.fScrollPane.getVerticalScrollBar().setUnitIncrement(10);
        this.addLine(this.fScrollPane, 8);
        this.addLine((JComponent)((Object)this.fModeControlSection));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                EditPanel.this.fScrollPane.getVerticalScrollBar().setValue(0);
            }
        });
        this.setFocusCycleRoot(true);
        this.fEditButton.setName("EditPanel.EditButton");
        this.fDoneButton.setName("EditPanel.DoneButton");
        this.fCancelButton.setName("EditPanel.CancelButton");
    }

    private void createMainSection(JComponent jComponent) {
        this.fMainSection = new StyleGuideEmptyPanel();
        this.fMainSection.addLine(jComponent, 8);
    }

    private void createModeControlSection() {
        this.fModeControlSection = new StyleGuidePanel();
        PartialEtchedBorder partialEtchedBorder = new PartialEtchedBorder(1, 1);
        this.fModeControlSection.setBorder((Border)partialEtchedBorder);
        this.fEditButton = new JButton((Action)new MJAbstractAction(sRes.getString("EditPanel.EditButton")){

            public void actionPerformed(ActionEvent actionEvent) {
                EditPanel.this.showEditPanel();
            }
        });
        this.fCancelButton = new JButton((Action)new MJAbstractAction(sRes.getString("EditPanel.CancelButton")){

            public void actionPerformed(ActionEvent actionEvent) {
                EditPanel.this.handleCancelButtonClicked();
                EditPanel.this.updateToEditButton();
                EditPanel.this.fIsEditing = false;
            }
        });
        this.fDoneButton = new JButton((Action)new MJAbstractAction(sRes.getString("EditPanel.DoneButton")){

            public void actionPerformed(ActionEvent actionEvent) {
                EditPanel.this.fCancelButton.setEnabled(false);
                EditPanel.this.fDoneButton.setEnabled(false);
                EditPanel.this.handleDoneButtonClicked();
            }
        });
        this.fModeControlSection.addLine((JComponent[][])new JComponent[][]{{null, this.fEditButton}}, 0, 0);
    }

    public void showEditPanel() {
        this.handleEditButtonClicked();
        this.updateToDoneCancelButtons();
        this.fIsEditing = true;
    }

    void cancelEditing() {
        assert (SwingUtilities.isEventDispatchThread()) : "Cancel editing should only be called from the EDT thread";
        if (this.fIsEditing) {
            this.handleCancelButtonClicked();
            this.updateToEditButton();
        }
        this.fIsEditing = false;
    }

    public void doneSuccessful() {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                EditPanel.this.handleDoneSuccessful();
                EditPanel.this.updateToEditButton();
                EditPanel.this.fIsEditing = false;
            }
        });
    }

    public void doneFailed() {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                EditPanel.this.fDoneButton.setEnabled(true);
                EditPanel.this.fCancelButton.setEnabled(true);
            }
        });
    }

    abstract void handleEditButtonClicked();

    abstract void handleCancelButtonClicked();

    abstract void handleDoneButtonClicked();

    abstract void handleDoneSuccessful();

    public void setMainSection(JComponent jComponent) {
        final int n = this.fScrollPane.getVerticalScrollBar().getValue();
        this.fMainSection.removeAll();
        this.fMainSection.addLine(jComponent, 8);
        this.fMainSection.revalidate();
        this.fMainSection.repaint();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                EditPanel.this.fScrollPane.getVerticalScrollBar().setValue(n);
            }
        });
    }

    private void updateToDoneCancelButtons() {
        this.fDoneButton.setEnabled(true);
        this.fCancelButton.setEnabled(true);
        this.fModeControlSection.removeAll();
        this.fModeControlSection.addLine((JComponent[][])new JComponent[][]{{null, this.fDoneButton, this.fCancelButton}}, 0, 0);
        this.fDoneButton.requestFocus();
        this.activateGlassPane();
    }

    private void updateToEditButton() {
        this.fModeControlSection.removeAll();
        this.fModeControlSection.addLine((JComponent[][])new JComponent[][]{{null, this.fEditButton}}, 0, 0);
        this.deactivateGlassPane();
    }

    private void activateGlassPane() {
        Window window = SwingUtilities.windowForComponent((Component)((Object)this));
        if (window instanceof JDialog || window instanceof JFrame) {
            ((RootPaneContainer)((Object)window)).setGlassPane(this.fGlassPane);
        }
        this.fGlassPane.setVisible(true);
        this.fGlassPane.revalidate();
    }

    private void deactivateGlassPane() {
        this.fGlassPane.setVisible(false);
    }
}

