/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.ui.model;

import com.mathworks.toolbox.distcomp.ui.model.DefaultValue;
import com.mathworks.widgets.text.mcode.MLint;
import com.mathworks.widgets.text.mcode.analyzer.CodeAnalyzerUtils;
import java.util.List;

public final class Constraint {
    private final PCTConstraint fConstraintType;
    private final Object fAdditionalInputs;

    public Constraint(PCTConstraint pCTConstraint, Object object) {
        this.fConstraintType = pCTConstraint;
        this.fAdditionalInputs = object;
    }

    public boolean checkConstraint(Object object) {
        return object instanceof DefaultValue || this.fConstraintType.checkConstraint(object, this.fAdditionalInputs);
    }

    public Object getAdditionalInputs() {
        return this.fAdditionalInputs;
    }

    public PCTConstraint getConstraintType() {
        return this.fConstraintType;
    }

    public String toString() {
        return "PCTConstraint = " + this.fConstraintType.toString() + " " + "AdditionalInputs = " + this.fAdditionalInputs.toString();
    }

    public static enum PCTConstraint {
        DATALOCATION{

            @Override
            public boolean checkConstraint(Object object, Object ... objectArray) {
                return object instanceof String;
            }
        }
        ,
        POSITIVEINTSCALAR{

            @Override
            public boolean checkConstraint(Object object, Object ... objectArray) {
                return object instanceof Double && PCTConstraint.isPositiveInteger((Double)object);
            }
        }
        ,
        STRING{

            @Override
            public boolean checkConstraint(Object object, Object ... objectArray) {
                return object instanceof String;
            }
        }
        ,
        NONEMPTYSTRING{

            @Override
            public boolean checkConstraint(Object object, Object ... objectArray) {
                return object instanceof String && !((String)object).isEmpty();
            }
        }
        ,
        CELLSTR{

            @Override
            public boolean checkConstraint(Object object, Object ... objectArray) {
                return object instanceof String[];
            }
        }
        ,
        LOGICALSCALAR{

            @Override
            public boolean checkConstraint(Object object, Object ... objectArray) {
                return object instanceof Boolean;
            }
        }
        ,
        CALLBACK{

            @Override
            public boolean checkConstraint(Object object, Object ... objectArray) {
                if (object == null || !(object instanceof String)) {
                    return false;
                }
                String string = ((String)object).trim();
                if (string.length() == 0) {
                    return true;
                }
                List list = MLint.getMessages((String)string, null);
                for (MLint.Message message : list) {
                    if (!CodeAnalyzerUtils.isError((MLint.Message)message)) continue;
                    return false;
                }
                if (string.startsWith("@")) {
                    return true;
                }
                if (string.startsWith("{")) {
                    String string2 = string.substring(1, string.length()).trim();
                    return string2.startsWith("@") || string2.startsWith("'");
                }
                return !string.startsWith("'");
            }
        }
        ,
        WORKERLIMITS{

            @Override
            public boolean checkConstraint(Object object, Object ... objectArray) {
                if (object instanceof Double) {
                    Double d = (Double)object;
                    return d > 0.0 && (double)d.intValue() == d;
                }
                if (object instanceof Double[] && ((Double[])object).length == 2) {
                    Double d = ((Double[])object)[0];
                    Double d2 = ((Double[])object)[1];
                    return PCTConstraint.isPositiveInteger(d) && (PCTConstraint.isPositiveInteger(d2) || d2.isInfinite()) && !d.isInfinite() && d <= d2;
                }
                return false;
            }
        }
        ,
        ENUM{

            @Override
            public boolean checkConstraint(Object object, Object ... objectArray) {
                if (object instanceof String) {
                    List list = (List)objectArray[0];
                    for (String string : list) {
                        if (!object.equals(string)) continue;
                        return true;
                    }
                }
                return false;
            }
        };


        protected abstract boolean checkConstraint(Object var1, Object ... var2);

        private static boolean isPositiveInteger(Double d) {
            return d > 0.0 && (double)d.intValue() == d;
        }
    }
}

