/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.ui.jobmonitor;

import com.jidesoft.grid.SortableTable;
import com.jidesoft.grid.TableModelWrapper;
import com.jidesoft.swing.DefaultOverlayable;
import com.mathworks.common.icons.DialogIcon;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJCheckBox;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJMenuItem;
import com.mathworks.mwswing.MJMultilineLabel;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.toolbox.distcomp.ui.UpdateChangeListener;
import com.mathworks.toolbox.distcomp.ui.UpdatePanel;
import com.mathworks.toolbox.distcomp.ui.jobmonitor.ColumnInfo;
import com.mathworks.toolbox.distcomp.ui.jobmonitor.JobCorruptionInfo;
import com.mathworks.toolbox.distcomp.ui.jobmonitor.JobCorruptionLevel;
import com.mathworks.toolbox.distcomp.ui.jobmonitor.JobMonitorModel;
import com.mathworks.toolbox.distcomp.ui.jobmonitor.JobMonitorTableModel;
import com.mathworks.toolbox.distcomp.ui.jobmonitor.JobStateModel;
import com.mathworks.toolbox.distcomp.ui.jobmonitor.JobTableRowModel;
import com.mathworks.toolbox.distcomp.ui.jobmonitor.JobType;
import com.mathworks.toolbox.distcomp.ui.panel.StyleGuidePanel;
import com.mathworks.toolbox.distcomp.ui.profile.ProfileSelector;
import com.mathworks.toolbox.distcomp.ui.profile.model.ProfileManager;
import com.mathworks.toolbox.distcomp.ui.resources.icons.ParallelIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.apache.commons.lang.StringUtils;

public final class JobMonitorUI
extends StyleGuidePanel {
    private JobMonitorModel fJobMonitorModel;
    private JMenuItem fCancelJobMenuItem;
    private JMenuItem fDeleteJobMenuItem;
    private MJAbstractAction fDeleteAction;
    private JMenuItem fShowJobDetailsMenuItem;
    private JMenuItem fShowErrorMessageMenuItem;
    private JMenuItem fShowDiaryMenuItem;
    private JMenuItem fCloseMatlabPoolMenuItem;
    private JMenuItem fFetchOutputsMenuItem;
    private JMenuItem fLoadVariableMenuItem;
    private JCheckBox fShowJobsFromAllUsers;
    private ProfileSelector fProfileSelector;
    private JLabel fSelectProfileLabel;
    private DefaultOverlayable fOverlayTableScrollPane;
    private JobMonitorTableModel fJobMonitorTableModel;
    private SortableTable fJobsTable;
    private UpdatePanel fUpdatePanel;
    private MJMultilineLabel fErrorMessageLabel;
    private boolean fPopupMenuVisible = false;
    private AtomicBoolean fIsUpdating = new AtomicBoolean(false);
    private static final ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.toolbox.distcomp.ui.resources.RES_ui");
    private static final String DELETE_ACTION_KEY = "delete";
    private static final Color COLOR_CORRUPTED_SELECTED = Color.getHSBColor(0.0f, 0.0f, 0.8f);
    private static final Color COLOR_CORRUPTED = Color.GRAY;
    private static final String HTML_TAG_BR = "<br/>";

    public JobMonitorUI(ProfileManager profileManager) {
        this(profileManager, ColumnInfo.values());
    }

    public JobMonitorUI(ProfileManager profileManager, ColumnInfo[] columnInfoArray) {
        this.fJobMonitorModel = new JobMonitorModel();
        this.createSelectProfileSection(profileManager);
        this.createJobsTableSection(columnInfoArray);
        this.createUpdatePanelSection(profileManager);
        this.addLine((JComponent[][])new JComponent[][]{{this.fSelectProfileLabel, this.fProfileSelector.getComponent(), this.fShowJobsFromAllUsers}}, 0, 1);
        this.addLine((JComponent)this.fOverlayTableScrollPane, 8);
        this.addLine(this.fUpdatePanel.getComponent());
        this.addListeners();
        this.fShowJobsFromAllUsers.setName("ShowAllUserJobsCheckbox");
        this.fJobsTable.setName("JobsTable");
        this.fCancelJobMenuItem.setName("CancelJobMenuItem");
        this.fDeleteJobMenuItem.setName("DeleteJobMenuItem");
        this.fShowJobDetailsMenuItem.setName("ShowJobDetailsMenuItem");
        this.fShowErrorMessageMenuItem.setName("ShowErrorMessageMenuItem");
        this.fErrorMessageLabel.setName("JobsTableErrorMessage");
        this.fShowDiaryMenuItem.setName("ShowDiaryMenuItem");
        this.fCloseMatlabPoolMenuItem.setName("CloseMatlabPoolMenuItem");
        this.fFetchOutputsMenuItem.setName("FetchOutputsMenuItem");
        this.fLoadVariableMenuItem.setName("LoadVariableMenuItem");
        this.setName("JobMonitorUI");
    }

    private void addListeners() {
        this.fJobMonitorModel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                JobMonitorUI.this.doPropertyChange(propertyChangeEvent);
            }
        });
        this.fJobMonitorModel.addUpdateChangeListener(new UpdateChangeListener(){

            @Override
            public void updateStarted() {
                JobMonitorUI.this.doUpdateStarted();
            }

            @Override
            public void updateFinished() {
                JobMonitorUI.this.doUpdateFinished();
            }

            @Override
            public void updateCanceled() {
                JobMonitorUI.this.doUpdateCanceled();
            }
        });
    }

    private void createSelectProfileSection(ProfileManager profileManager) {
        this.fProfileSelector = new ProfileSelector(profileManager, this.fJobMonitorModel.getProfileSelection());
        this.fShowJobsFromAllUsers = new MJCheckBox(sRes.getString("jobmonitor.showall.checkbox"));
        this.fShowJobsFromAllUsers.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JobMonitorUI.this.fJobMonitorModel.setShowJobsFromAllUser(JobMonitorUI.this.fShowJobsFromAllUsers.isSelected());
            }
        });
        this.fSelectProfileLabel = new MJLabel(sRes.getString("jobmonitor.selectprofile.label"));
    }

    private void createUpdatePanelSection(ProfileManager profileManager) {
        boolean bl = profileManager.isInitialized();
        this.fUpdatePanel = new UpdatePanel(new Runnable(){

            @Override
            public void run() {
                JobMonitorUI.this.fJobMonitorModel.update();
            }
        }, bl);
        if (!bl) {
            profileManager.addPropertyChangeListener("Initialized", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    JobMonitorUI.this.fUpdatePanel.setUpdateFrequencyDefaultAndRefreshComboBox();
                    JobMonitorUI.this.fUpdatePanel.setEnabled(true);
                }
            });
        }
        this.fJobMonitorModel.addUpdateChangeListener(this.fUpdatePanel);
    }

    private String getRowCorruptedMessage(JobMonitorTableModel jobMonitorTableModel, int n) {
        JobCorruptionInfo[] jobCorruptionInfoArray = jobMonitorTableModel.getCorruptionInfo(n);
        if (jobCorruptionInfoArray.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(HTML_TAG_BR);
        HashMap hashMap = new HashMap();
        for (JobCorruptionInfo jobCorruptionInfo : jobCorruptionInfoArray) {
            List<String> list;
            if (hashMap.containsKey(jobCorruptionInfo.getMessage())) {
                list = (List)hashMap.get(jobCorruptionInfo.getMessage());
            } else {
                list = new ArrayList();
                hashMap.put(jobCorruptionInfo.getMessage(), list);
            }
            list.add(sRes.getString(jobCorruptionInfo.getLevel().getMessageKey()));
        }
        for (String string : hashMap.keySet()) {
            stringBuilder.append(MessageFormat.format(sRes.getString("jobmonitor.statuscolumn.tooltip.error"), StringUtils.join((Collection)((Collection)hashMap.get(string)), (String)", "), string));
        }
        return stringBuilder.toString();
    }

    private void createJobsTableSection(ColumnInfo[] columnInfoArray) {
        this.fJobMonitorTableModel = new JobMonitorTableModel();
        JobMonitorTableCellRenderer jobMonitorTableCellRenderer = new JobMonitorTableCellRenderer();
        this.fJobsTable = new SortableTable(this.fJobMonitorTableModel){

            public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
                Component component = super.prepareRenderer(tableCellRenderer, n, n2);
                if (n != -1) {
                    int n3 = JobMonitorUI.this.fJobsTable.getActualRowAt(n);
                    JobStateModel jobStateModel = (JobStateModel)JobMonitorUI.this.fJobMonitorTableModel.getValueAt(n3, ColumnInfo.STATE.getColumnIndex());
                    String string = MessageFormat.format(sRes.getString("jobmonitor.statuscolumn.tooltip"), JobMonitorUI.this.fJobMonitorTableModel.getValueAt(n3, ColumnInfo.ID.getColumnIndex()), jobStateModel.getFinishedTasksNoError(), jobStateModel.getFinishedTasksWithError(), jobStateModel.getRunningTasks(), jobStateModel.getPendingTasks(), JobMonitorUI.this.getRowCorruptedMessage(JobMonitorUI.this.fJobMonitorTableModel, n3));
                    if (component instanceof JComponent) {
                        JComponent jComponent = (JComponent)component;
                        jComponent.setToolTipText(JobMonitorUI.this.fPopupMenuVisible ? null : string);
                    }
                }
                return component;
            }
        };
        this.fJobsTable.setRowHeight(20);
        this.fJobsTable.setDefaultCellRenderer((TableCellRenderer)jobMonitorTableCellRenderer);
        TableColumnModel tableColumnModel = this.fJobsTable.getColumnModel();
        ArrayList<TableColumn> arrayList = new ArrayList<TableColumn>();
        for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            boolean bl = false;
            for (ColumnInfo columnInfo : columnInfoArray) {
                bl = bl || columnInfo.getColumnTitle().equals(tableColumn.getHeaderValue());
            }
            if (bl) continue;
            arrayList.add(tableColumn);
        }
        for (TableColumn tableColumn : arrayList) {
            tableColumnModel.removeColumn(tableColumn);
        }
        this.fJobsTable.setCellRendererManagerEnabled(false);
        this.fJobsTable.setCellEditorManagerEnabled(false);
        this.fJobsTable.setMultiColumnSortable(false);
        this.fJobsTable.setShowSortOrderNumber(false);
        this.fJobsTable.setSelectionMode(2);
        this.fJobsTable.setLoadSelectionOnTableDataChanged(true);
        MJScrollPane mJScrollPane = new MJScrollPane((Component)this.fJobsTable);
        mJScrollPane.getViewport().setBackground(Color.WHITE);
        mJScrollPane.setPreferredSize(new Dimension((int)this.fJobsTable.getPreferredSize().getWidth(), (int)this.fJobsTable.getPreferredSize().getHeight() + (int)this.fJobsTable.getTableHeader().getPreferredSize().getHeight() + 4));
        this.fErrorMessageLabel = new MJMultilineLabel(sRes.getString("jobmonitor.jobtable.startnowmsg"), true);
        this.fErrorMessageLabel.setBackground(Color.WHITE);
        this.fErrorMessageLabel.setFont(this.fErrorMessageLabel.getFont().deriveFont(2));
        this.fErrorMessageLabel.addComponentListener((ComponentListener)new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                JobMonitorUI.this.resizeErrorMessageLabel();
            }

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
                JobMonitorUI.this.resizeErrorMessageLabel();
            }

            @Override
            public void componentShown(ComponentEvent componentEvent) {
                JobMonitorUI.this.resizeErrorMessageLabel();
            }
        });
        this.fOverlayTableScrollPane = new DefaultOverlayable((JComponent)mJScrollPane);
        this.fOverlayTableScrollPane.addOverlayComponent((JComponent)this.fErrorMessageLabel);
        this.fOverlayTableScrollPane.setOverlayVisible(true);
        this.createRightClickMenu();
    }

    private void resizeErrorMessageLabel() {
        FontMetrics fontMetrics = this.fErrorMessageLabel.getFontMetrics(this.fErrorMessageLabel.getFont());
        int n = fontMetrics.stringWidth(this.fErrorMessageLabel.getText()) + 10;
        int n2 = this.fOverlayTableScrollPane.getWidth() - 50;
        this.fErrorMessageLabel.setMaxWidth(Math.min(n, n2));
    }

    private void createRightClickMenu() {
        this.fCancelJobMenuItem = new MJMenuItem((Action)new MJAbstractAction(sRes.getString("jobmonitor.canel.menuitem")){

            public void actionPerformed(ActionEvent actionEvent) {
                List list = JobMonitorUI.this.getSelectedJobTableRows();
                JobMonitorUI.this.fJobMonitorModel.cancelJob(list);
            }
        });
        this.fDeleteAction = new MJAbstractAction(sRes.getString("jobmonitor.delete.menuitem")){

            public void actionPerformed(ActionEvent actionEvent) {
                List list = JobMonitorUI.this.getSelectedJobTableRows();
                JobMonitorUI.this.fJobMonitorModel.deleteJob(list);
            }
        };
        this.fDeleteJobMenuItem = new MJMenuItem((Action)this.fDeleteAction);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(127, 0);
        this.fJobsTable.getInputMap().put(keyStroke, DELETE_ACTION_KEY);
        this.fJobsTable.getActionMap().put(DELETE_ACTION_KEY, (Action)this.fDeleteAction);
        this.fShowJobDetailsMenuItem = new MJMenuItem((Action)new MJAbstractAction(sRes.getString("jobmonitor.showjobdetails.menuitem")){

            public void actionPerformed(ActionEvent actionEvent) {
                List list = JobMonitorUI.this.getSelectedJobTableRows();
                JobMonitorUI.this.fJobMonitorModel.showJobDetails((JobTableRowModel)list.get(0));
            }
        });
        this.fShowErrorMessageMenuItem = new MJMenuItem((Action)new MJAbstractAction(sRes.getString("jobmonitor.showerrors.menuitem")){

            public void actionPerformed(ActionEvent actionEvent) {
                List list = JobMonitorUI.this.getSelectedJobTableRows();
                JobMonitorUI.this.fJobMonitorModel.showErroredTasksInJob((JobTableRowModel)list.get(0));
            }
        });
        this.fShowDiaryMenuItem = new MJMenuItem((Action)new MJAbstractAction(sRes.getString("jobmonitor.showdiary.menuitem")){

            public void actionPerformed(ActionEvent actionEvent) {
                List list = JobMonitorUI.this.getSelectedJobTableRows();
                JobMonitorUI.this.fJobMonitorModel.showDiary((JobTableRowModel)list.get(0));
            }
        });
        this.fCloseMatlabPoolMenuItem = new MJMenuItem((Action)new MJAbstractAction(sRes.getString("jobmonitor.shutdownpool.menuitem")){

            public void actionPerformed(ActionEvent actionEvent) {
                JobMonitorUI.this.fJobMonitorModel.closeMATLABPool();
            }
        });
        this.fFetchOutputsMenuItem = new MJMenuItem((Action)new MJAbstractAction(sRes.getString("jobmonitor.fetchoutputs.menuitem")){

            public void actionPerformed(ActionEvent actionEvent) {
                List list = JobMonitorUI.this.getSelectedJobTableRows();
                JobMonitorUI.this.fJobMonitorModel.fetchOutput((JobTableRowModel)list.get(0));
            }
        });
        this.fLoadVariableMenuItem = new MJMenuItem((Action)new MJAbstractAction(sRes.getString("jobmonitor.loadvariables.menuitem")){

            public void actionPerformed(ActionEvent actionEvent) {
                List list = JobMonitorUI.this.getSelectedJobTableRows();
                JobMonitorUI.this.fJobMonitorModel.loadVariables((JobTableRowModel)list.get(0));
            }
        });
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                this.showPopup(mouseEvent);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                this.showPopup(mouseEvent);
            }

            private void showPopup(MouseEvent mouseEvent) {
                if (!mouseEvent.isPopupTrigger()) {
                    return;
                }
                int n = JobMonitorUI.this.fJobsTable.rowAtPoint(mouseEvent.getPoint());
                int n2 = JobMonitorUI.this.fJobsTable.getActualRowAt(n);
                int[] nArray = JobMonitorUI.this.fJobsTable.getSelectedRows();
                boolean bl = false;
                for (int n3 : nArray) {
                    bl = bl || JobMonitorUI.this.fJobsTable.getActualRowAt(n3) == n2;
                }
                if (n2 != -1 && !bl) {
                    int n4 = JobMonitorUI.this.fJobsTable.getSortedRowAt(n2);
                    JobMonitorUI.this.fJobsTable.setRowSelectionInterval(n4, n4);
                }
                Object object = JobMonitorUI.this.generateRightClickMenu();
                ((JPopupMenu)object).show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        };
        this.fJobsTable.addMouseListener((MouseListener)mouseAdapter);
        this.fJobsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                int n = JobMonitorUI.this.fJobsTable.getActualRowAt(JobMonitorUI.this.fJobsTable.getSelectedRow());
                if (n == -1) {
                    return;
                }
                JobMonitorUI.this.updateRightClickMenuItems();
            }
        });
    }

    private JPopupMenu generateRightClickMenu() {
        MJPopupMenu mJPopupMenu = new MJPopupMenu(){

            public void setVisible(boolean bl) {
                super.setVisible(bl);
                JobMonitorUI.this.fPopupMenuVisible = bl;
            }
        };
        if (this.getSelectedJobTableRows().size() > 1) {
            mJPopupMenu.add(this.fDeleteJobMenuItem);
            return mJPopupMenu;
        }
        JobType jobType = this.getSelectedJobTableRows().get(0).getJobType();
        if (jobType == null) {
            jobType = JobType.UNKNOWN;
        }
        switch (jobType) {
            case BATCH_JOB_ON_SCRIPT: {
                mJPopupMenu.add(this.fCancelJobMenuItem);
                mJPopupMenu.add(this.fDeleteJobMenuItem);
                mJPopupMenu.addSeparator();
                mJPopupMenu.add(this.fShowJobDetailsMenuItem);
                mJPopupMenu.add(this.fShowErrorMessageMenuItem);
                mJPopupMenu.add(this.fShowDiaryMenuItem);
                mJPopupMenu.addSeparator();
                mJPopupMenu.add(this.fLoadVariableMenuItem);
                break;
            }
            case BATCH_JOB_ON_FUNCTION: {
                mJPopupMenu.add(this.fCancelJobMenuItem);
                mJPopupMenu.add(this.fDeleteJobMenuItem);
                mJPopupMenu.addSeparator();
                mJPopupMenu.add(this.fShowJobDetailsMenuItem);
                mJPopupMenu.add(this.fShowErrorMessageMenuItem);
                mJPopupMenu.add(this.fShowDiaryMenuItem);
                mJPopupMenu.addSeparator();
                mJPopupMenu.add(this.fFetchOutputsMenuItem);
                break;
            }
            case MATLABPOOL: 
            case CURRENT_INTERACTIVE_MATLABPOOL: {
                mJPopupMenu.add(this.fCloseMatlabPoolMenuItem);
                mJPopupMenu.add(this.fDeleteJobMenuItem);
                break;
            }
            default: {
                mJPopupMenu.add(this.fCancelJobMenuItem);
                mJPopupMenu.add(this.fDeleteJobMenuItem);
                mJPopupMenu.addSeparator();
                mJPopupMenu.add(this.fShowJobDetailsMenuItem);
                mJPopupMenu.add(this.fShowErrorMessageMenuItem);
                mJPopupMenu.addSeparator();
                mJPopupMenu.add(this.fFetchOutputsMenuItem);
            }
        }
        return mJPopupMenu;
    }

    private void updateRightClickMenuItems() {
        this.updateCancelMenuItem();
        this.updateDeleteMenuItem();
        this.updateCloseMatlabPoolMenuItem();
        this.updateShowDiaryMenuItem();
        this.updateShowJobDetailsMenuItem();
        this.updateShowErrorMessageMenuItem();
        this.updateLoadVariablesMenuItem();
        this.updateFetchOutputsMenuItem();
    }

    private void updateFetchOutputsMenuItem() {
        List<JobTableRowModel> list = this.getSelectedJobTableRows();
        boolean bl = !this.fIsUpdating.get() && list.size() == 1 && list.get(0).getJobStateModel().isFinished() && !list.get(0).getJobStateModel().hasErrors();
        this.fFetchOutputsMenuItem.setEnabled(bl);
    }

    private void updateLoadVariablesMenuItem() {
        List<JobTableRowModel> list = this.getSelectedJobTableRows();
        boolean bl = !this.fIsUpdating.get() && list.size() == 1 && list.get(0).getJobStateModel().isFinished() && !list.get(0).getJobStateModel().hasErrors();
        this.fLoadVariableMenuItem.setEnabled(bl);
    }

    private void updateShowErrorMessageMenuItem() {
        List<JobTableRowModel> list = this.getSelectedJobTableRows();
        boolean bl = !this.fIsUpdating.get() && list.size() == 1 && list.get(0).getJobStateModel().hasErrors();
        this.fShowErrorMessageMenuItem.setEnabled(bl);
    }

    private void updateShowJobDetailsMenuItem() {
        List<JobTableRowModel> list = this.getSelectedJobTableRows();
        boolean bl = !this.fIsUpdating.get() && list.size() == 1;
        this.fShowJobDetailsMenuItem.setEnabled(bl);
    }

    private void updateShowDiaryMenuItem() {
        List<JobTableRowModel> list = this.getSelectedJobTableRows();
        boolean bl = !this.fIsUpdating.get() && list.size() == 1 && (list.get(0).getJobStateModel().isRunning() || list.get(0).getJobStateModel().isDone());
        this.fShowDiaryMenuItem.setEnabled(bl);
    }

    private void updateCloseMatlabPoolMenuItem() {
        List<JobTableRowModel> list = this.getSelectedJobTableRows();
        boolean bl = !this.fIsUpdating.get() && list.size() == 1 && JobType.CURRENT_INTERACTIVE_MATLABPOOL.equals((Object)list.get(0).getJobType());
        this.fCloseMatlabPoolMenuItem.setEnabled(bl);
    }

    private void updateDeleteMenuItem() {
        boolean bl = this.fIsUpdating.get();
        boolean bl2 = !bl;
        this.fDeleteAction.setEnabled(bl2);
    }

    private void updateCancelMenuItem() {
        List<JobTableRowModel> list = this.getSelectedJobTableRows();
        boolean bl = !this.fIsUpdating.get() && list.size() == 1 && list.get(0).getJobStateModel().isRunning();
        this.fCancelJobMenuItem.setEnabled(bl);
    }

    private List<JobTableRowModel> getSelectedJobTableRows() {
        ArrayList<JobTableRowModel> arrayList = new ArrayList<JobTableRowModel>();
        int[] nArray = this.fJobsTable.getSelectedRows();
        if (nArray != null) {
            List<JobTableRowModel> list = this.fJobMonitorModel.isShowJobsFromAllUser() ? this.fJobMonitorModel.getAllUsersJobTableRows() : this.fJobMonitorModel.getIndividualUserJobTableRows();
            for (int n : nArray) {
                int n2 = this.fJobsTable.getActualRowAt(n);
                JobTableRowModel jobTableRowModel = list.get(n2);
                arrayList.add(jobTableRowModel);
            }
        }
        return arrayList;
    }

    private void doPropertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("AllUsersJobTableRowsChanged")) {
            if (this.fJobMonitorModel.isShowJobsFromAllUser()) {
                List<JobTableRowModel> list = this.fJobMonitorModel.getAllUsersJobTableRows();
                this.fJobMonitorTableModel.updateTableData(list);
            }
        } else if (propertyChangeEvent.getPropertyName().equals("IndividualUserTableRowsChanged")) {
            if (!this.fJobMonitorModel.isShowJobsFromAllUser()) {
                List<JobTableRowModel> list = this.fJobMonitorModel.getIndividualUserJobTableRows();
                this.fJobMonitorTableModel.updateTableData(list);
            }
        } else if (propertyChangeEvent.getPropertyName().equals("ShowJobsFromAllUserChanged")) {
            this.fShowJobsFromAllUsers.setSelected(this.fJobMonitorModel.isShowJobsFromAllUser());
            List<JobTableRowModel> list = this.fJobMonitorModel.isShowJobsFromAllUser() ? this.fJobMonitorModel.getAllUsersJobTableRows() : this.fJobMonitorModel.getIndividualUserJobTableRows();
            this.fJobMonitorTableModel.updateTableData(list);
        } else if (propertyChangeEvent.getPropertyName().equals("CancelJobErrored")) {
            String string = (String)propertyChangeEvent.getNewValue();
            String string2 = MessageFormat.format(sRes.getString("jobmonitor.errordialog.canceljob"), string);
            JobMonitorUI.showErrorDialog(string2);
        } else if (propertyChangeEvent.getPropertyName().equals("DeleteJobErrored")) {
            String string = (String)propertyChangeEvent.getNewValue();
            String string3 = MessageFormat.format(sRes.getString("jobmonitor.errordialog.destroyjob"), string);
            JobMonitorUI.showErrorDialog(string3);
        } else if (propertyChangeEvent.getPropertyName().equals("ShowJobDetailsErrored")) {
            String string = (String)propertyChangeEvent.getNewValue();
            String string4 = MessageFormat.format(sRes.getString("jobmonitor.errordialog.showjobdetails"), string);
            JobMonitorUI.showErrorDialog(string4);
        } else if (propertyChangeEvent.getPropertyName().equals("ShowErroredTasksErrored")) {
            String string = (String)propertyChangeEvent.getNewValue();
            String string5 = MessageFormat.format(sRes.getString("jobmonitor.errordialog.showerrors"), string);
            JobMonitorUI.showErrorDialog(string5);
        } else if (propertyChangeEvent.getPropertyName().equals("FetchOutputsErrored")) {
            String string = (String)propertyChangeEvent.getNewValue();
            String string6 = MessageFormat.format(sRes.getString("jobmonitor.errordialog.fetchoutputs"), string);
            JobMonitorUI.showErrorDialog(string6);
        } else if (propertyChangeEvent.getPropertyName().equals("LoadVariablesErrored")) {
            String string = (String)propertyChangeEvent.getNewValue();
            String string7 = MessageFormat.format(sRes.getString("jobmonitor.errordialog.loadvariables"), string);
            JobMonitorUI.showErrorDialog(string7);
        } else if (propertyChangeEvent.getPropertyName().equals("ShowDiaryErrored")) {
            String string = (String)propertyChangeEvent.getNewValue();
            String string8 = MessageFormat.format(sRes.getString("jobmonitor.errordialog.showdiary"), string);
            JobMonitorUI.showErrorDialog(string8);
        } else if (propertyChangeEvent.getPropertyName().equals("CloseMATLABPoolErrored")) {
            String string = (String)propertyChangeEvent.getNewValue();
            String string9 = MessageFormat.format(sRes.getString("jobmonitor.errordialog.shutdownpool"), string);
            JobMonitorUI.showErrorDialog(string9);
        } else if (propertyChangeEvent.getPropertyName().equals("MatlabError")) {
            String string = (String)propertyChangeEvent.getNewValue();
            String string10 = MessageFormat.format(sRes.getString("jobmonitor.errordialog.update"), string);
            this.fErrorMessageLabel.setText(string10);
            this.resizeErrorMessageLabel();
            this.fOverlayTableScrollPane.setOverlayVisible(true);
            this.fOverlayTableScrollPane.setBounds(this.fOverlayTableScrollPane.getBounds());
        } else if (propertyChangeEvent.getPropertyName().equals("UpdateAborted")) {
            this.stopAutoUpdating();
        }
    }

    private static void showErrorDialog(final String string) {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(null, string, sRes.getString("jobmonitor.errordialog.title"), 0);
            }
        });
        thread.setDaemon(true);
        thread.start();
    }

    public void startAutoUpdating() {
        this.fUpdatePanel.startAutoUpdating();
    }

    public void stopAutoUpdating() {
        this.fUpdatePanel.stopAutoUpdating();
    }

    private void doUpdateStarted() {
        this.fIsUpdating.set(true);
        if (SwingUtilities.isEventDispatchThread()) {
            this.updateForStarted();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JobMonitorUI.this.updateForStarted();
                }
            });
        }
    }

    private void doUpdateFinished() {
        this.fIsUpdating.set(false);
        if (SwingUtilities.isEventDispatchThread()) {
            this.doUpdateDone();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JobMonitorUI.this.doUpdateDone();
                }
            });
        }
    }

    private void doUpdateCanceled() {
        this.fIsUpdating.set(false);
        if (SwingUtilities.isEventDispatchThread()) {
            this.doUpdateDone();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JobMonitorUI.this.doUpdateDone();
                }
            });
        }
    }

    private void updateForStarted() {
        this.fErrorMessageLabel.setText("");
        this.fOverlayTableScrollPane.setOverlayVisible(false);
        this.updateRightClickMenuItems();
    }

    private void doUpdateDone() {
        this.updateRightClickMenuItems();
    }

    public void updateProfile(String string) {
        if (this.fProfileSelector.getSelectedProfile().equals(string)) {
            this.fJobMonitorModel.update();
        } else {
            this.fProfileSelector.setSelectedProfile(string);
        }
    }

    private static class JobMonitorTableCellRenderer
    extends DefaultTableCellRenderer {
        private JobMonitorTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            int n3;
            JobMonitorTableModel jobMonitorTableModel = (JobMonitorTableModel)((TableModelWrapper)jTable.getModel()).getActualModel();
            JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            jLabel.setIcon(null);
            jLabel.setForeground(bl ? SystemColor.textHighlightText : SystemColor.windowText);
            if (n2 == ColumnInfo.STATE.getColumnIndex()) {
                if (object != null) {
                    JobStateModel jobStateModel = (JobStateModel)object;
                    jLabel.setText(jobStateModel.getState());
                    jLabel.setIcon(this.getLabelIcon(jTable, jobMonitorTableModel, jobStateModel, n, bl, jLabel));
                } else {
                    jLabel.setText(null);
                }
            } else if (n != -1 && !jobMonitorTableModel.isHealthy(n3 = ((SortableTable)jTable).getActualRowAt(n))) {
                jLabel.setForeground(bl ? COLOR_CORRUPTED_SELECTED : COLOR_CORRUPTED);
            }
            return jLabel;
        }

        private Icon getLabelIcon(JTable jTable, JobMonitorTableModel jobMonitorTableModel, JobStateModel jobStateModel, int n, boolean bl, JLabel jLabel) {
            if (!jobMonitorTableModel.hasAnyErrors()) {
                return null;
            }
            if (jobStateModel.hasErrors()) {
                return DialogIcon.ERROR.getIcon();
            }
            int n2 = ((SortableTable)jTable).getActualRowAt(n);
            if (!jobMonitorTableModel.isHealthy(n2)) {
                jLabel.setForeground(bl ? COLOR_CORRUPTED_SELECTED : COLOR_CORRUPTED);
                if (jobMonitorTableModel.isCorruptedWith(n2, JobCorruptionLevel.CANNOT_PROVIDE_TYPE, JobCorruptionLevel.CANNOT_PROVIDE_PROPERTIES, JobCorruptionLevel.CANNOT_PROVIDE_ERRORED_TASK_INFORMATION)) {
                    return DialogIcon.WARNING.getIcon();
                }
            }
            return ParallelIcon.BLANK.getIcon();
        }
    }
}

