/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.ui.jobmonitor;

import com.mathworks.jmi.MatlabWorker;
import com.mathworks.toolbox.distcomp.ui.PackageInfo;
import com.mathworks.toolbox.distcomp.ui.UpdateChangeListener;
import com.mathworks.toolbox.distcomp.ui.UpdateChangeSupport;
import com.mathworks.toolbox.distcomp.ui.jobmonitor.JobTableRowModel;
import com.mathworks.toolbox.distcomp.ui.model.Selection;
import com.mathworks.toolbox.distcomp.ui.model.SelectionEvent;
import com.mathworks.toolbox.distcomp.ui.model.SelectionListener;
import com.mathworks.toolbox.distcomp.ui.profile.model.Profile;
import com.mathworks.toolbox.parallel.pctutil.logging.DistcompLevel;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.SwingUtilities;

final class JobMonitorModel {
    private final Selection<Profile> fProfileSelection = new Selection<Object>(null);
    private boolean fShowJobsFromAllUser = false;
    private List<JobTableRowModel> fAllUsersJobTableRows;
    private List<JobTableRowModel> fIndividualUserJobTableRows;
    private PropertyChangeSupport fPropertyChangeSupport = new PropertyChangeSupport(this);
    public static final String SHOW_JOBS_FROM_ALL_USER_CHANGED_PROPERTY = "ShowJobsFromAllUserChanged";
    public static final String ALL_USERS_JOB_TABLE_ROWS_CHANGED_PROPERTY = "AllUsersJobTableRowsChanged";
    public static final String INDIVIDUAL_USER_JOB_TABLE_ROWS_CHANGED_PROPERTY = "IndividualUserTableRowsChanged";
    public static final String CANCEL_JOB_ERRORED = "CancelJobErrored";
    public static final String DELETE_JOB_ERRORED = "DeleteJobErrored";
    public static final String SHOW_JOB_DETAILS_ERRORED = "ShowJobDetailsErrored";
    public static final String SHOW_ERRORED_TASKS_ERRORED = "ShowErroredTasksErrored";
    public static final String LOAD_VARIABLES_ERRORED = "LoadVariablesErrored";
    public static final String FETCH_OUTPUTS_ERRORED = "FetchOutputsErrored";
    public static final String SHOW_DIARY_ERRORED = "ShowDiaryErrored";
    public static final String CLOSE_MATLAB_POOL_ERRORED = "CloseMATLABPoolErrored";
    public static final String MATLAB_ERROR = "MatlabError";
    public static final String UPDATE_ABORTED = "UpdateAborted";
    private UpdateChangeSupport fUpdateChangeSupport = new UpdateChangeSupport();
    private static final String JOB_MONITOR_HELPER_FCN = "parallel.internal.ui.jobMonitorHelper";
    private static final String UPDATE_OPTION = "update";
    private static final String CANCEL_JOB_OPTION = "cancelJob";
    private static final String DELETE_JOB_OPTION = "deleteJob";
    private static final String SHOW_JOB_DETAILS_OPTION = "showJobDetails";
    private static final String SHOW_ERRORED_TASKS_IN_JOB_OPTION = "showErroredTasksInJob";
    private static final String LOAD_VARIABLES_OPTION = "loadVariables";
    private static final String FETCH_OUTPUTS_OPTION = "fetchOutputs";
    private static final String SHOW_DIARY_OPTION = "showDiary";
    private static final String CLOSE_MATLAB_POOL_OPTION = "closeMATLABPool";
    private static final String MATLAB_INTERRUPTED_ERROR_MSG = "InterruptException(ctrl-c)";
    private static final String ABORT_BY_USER_ERROR_ID = "parallel:cluster:mjs.NoCredentialsEntered";
    private static final int NARGOUT_UPDATE_OPTION = 4;

    JobMonitorModel() {
        this.fAllUsersJobTableRows = new ArrayList<JobTableRowModel>();
        this.fIndividualUserJobTableRows = new ArrayList<JobTableRowModel>();
        this.fProfileSelection.addSelectionListener(new SelectionListener<Profile>(){

            @Override
            public void selectionChanged(SelectionEvent<Profile> selectionEvent) {
                JobMonitorModel.this.update();
            }
        });
    }

    List<JobTableRowModel> getAllUsersJobTableRows() {
        return Collections.unmodifiableList(this.fAllUsersJobTableRows);
    }

    void setAllUsersJobTableRows(List<JobTableRowModel> list) {
        List<JobTableRowModel> list2 = this.fAllUsersJobTableRows;
        this.fAllUsersJobTableRows = list;
        this.fPropertyChangeSupport.firePropertyChange(ALL_USERS_JOB_TABLE_ROWS_CHANGED_PROPERTY, list2, this.fAllUsersJobTableRows);
    }

    List<JobTableRowModel> getIndividualUserJobTableRows() {
        return Collections.unmodifiableList(this.fIndividualUserJobTableRows);
    }

    void setIndividualUserJobTableRows(List<JobTableRowModel> list) {
        List<JobTableRowModel> list2 = this.fIndividualUserJobTableRows;
        this.fIndividualUserJobTableRows = list;
        this.fPropertyChangeSupport.firePropertyChange(INDIVIDUAL_USER_JOB_TABLE_ROWS_CHANGED_PROPERTY, list2, this.fIndividualUserJobTableRows);
    }

    boolean isShowJobsFromAllUser() {
        return this.fShowJobsFromAllUser;
    }

    void setShowJobsFromAllUser(boolean bl) {
        boolean bl2 = this.fShowJobsFromAllUser;
        this.fShowJobsFromAllUser = bl;
        this.fPropertyChangeSupport.firePropertyChange(SHOW_JOBS_FROM_ALL_USER_CHANGED_PROPERTY, bl2, this.fShowJobsFromAllUser);
    }

    Selection<Profile> getProfileSelection() {
        return this.fProfileSelection;
    }

    private String getSelectedProfileName() {
        return this.fProfileSelection.getSelection().getName();
    }

    void update() {
        this.fUpdateChangeSupport.fireUpdateStarted();
        new MatlabWorker(){

            public Object runOnMatlabThread() throws Exception {
                PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Job Monitor: RunOnMatlabThread in update()");
                return 2.feval((String)JobMonitorModel.JOB_MONITOR_HELPER_FCN, (Object[])new Object[]{JobMonitorModel.UPDATE_OPTION, JobMonitorModel.this.getSelectedProfileName()}, (int)4, (boolean)false);
            }

            public void runOnAWTEventDispatchThread(Object object) {
                PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Job Monitor: RunOnEdtThread in update()");
                List list = (List)((Object[])object)[0];
                List list2 = (List)((Object[])object)[1];
                String string = (String)((Object[])object)[2];
                String string2 = (String)((Object[])object)[3];
                JobMonitorModel.this.setAllUsersJobTableRows(list);
                JobMonitorModel.this.setIndividualUserJobTableRows(list2);
                if (string.length() > 0) {
                    JobMonitorModel.this.fPropertyChangeSupport.firePropertyChange(JobMonitorModel.MATLAB_ERROR, null, string);
                }
                if (string2.length() > 0 && string2.equals(JobMonitorModel.ABORT_BY_USER_ERROR_ID)) {
                    JobMonitorModel.this.fPropertyChangeSupport.firePropertyChange(JobMonitorModel.UPDATE_ABORTED, false, true);
                    JobMonitorModel.this.fUpdateChangeSupport.fireUpdateCanceled();
                } else {
                    JobMonitorModel.this.fUpdateChangeSupport.fireUpdateFinished();
                }
            }

            protected void handleException(Exception exception, boolean bl) {
                if (bl && exception.getMessage() != null && exception.getMessage().equals(JobMonitorModel.MATLAB_INTERRUPTED_ERROR_MSG)) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            JobMonitorModel.this.fUpdateChangeSupport.fireUpdateCanceled();
                        }
                    });
                } else {
                    super.handleException(exception, bl);
                    JobMonitorModel.this.fUpdateChangeSupport.fireUpdateFinished();
                }
            }
        }.start();
    }

    void cancelJob(List<JobTableRowModel> list) {
        int[] nArray = JobMonitorModel.getJobIds(list);
        this.runMLCodeWithErrorHandling(CANCEL_JOB_OPTION, new Object[]{this.getSelectedProfileName(), nArray}, false, CANCEL_JOB_ERRORED, true);
    }

    private static int[] getJobIds(List<JobTableRowModel> list) {
        int[] nArray = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            nArray[i] = list.get(i).getJobID();
        }
        return nArray;
    }

    void deleteJob(List<JobTableRowModel> list) {
        int[] nArray = JobMonitorModel.getJobIds(list);
        this.runMLCodeWithErrorHandling(DELETE_JOB_OPTION, new Object[]{this.getSelectedProfileName(), nArray}, false, DELETE_JOB_ERRORED, true);
    }

    void showJobDetails(JobTableRowModel jobTableRowModel) {
        this.runMLCodeWithErrorHandling(SHOW_JOB_DETAILS_OPTION, new Object[]{this.getSelectedProfileName(), jobTableRowModel.getJobID()}, true, SHOW_JOB_DETAILS_ERRORED, false);
    }

    void showErroredTasksInJob(JobTableRowModel jobTableRowModel) {
        this.runMLCodeWithErrorHandling(SHOW_ERRORED_TASKS_IN_JOB_OPTION, new Object[]{this.getSelectedProfileName(), jobTableRowModel.getJobID(), jobTableRowModel.getJobStateModel().getErroredTaskIDs()}, true, SHOW_ERRORED_TASKS_ERRORED, false);
    }

    void fetchOutput(JobTableRowModel jobTableRowModel) {
        this.runMLCodeWithErrorHandling(FETCH_OUTPUTS_OPTION, new Object[]{this.getSelectedProfileName(), jobTableRowModel.getJobID()}, true, FETCH_OUTPUTS_ERRORED, false);
    }

    void loadVariables(JobTableRowModel jobTableRowModel) {
        this.runMLCodeWithErrorHandling(LOAD_VARIABLES_OPTION, new Object[]{this.getSelectedProfileName(), jobTableRowModel.getJobID()}, true, LOAD_VARIABLES_ERRORED, false);
    }

    void showDiary(JobTableRowModel jobTableRowModel) {
        this.runMLCodeWithErrorHandling(SHOW_DIARY_OPTION, new Object[]{this.getSelectedProfileName(), jobTableRowModel.getJobID()}, true, SHOW_DIARY_ERRORED, false);
    }

    void closeMATLABPool() {
        this.runMLCodeWithErrorHandling(CLOSE_MATLAB_POOL_OPTION, new Object[]{this.getSelectedProfileName()}, true, CLOSE_MATLAB_POOL_ERRORED, true);
    }

    void runMLCodeWithErrorHandling(String string, Object[] objectArray, final boolean bl, final String string2, final boolean bl2) {
        final ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(string);
        arrayList.addAll(Arrays.asList(objectArray));
        new MatlabWorker(){

            public Object runOnMatlabThread() throws Exception {
                return 3.feval((String)JobMonitorModel.JOB_MONITOR_HELPER_FCN, (Object[])arrayList.toArray(new Object[arrayList.size()]), (int)0, (boolean)bl);
            }

            public void runOnAWTEventDispatchThread(Object object) {
                if (bl2) {
                    JobMonitorModel.this.update();
                }
            }

            protected void handleException(Exception exception, boolean bl3) {
                if (bl3) {
                    JobMonitorModel.this.fPropertyChangeSupport.firePropertyChange(string2, null, exception.getMessage());
                    JobMonitorModel.this.update();
                } else {
                    super.handleException(exception, bl3);
                }
            }
        }.start();
    }

    void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.fPropertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    void addUpdateChangeListener(UpdateChangeListener updateChangeListener) {
        this.fUpdateChangeSupport.addUpdateChangeListener(updateChangeListener);
    }
}

