/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.ui.discover.model;

import com.mathworks.toolbox.distcomp.ui.discover.DiscoverClusterData;
import com.mathworks.toolbox.distcomp.ui.model.PropertyChangeSupportAdaptor;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;

public final class DiscoverClusterWizardModel
extends PropertyChangeSupportAdaptor {
    private final AtomicBoolean fHasUserStoppedDiscovery;
    private final List<DiscoverClusterData> fDiscoveredClusterList = new Vector<DiscoverClusterData>();
    private String fCreatedProfileName = null;
    private boolean fCreatedProfileAsDefault = true;
    private DiscoverClusterData fSelectedCluster = null;
    private boolean fDiscoverCloud = false;
    private boolean fDiscoverNetwork = true;
    public static final String SELECTED_CLUSTER_CHANGED = "SelectedCluster";
    public static final String SET_AS_DEFAULT_PROPERTY_CHANGED = "SetAsDefault";
    public static final String PROFILE_NAME_CHANGED = "ProfileName";
    public static final String CLUSTER_LIST_CHANGED = "ClusterList";
    public static final String DISCOVER_CLOUD_CHANGED = "DiscoverCloud";
    public static final String DISCOVER_NETWORK_CHANGED = "DiscoverNetwork";
    public static final String DISCOVERY_STARTED = "DiscoveryStarted";
    public static final String DISCOVERY_DONE = "DiscoveryDone";
    public static final String DISCOVERY_FAILED = "DiscoveryFailed";

    public DiscoverClusterWizardModel() {
        this.fHasUserStoppedDiscovery = new AtomicBoolean(false);
    }

    public String getCreatedProfileName() {
        return this.fCreatedProfileName;
    }

    public void setCreatedProfileName(String string) {
        String string2 = this.fCreatedProfileName;
        this.fCreatedProfileName = string;
        this.firePropertyChange(PROFILE_NAME_CHANGED, string2, this.fCreatedProfileName);
    }

    public boolean isCreatedProfileAsDefault() {
        return this.fCreatedProfileAsDefault;
    }

    public void setCreatedProfileAsDefault(boolean bl) {
        boolean bl2 = this.fCreatedProfileAsDefault;
        this.fCreatedProfileAsDefault = bl;
        this.firePropertyChange(SET_AS_DEFAULT_PROPERTY_CHANGED, bl2, this.fCreatedProfileAsDefault);
    }

    public List<DiscoverClusterData> getDiscoveredClusters() {
        return Collections.unmodifiableList(this.fDiscoveredClusterList);
    }

    public void addCluster(DiscoverClusterData discoverClusterData) {
        this.fDiscoveredClusterList.add(discoverClusterData);
        this.firePropertyChange(CLUSTER_LIST_CHANGED, null, discoverClusterData);
    }

    public void discoveryStarted() {
        this.firePropertyChange(DISCOVERY_STARTED, false, true);
    }

    public void discoveryDone() {
        this.firePropertyChange(DISCOVERY_DONE, false, true);
    }

    public void discoveryFailed(Exception exception) {
        this.firePropertyChange(DISCOVERY_FAILED, null, exception);
    }

    public boolean hasUserCancelled() {
        return this.fHasUserStoppedDiscovery.get();
    }

    public void setUserCancelled(boolean bl) {
        this.fHasUserStoppedDiscovery.set(bl);
    }

    public DiscoverClusterData getSelectedCluster() {
        return this.fSelectedCluster;
    }

    public void setSelectedCluster(DiscoverClusterData discoverClusterData) {
        DiscoverClusterData discoverClusterData2 = this.fSelectedCluster;
        this.fSelectedCluster = discoverClusterData;
        this.firePropertyChange(SELECTED_CLUSTER_CHANGED, discoverClusterData2, this.fSelectedCluster);
    }

    public boolean isDiscoverCloud() {
        return this.fDiscoverCloud;
    }

    public void setDiscoverCloud(boolean bl) {
        this.fDiscoverCloud = bl;
        this.firePropertyChange(DISCOVER_CLOUD_CHANGED, null, this.fDiscoverCloud);
    }

    public boolean isDiscoverNetwork() {
        return this.fDiscoverNetwork;
    }

    public void setDiscoverNetwork(boolean bl) {
        this.fDiscoverNetwork = bl;
        this.firePropertyChange(DISCOVER_NETWORK_CHANGED, null, this.fDiscoverNetwork);
    }
}

