/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.ui.desk;

import com.mathworks.mlwidgets.prefs.ConfirmationDialogPrefsPanel;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.services.settings.SettingAccessException;
import com.mathworks.services.settings.SettingNotFoundException;
import com.mathworks.services.settings.SettingTypeException;
import com.mathworks.services.settings.SettingValidationException;
import com.mathworks.toolbox.distcomp.pmode.SessionInfo;
import com.mathworks.toolbox.distcomp.ui.PackageInfo;
import com.mathworks.toolbox.distcomp.ui.desk.ConfirmationDialogPreference;
import com.mathworks.toolbox.distcomp.ui.model.ParallelSettings;
import com.mathworks.toolbox.distcomp.ui.panel.AbstractStyleGuidePanel;
import com.mathworks.toolbox.distcomp.ui.panel.StyleGuidePanel;
import com.mathworks.toolbox.parallel.pctutil.logging.DistcompLevel;
import com.mathworks.widgets.Dialogs;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public final class RestartPoolConfirmationDialog {
    private static final ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.toolbox.distcomp.ui.resources.RES_ui");
    private static final ResourceBundle sRes_Localized = ResourceBundle.getBundle("com.mathworks.toolbox.distcomp.ui.resources.RES_desk_localized");
    private static final ResourceBundle sRes_NoTranslation = ResourceBundle.getBundle("com.mathworks.toolbox.distcomp.ui.resources.RES_ui_notranslation");
    private static final Object[] NO_INPUT = new Object[0];
    private static final int PREFERRED_DIALOG_WIDTH = 450;
    private static final int PREFERRED_DIALOG_HEIGHT = 75;
    private static final int PREFERRED_DIALOG_HEIGHT_LARGE = 100;
    private static final int LONG_NAME_FOR_CLUSTER = 10;

    private RestartPoolConfirmationDialog() {
    }

    private static boolean showDialogForPrefSizeChange(Window window) throws SettingNotFoundException {
        assert (SwingUtilities.isEventDispatchThread()) : "This should be called from an EDT thread";
        int n = MJOptionPane.showConfirmDialog((Component)window, (Object)((Object)RestartPoolConfirmationDialog.createMessage(ConfirmationDialogPreference.RESTART_ON_PREFERRED_SIZE_CHANGE, NO_INPUT)), (String)sRes.getString("RestartPoolDialog.Title"), (int)0, (int)2);
        return n == 0;
    }

    private static boolean showDialogForClusterChange(Window window, String string, String string2) throws SettingNotFoundException {
        int n;
        block4: {
            assert (SwingUtilities.isEventDispatchThread()) : "This should be called from an EDT thread";
            n = Dialogs.showOptionalConfirmDialog((Component)window, (Object)((Object)RestartPoolConfirmationDialog.createMessage(ConfirmationDialogPreference.RESTART_ON_CLUSTER_CHANGE, new Object[]{string, string2})), (String)sRes.getString("RestartPoolDialog.Title"), (int)2, (int)2, (String)ConfirmationDialogPreference.RESTART_ON_CLUSTER_CHANGE.getPreferenceKey(), (int)0, (boolean)true);
            if (n == 0) {
                try {
                    ParallelSettings parallelSettings = new ParallelSettings();
                    parallelSettings.setRestartOnClusterChange(true);
                }
                catch (SettingAccessException | SettingNotFoundException | SettingTypeException | SettingValidationException throwable) {
                    PackageInfo.LOGGER.log(DistcompLevel.ONE, "Unable to update the preferences.", throwable);
                    if ($assertionsDisabled) break block4;
                    throw new AssertionError((Object)("Unable to update the preferences. Caused by:" + throwable));
                }
            }
        }
        return n == 0;
    }

    static boolean isOkToRestartDuePreferredNumWorkerChange(Window window, SessionInfo sessionInfo, int n, int n2) {
        try {
            return n != n2 && sessionInfo.getSize() != n2 && !sessionInfo.getState().equals((Object)SessionInfo.SessionState.CLOSED) && !sessionInfo.getState().equals((Object)SessionInfo.SessionState.FAILED_TO_START) && sessionInfo.getRestartOnPreferredNumWorkersChange() && RestartPoolConfirmationDialog.showDialogForPrefSizeChange(window);
        }
        catch (SettingNotFoundException settingNotFoundException) {
            return true;
        }
    }

    public static boolean isOkToChangeDefaultProfile(Window window, SessionInfo sessionInfo, String string, String string2) {
        if (string.equals(string2)) {
            return false;
        }
        if (!sessionInfo.getRestartOnClusterChange()) {
            return true;
        }
        switch (sessionInfo.getState()) {
            case STARTING: 
            case BUSY: 
            case IDLE: {
                try {
                    String string3 = sessionInfo.getProfileName();
                    return RestartPoolConfirmationDialog.showDialogForClusterChange(window, string3, string2);
                }
                catch (SettingNotFoundException settingNotFoundException) {
                    PackageInfo.LOGGER.log(DistcompLevel.ONE, "Unable to change default profile", settingNotFoundException);
                    return true;
                }
            }
            case FAILED_TO_START: {
                return true;
            }
            case CLOSED: {
                return true;
            }
        }
        return false;
    }

    private static AbstractStyleGuidePanel createMessage(ConfirmationDialogPreference confirmationDialogPreference, Object[] objectArray) {
        StyleGuidePanel styleGuidePanel = new StyleGuidePanel(){

            @Override
            protected int getTopInset() {
                return 0;
            }

            @Override
            protected int getBottomInset() {
                return 0;
            }

            @Override
            protected int getLeftInset() {
                return 0;
            }

            @Override
            protected int getRightInset() {
                return 0;
            }
        };
        switch (confirmationDialogPreference) {
            case RESTART_ON_CLUSTER_CHANGE: {
                String string = (String)objectArray[0];
                String string2 = (String)objectArray[1];
                MJLabel mJLabel = new MJLabel(MessageFormat.format(sRes.getString("RestartPoolDialog.ClusterChanged.Label"), string, string2));
                String string3 = MessageFormat.format(sRes.getString("RestartPoolDialog.ClusterChanged.ShutDownPoolLabel"), string2);
                MJLabel mJLabel2 = new MJLabel(string3);
                styleGuidePanel.addLine((JComponent)mJLabel);
                styleGuidePanel.addLine((JComponent)mJLabel2);
                styleGuidePanel.addLine(new JPanel(), 8);
                if (string.length() > 10 || string2.length() > 10) {
                    styleGuidePanel.setPreferredSize(new Dimension(450, 100));
                    break;
                }
                styleGuidePanel.setPreferredSize(new Dimension(450, 75));
                break;
            }
            case RESTART_ON_PREFERRED_SIZE_CHANGE: {
                MJLabel mJLabel = new MJLabel(sRes.getString("RestartDialog.PreferredSizeChanged.Label"));
                MJLabel mJLabel3 = new MJLabel(sRes.getString("RestartPoolDialog.PreferredSizeChanged.ShutDownPoolLabel"));
                styleGuidePanel.addLine((JComponent)mJLabel);
                styleGuidePanel.addLine((JComponent)mJLabel3);
                styleGuidePanel.addLine(new JPanel(), 8);
            }
        }
        return styleGuidePanel;
    }

    public static ConfirmationDialogPrefsPanel.DialogItem[] getDialogItems() {
        return new ConfirmationDialogPrefsPanel.DialogItem[]{new ConfirmationDialogPrefsPanel.DialogItem(sRes_Localized.getString("Preference.ConfirmDialog.RestartPool.ClusterChange"), ConfirmationDialogPreference.RESTART_ON_CLUSTER_CHANGE.getPreferenceKey(), sRes_NoTranslation.getString("ProductName"), true)};
    }
}

