/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.ui.desk;

import com.mathworks.desktop.attr.Attribute;
import com.mathworks.mde.desk.MLDesktop;
import com.mathworks.mlservices.MatlabDesktopServices;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.toolbox.distcomp.ui.desk.ClientSessionInfoProvider;
import com.mathworks.toolbox.distcomp.ui.desk.RestartPoolConfirmationDialog;
import com.mathworks.toolbox.distcomp.ui.discover.DiscoverClusterWizard;
import com.mathworks.toolbox.distcomp.ui.profile.ProfileManagerUI;
import com.mathworks.toolbox.distcomp.ui.profile.model.DefaultProfileName;
import com.mathworks.toolbox.distcomp.ui.profile.model.ProfileManager;
import com.mathworks.toolbox.distcomp.ui.profile.model.ProfileNamesProvider;
import com.mathworks.toolbox.distcomp.ui.profile.model.SettingsDefaultProfileName;
import com.mathworks.toolbox.distcomp.ui.profile.model.SettingsProfileNamesProvider;
import com.mathworks.toolbox.distcomp.ui.profile.model.ValidationManager;
import com.mathworks.toolstrip.components.PopupListener;
import com.mathworks.toolstrip.components.popups.ListActionEvent;
import com.mathworks.toolstrip.components.popups.ListActionListener;
import com.mathworks.toolstrip.components.popups.ListItem;
import com.mathworks.toolstrip.components.popups.ListStyle;
import com.mathworks.toolstrip.components.popups.PopupList;
import com.mathworks.widgets.desk.DTFrame;
import com.mathworks.widgets.desk.DTWindowCloser;
import com.mathworks.widgets.login.LoginDialogConsumer;
import com.mathworks.widgets.login.ValidationConsumer;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class ProfileDesktopMenuProvider {
    private static final ProfileNamesProvider sProfileNamesProvider = new SettingsProfileNamesProvider();
    private static final DefaultProfileName sDefaultProfile = new SettingsDefaultProfileName();
    private static ProfileManagerUI sProfileManagerUI;
    private static final ResourceBundle sRes;

    private ProfileDesktopMenuProvider() {
    }

    static void populate(JMenu jMenu) {
        block2: {
            try {
                JMenu jMenu2 = ProfileDesktopMenuProvider.getSetDefaultProfileMenu();
                JMenuItem jMenuItem = ProfileDesktopMenuProvider.getLaunchProfileManagerMenuItem();
                JMenuItem jMenuItem2 = ProfileDesktopMenuProvider.getDiscoverMenuItem();
                jMenu.add(jMenu2);
                jMenu.add(jMenuItem2);
                jMenu.add(jMenuItem);
            }
            catch (Exception exception) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)exception);
            }
        }
    }

    static ListItem addProfileManagerListItem(PopupList popupList) {
        ListItem listItem = ProfileDesktopMenuProvider.addItemToPopupList(popupList, "ParallelMenu.LaunchProfileManager", sRes.getString("HomeTab.Parallel.ProfileManager.Label"), ProfileDesktopMenuProvider.createLaunchProfileManagerUIAction());
        return listItem;
    }

    static ListItem addDiscoverClusterListItem(PopupList popupList) {
        ListItem listItem = ProfileDesktopMenuProvider.addItemToPopupList(popupList, "ParallelMenu.DiscoverCluster", sRes.getString("HomeTab.Parallel.DiscoverClusters.Label"), ProfileDesktopMenuProvider.createDiscoverClustersAction());
        return listItem;
    }

    private static JMenuItem getLaunchProfileManagerMenuItem() {
        return new JMenuItem((Action)ProfileDesktopMenuProvider.createLaunchProfileManagerUIAction());
    }

    private static MJAbstractAction createLaunchProfileManagerUIAction() {
        return new MJAbstractAction(sRes.getString("ParallelMenu.ProfileManager.MenuItem.Label")){

            public void actionPerformed(ActionEvent actionEvent) {
                ProfileDesktopMenuProvider.showProfileManagerUI();
            }
        };
    }

    private static JMenu getSetDefaultProfileMenu() {
        JMenu jMenu = new JMenu(sRes.getString("ParallelMenu.SetDefault.MenuItem.Label"));
        jMenu.setName("SetDefaultProfileMenu");
        ProfileDesktopMenuProvider.updateDefaultProfileMenu(jMenu);
        return jMenu;
    }

    static ListItem addCurrentClusterListItem(PopupList popupList) {
        DefaultListModel defaultListModel = (DefaultListModel)popupList.getModel();
        final PopupList popupList2 = new PopupList(new DefaultListModel());
        ListItem listItem = ListItem.newSubList((String)"ParallelMenu.SelectClusterProfile", (String)sRes.getString("HomeTab.Parallel.SetDefault.Label"), null, (PopupListener)new PopupListener(){

            public void onPopupEvent(JComponent jComponent, PopupListener.PopupCallback popupCallback) {
                popupCallback.show((JComponent)popupList2);
            }
        });
        listItem.setAttribute((Attribute)ListItem.STYLE, (Object)ListStyle.TEXT_ONLY);
        defaultListModel.addElement(listItem);
        ProfileDesktopMenuProvider.updateSetDefaultPopupList(popupList2);
        return listItem;
    }

    private static void updateSetDefaultPopupList(PopupList popupList) {
        ((DefaultListModel)popupList.getModel()).removeAllElements();
        ProfileDesktopMenuProvider.createProfileListItems(popupList);
    }

    private static void createProfileListItems(PopupList popupList) {
        String string = sDefaultProfile.getDefaultProfileName();
        List<String> list = ProfileDesktopMenuProvider.getSortedProfileNames();
        for (final String string2 : list) {
            MJAbstractAction mJAbstractAction = new MJAbstractAction(string2){

                public void actionPerformed(ActionEvent actionEvent) {
                    DTFrame dTFrame = MLDesktop.getInstance().getMainFrame();
                    if (RestartPoolConfirmationDialog.isOkToChangeDefaultProfile((Window)dTFrame, ClientSessionInfoProvider.getInstance().getSessionInfo(), sDefaultProfile.getDefaultProfileName(), string2)) {
                        sDefaultProfile.setDefaultProfileName(string2);
                    }
                }
            };
            ListItem listItem = ProfileDesktopMenuProvider.addItemToPopupList(popupList, "ParallelMenu." + string2, string2, mJAbstractAction);
            listItem.setAttribute((Attribute)ListItem.HAS_CHECKBOX, (Object)true);
            listItem.setAttribute((Attribute)ListItem.CHECKVALUE_STATE, (Object)string2.equals(string));
        }
    }

    private static List<String> getSortedProfileNames() {
        List<String> list = Arrays.asList(sProfileNamesProvider.getProfileNames());
        Collections.sort(list, String.CASE_INSENSITIVE_ORDER);
        return list;
    }

    public static ProfileManagerUI getProfileManagerUI() {
        if (sProfileManagerUI == null) {
            ValidationManager validationManager = new ValidationManager((LoginDialogConsumer)new ValidationConsumer(){

                public boolean hasDisplay() {
                    return true;
                }

                public Component getInvoker() {
                    return sProfileManagerUI;
                }
            });
            sProfileManagerUI = new ProfileManagerUI(ProfileDesktopMenuProvider.getProfileManager(), validationManager, ClientSessionInfoProvider.getInstance());
            MatlabDesktopServices.getDesktop().getWindowRegistry().addCloser(new DTWindowCloser(){

                public boolean canClose() {
                    return true;
                }

                public void close() {
                    if (sProfileManagerUI.isDisplayable()) {
                        sProfileManagerUI.setVisible(false);
                    }
                }
            });
            validationManager.initialize();
        }
        return sProfileManagerUI;
    }

    public static ProfileManager getProfileManager() {
        return ProfileManager.Provider.INSTANCE.getProfileManager();
    }

    public static void showProfileManagerUI() {
        if (ProfileDesktopMenuProvider.getProfileManagerUI().isVisible()) {
            ProfileDesktopMenuProvider.getProfileManagerUI().toFront();
        } else {
            ProfileDesktopMenuProvider.getProfileManagerUI().setLocationRelativeTo(null);
            ProfileDesktopMenuProvider.getProfileManagerUI().setVisible(true);
        }
    }

    private static void updateDefaultProfileMenu(JMenu jMenu) {
        jMenu.removeAll();
        String string = sDefaultProfile.getDefaultProfileName();
        List<String> list = ProfileDesktopMenuProvider.getSortedProfileNames();
        for (final String string2 : list) {
            String string3 = string2.equals(string) ? MessageFormat.format(sRes.getString("HomeTab.Parallel.DefaultProfile.Label"), string2) : string2;
            JMenuItem jMenuItem = new JMenuItem(string3);
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    sDefaultProfile.setDefaultProfileName(string2);
                }
            });
            jMenu.add(jMenuItem);
            jMenuItem.setName(string2 + "MenuItem");
        }
    }

    private static JMenuItem getDiscoverMenuItem() {
        return new JMenuItem((Action)ProfileDesktopMenuProvider.createDiscoverClustersAction());
    }

    private static MJAbstractAction createDiscoverClustersAction() {
        return new MJAbstractAction(sRes.getString("ParallelMenu.DiscoverClusters.MenuItem.Label")){

            public void actionPerformed(ActionEvent actionEvent) {
                DiscoverClusterWizard.launchWizard((Window)MLDesktop.getInstance().getMainFrame());
            }
        };
    }

    private static ListItem addItemToPopupList(PopupList popupList, String string, String string2, final MJAbstractAction mJAbstractAction) {
        DefaultListModel defaultListModel = (DefaultListModel)popupList.getModel();
        final ListItem listItem = ListItem.newItem((String)string, (String)string2);
        listItem.setAttribute((Attribute)ListItem.STYLE, (Object)ListStyle.TEXT_ONLY);
        defaultListModel.addElement(listItem);
        popupList.addListActionListener(new ListActionListener(){

            public void listItemSelected(ListActionEvent listActionEvent) {
                if (mJAbstractAction != null && listActionEvent.getListItem().equals((Object)listItem)) {
                    mJAbstractAction.actionPerformed(null);
                }
            }
        });
        return listItem;
    }

    static {
        sRes = ResourceBundle.getBundle("com.mathworks.toolbox.distcomp.ui.resources.RES_desk_localized");
    }
}

