/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.ui.desk;

import com.mathworks.mlservices.MatlabDesktopServices;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.toolbox.distcomp.ui.jobmonitor.JobMonitorUI;
import com.mathworks.toolbox.distcomp.ui.profile.model.ProfileManager;
import com.mathworks.widgets.desk.DTClientAdapter;
import com.mathworks.widgets.desk.DTClientBase;
import com.mathworks.widgets.desk.DTClientEvent;
import com.mathworks.widgets.desk.DTClientListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ResourceBundle;

public final class JobMonitorDesktopClient
extends DTClientBase {
    private static JobMonitorDesktopClient sInstance;
    private JobMonitorUI fJobMonitorUI;
    private static final String NON_LOCALISED_TITLE = "Job Monitor";
    private static final ResourceBundle sRes;

    private JobMonitorDesktopClient() {
        this.setLayout(new BorderLayout());
        this.fJobMonitorUI = new JobMonitorUI(ProfileManager.Provider.INSTANCE.getProfileManager());
        MJScrollPane mJScrollPane = new MJScrollPane((Component)((Object)this.fJobMonitorUI));
        this.add((Component)mJScrollPane, "Center");
        MatlabDesktopServices.getDesktop().addClientListener(NON_LOCALISED_TITLE, (DTClientListener)new JobMonitorDTClientAdaptor());
        this.setName("JobMonitorDesktopClient");
    }

    public JobMonitorUI getJobMonitorUI() {
        return this.fJobMonitorUI;
    }

    public static JobMonitorDesktopClient getInstance() {
        if (sInstance == null) {
            sInstance = new JobMonitorDesktopClient();
        }
        return sInstance;
    }

    public static void showUI() {
        if (MatlabDesktopServices.getDesktop().getClient(sRes.getString("jobmonitor.title")) == null) {
            MatlabDesktopServices.getDesktop().addClient((Component)((Object)JobMonitorDesktopClient.getInstance()), sRes.getString("jobmonitor.title"), true, null, true);
        } else {
            MatlabDesktopServices.getDesktop().showClient(sRes.getString("jobmonitor.title"));
        }
    }

    public void updateJobMonitor(String string) {
        Component component = MatlabDesktopServices.getDesktop().getClient(sRes.getString("jobmonitor.title"));
        if (component == null) {
            JobMonitorDesktopClient.showUI();
            component = MatlabDesktopServices.getDesktop().getClient(sRes.getString("jobmonitor.title"));
        }
        if (MatlabDesktopServices.getDesktop().isClientShowing(component)) {
            this.getJobMonitorUI().updateProfile(string);
        }
    }

    static {
        sRes = ResourceBundle.getBundle("com.mathworks.toolbox.distcomp.ui.resources.RES_ui");
    }

    private static class JobMonitorDTClientAdaptor
    extends DTClientAdapter {
        private JobMonitorDTClientAdaptor() {
        }

        public void clientOpened(DTClientEvent dTClientEvent) {
            super.clientOpened(dTClientEvent);
            JobMonitorDesktopClient.getInstance().getJobMonitorUI().startAutoUpdating();
        }

        public void clientClosed(DTClientEvent dTClientEvent) {
            super.clientClosed(dTClientEvent);
            JobMonitorDesktopClient.getInstance().getJobMonitorUI().stopAutoUpdating();
        }
    }
}

