/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.ui;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;

public class AWTUtilities {
    private AWTUtilities() {
    }

    public static void invokeAndWait(final Runnable runnable) throws ExecutionException, InterruptedException {
        AWTUtilities.invokeAndWait(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                runnable.run();
                return null;
            }
        }).get();
    }

    public static <V> Future<V> invokeAndWait(final Callable<V> callable) {
        final AtomicReference atomicReference = new AtomicReference();
        try {
            com.mathworks.jmi.AWTUtilities.invokeAndWait((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        atomicReference.set(new CompletedFuture(callable.call()));
                    }
                    catch (Throwable throwable) {
                        atomicReference.set(new CompletedFuture(throwable));
                    }
                }
            });
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
        return (Future)atomicReference.get();
    }

    private static class CompletedFuture<V>
    implements Future<V> {
        private final V fResult;
        private final Throwable fException;

        private CompletedFuture(V v) {
            this.fResult = v;
            this.fException = null;
        }

        private CompletedFuture(Throwable throwable) {
            this.fException = throwable;
            this.fResult = null;
        }

        @Override
        public boolean cancel(boolean bl) {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public V get() throws InterruptedException, ExecutionException {
            if (this.fException == null) {
                return this.fResult;
            }
            throw new ExecutionException(this.fException);
        }

        @Override
        public V get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.get();
        }

        @Override
        public boolean isDone() {
            return true;
        }
    }
}

